/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.ui.CommandArtifact;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.commands.TextEditorCommand;
import javax.baja.ui.util.UiLexicon;

public class FindNext
extends TextEditorCommand {
    Position foundPosition;

    public FindNext(BTextEditor bTextEditor) {
        super(bTextEditor, BKeyBindings.findNext);
    }

    public Position getFoundPosition() {
        return this.foundPosition;
    }

    public CommandArtifact doInvoke() {
        FindPattern findPattern = FindPattern.getCurrent();
        String string = findPattern.string;
        Position position = this.editor.getModel().findNext(findPattern);
        if (position != null) {
            this.foundPosition = position;
            Position position2 = new Position(position.line, position.column + string.length());
            this.editor.getSelection().select(position, position2);
            this.editor.getShell().showStatus("Line: " + (position.line + 1) + " Column: " + (position.column + 1));
        } else {
            this.editor.getShell().showStatus(UiLexicon.bajaui().getText("noMore") + ": " + string);
        }
        return null;
    }
}

