/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.commands;

import javax.baja.log.Log;
import javax.baja.sys.Property;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextSelection;
import javax.baja.ui.text.commands.TextEditorCommand;

public abstract class EditCommand
extends TextEditorCommand {
    private static Log log = Log.getLog((String)"ui.command");

    EditCommand(BTextEditor bTextEditor, Property property) {
        super(bTextEditor, property);
    }

    EditCommand(BTextEditor bTextEditor, String string) {
        super(bTextEditor, string);
    }

    CommandArtifact insert(char[] cArray) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- insert: " + TextModel.toString(cArray));
        RemoveArtifact removeArtifact = this.removeSelection();
        if (removeArtifact != null) {
            removeArtifact.redo();
        }
        Position position = this.editor.getCaretPosition();
        InsertArtifact insertArtifact = new InsertArtifact(this, position, cArray);
        insertArtifact.redo();
        return new CompoundCommand.Artifact(new CommandArtifact[]{removeArtifact, insertArtifact});
    }

    CommandArtifact remove(Position position, Position position2) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- remove");
        RemoveArtifact removeArtifact = this.removeSelection();
        if (removeArtifact == null) {
            if (position == null || position2 == null) {
                return null;
            }
            removeArtifact = new RemoveArtifact(this, position, position2);
        }
        removeArtifact.redo();
        return removeArtifact;
    }

    RemoveArtifact removeSelection() {
        TextSelection textSelection = this.editor.getSelection();
        if (!textSelection.isEmpty()) {
            Position position = textSelection.getStart();
            Position position2 = textSelection.getEnd();
            return new RemoveArtifact(this, position, position2);
        }
        return null;
    }

    CommandArtifact compose(char[] cArray, String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        if (!this.editor.isEditable()) {
            return null;
        }
        log.trace("-- compose: ComposedText=" + this.getComposedTextString(cArray) + ", CommittedText=" + string + ", composedStart=" + n + ", composedEnd=" + n2 + ", caretCharIndex=" + n3 + ", commit=" + bl + ", deleteComposed=" + bl2);
        RemoveArtifact removeArtifact = this.removeSelection();
        if (removeArtifact != null) {
            removeArtifact.redo();
        }
        ComposeArtifact composeArtifact = new ComposeArtifact(this, cArray, n, n2, string, n3, bl, bl2);
        composeArtifact.redo();
        return new CompoundCommand.Artifact(new CommandArtifact[]{removeArtifact, composeArtifact});
    }

    private String getComposedTextString(char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            String string = Integer.toHexString(c).toUpperCase();
            String string2 = "0000" + string;
            String string3 = string2.substring(string2.length() - 4);
            stringBuffer.append("\\u" + string3);
        }
        return stringBuffer.toString();
    }

    class ComposeArtifact
    extends AbstractEditArtifact {
        private Position origPos;
        private Position origCaretPos;
        private char[] text;
        private String committedText = null;
        private int composedStart;
        private int composedEnd;
        private int origComposedStart;
        private int origComposedEnd;
        private int caretCharacterIndex;
        private boolean commit;
        private boolean deleteComposed;
        private char[] origText = null;

        ComposeArtifact(EditCommand editCommand2, char[] cArray, int n, int n2, String string, int n3, boolean bl, boolean bl2) {
            super(editCommand2);
            this.text = cArray;
            this.commit = bl;
            this.committedText = string;
            this.deleteComposed = bl2;
            this.composedStart = n;
            this.composedEnd = n2;
            this.caretCharacterIndex = n3;
            log.trace("  ComposeArtifact<init>: " + TextModel.toString(cArray));
            TextController textController = this.editor.getController();
            this.origPos = textController.getComposedPosition();
            if (this.origPos == null) {
                this.origPos = this.editor.getCaretPosition();
                if (cArray.length > 0) {
                    log.trace("  Set the cached composedOriginPos = " + this.origPos.toString());
                    textController.setComposedPosition(this.origPos);
                }
            }
            this.origCaretPos = this.editor.getCaretPosition();
            this.origComposedStart = textController.getTextBeginIndex();
            this.origComposedEnd = textController.getTextEndIndex();
        }

        public void redo() {
            Position position;
            log.trace("  doCompose: " + this.composedStart + " to " + this.composedEnd + " at " + this.origPos + " for " + TextModel.toString(this.text) + " deleteComposed: " + this.deleteComposed + " commit: " + this.commit);
            TextController textController = this.editor.getController();
            TextModel textModel = this.editor.getModel();
            if (this.deleteComposed) {
                position = new Position(this.origPos.line, this.origPos.column + this.origComposedStart);
                Position position2 = new Position(this.origPos.line, this.origPos.column + this.origComposedEnd);
                if (!position.equals(position2)) {
                    position2 = textModel.getPrevPosition(position2);
                }
                this.origText = textModel.getCharArray(position, position2);
                log.trace("  deleteComposed " + TextModel.toString(this.origText) + " from " + position + " to " + position2);
                textModel.remove(position, position2);
            }
            if (this.commit && this.committedText != null && this.committedText.length() > 0) {
                log.trace("  insertCommitted " + this.committedText + " at " + this.origPos);
                textModel.insert(this.origPos, this.committedText.toCharArray(), 0, this.committedText.length());
                position = new Position(this.origPos.line, this.origPos.column + this.committedText.length());
                log.trace("  move caret to " + position);
                this.editor.moveCaretPosition(position);
            } else if (this.text.length > 0) {
                log.trace("  insertComposed " + TextModel.toString(this.text) + " at " + this.origPos);
                textModel.insert(this.origPos, this.text, 0, this.text.length);
                if (this.caretCharacterIndex > 0) {
                    position = new Position(this.origPos.line, this.origPos.column + this.caretCharacterIndex);
                    log.trace("  move caret to " + position);
                    this.editor.moveCaretPosition(position);
                }
            }
            if (this.commit) {
                log.trace("  Reset the cached composedOriginPos = null");
                textController.setComposedPosition(null);
                textController.setTextBeginIndex(0);
                textController.setTextEndIndex(0);
            } else {
                textController.setTextBeginIndex(this.composedStart);
                textController.setTextEndIndex(this.composedEnd);
            }
            this.editor.updateAnchorX();
        }

        public void undo() {
            Position position;
            log.trace("  undoCompose: " + this.composedStart + " to " + this.composedEnd + " at " + this.origPos + " for " + TextModel.toString(this.text) + " deleteComposed: " + this.deleteComposed + " commit: " + this.commit);
            if (this.origPos == null) {
                return;
            }
            TextController textController = this.editor.getController();
            TextModel textModel = this.editor.getModel();
            if (this.commit && this.committedText != null && this.committedText.length() > 0) {
                log.trace("  removeCommitted " + this.committedText + " at " + this.origPos);
                position = new Position(this.origPos.line, this.origPos.column + this.committedText.length());
                if (!this.origPos.equals(position)) {
                    position = textModel.getPrevPosition(position);
                }
                textModel.remove(this.origPos, position);
            } else if (this.text.length > 0) {
                log.trace("  removeComposed " + TextModel.toString(this.text) + " at " + this.origPos);
                position = new Position(this.origPos.line, this.origPos.column + this.text.length);
                if (!this.origPos.equals(position)) {
                    position = textModel.getPrevPosition(position);
                }
                textModel.remove(this.origPos, position);
            }
            if (this.origText != null) {
                position = new Position(this.origPos.line, this.origPos.column + this.composedStart);
                textModel.insert(position, this.origText, 0, this.origText.length);
            }
            if (this.origCaretPos != null) {
                this.editor.moveCaretPosition(this.origCaretPos);
            }
            this.editor.updateAnchorX();
            this.editor.getSelection().deselect();
            textController.setTextBeginIndex(this.origComposedStart);
            textController.setTextEndIndex(this.origComposedEnd);
            textController.setComposedPosition(this.origPos);
        }
    }

    class InsertArtifact
    extends AbstractEditArtifact {
        private Position origPos;
        private Position newPos;
        private char[] text;

        InsertArtifact(EditCommand editCommand2, Position position, char[] cArray) {
            super(editCommand2);
            this.origPos = position;
            this.text = cArray;
            log.trace("  InsertArtifact<init>: " + this.origPos + " -> " + TextModel.toString(cArray));
        }

        public void undo() {
            TextController textController = this.editor.getController();
            textController.setComposedPosition(this.origPos);
            this.doRemove(this.origPos, this.newPos);
        }

        public void redo() {
            TextController textController = this.editor.getController();
            textController.setComposedPosition(this.origPos);
            textController.setComposedPosition(null);
            textController.setTextBeginIndex(0);
            textController.setTextEndIndex(0);
            this.newPos = this.doInsert(this.origPos, this.text);
            this.newPos = this.editor.getModel().getPrevPosition(this.newPos);
        }
    }

    class RemoveArtifact
    extends AbstractEditArtifact {
        private Position fromPos;
        private Position toPos;
        private char[] text;

        RemoveArtifact(EditCommand editCommand2, Position position, Position position2) {
            super(editCommand2);
            if (!position.equals(position2)) {
                position2 = editCommand2.editor.getModel().getPrevPosition(position2);
            }
            this.fromPos = position;
            this.toPos = position2;
            this.text = editCommand2.editor.getModel().getCharArray(position, position2);
            log.trace("    RemoveArtifact<init>: " + position + " -> " + position2 + " -> " + TextModel.toString(this.text));
        }

        public void undo() {
            this.doInsert(this.fromPos, this.text);
        }

        public void redo() {
            this.doRemove(this.fromPos, this.toPos);
        }
    }

    static abstract class AbstractEditArtifact
    implements CommandArtifact {
        protected BTextEditor editor;

        AbstractEditArtifact(EditCommand editCommand) {
            this.editor = editCommand.editor;
        }

        protected void doRemove(Position position, Position position2) {
            log.trace("  doRemove: " + position + " -> " + position2);
            this.editor.getModel().remove(position, position2);
            this.editor.moveCaretPosition(position);
            this.editor.updateAnchorX();
            this.editor.getSelection().deselect();
            TextController textController = this.editor.getController();
            textController.setComposedPosition(null);
            textController.setTextBeginIndex(0);
            textController.setTextEndIndex(0);
        }

        protected Position doInsert(Position position, char[] cArray) {
            log.trace("  doInsert: " + position + " -> " + TextModel.toString(cArray));
            position = this.editor.getModel().insert(position, cArray, 0, cArray.length);
            this.editor.moveCaretPosition(position);
            this.editor.updateAnchorX();
            return position;
        }
    }
}

