/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;

public class TextSelection
extends BTextEditor.TextSupport {
    private Position anchor;
    private Position lead;
    private Position start;
    private Position end;

    public boolean isEmpty() {
        return this.anchor == null || this.lead == null || this.anchor.equals(this.lead);
    }

    public Position getAnchor() {
        return this.anchor;
    }

    public Position getLead() {
        return this.lead;
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public void select(Position position, Position position2) {
        this.anchor = position;
        this.lead = position2;
        if (position.compareTo(position2) < 0) {
            this.start = position;
            this.end = position2;
        } else {
            this.start = position2;
            this.end = position;
        }
        this.getEditor().moveCaretPosition(position2);
        this.updateEditor();
    }

    public void selectAll() {
        Position position;
        Position position2 = this.getModel().getStartPosition();
        if (position2.equals(position = this.getModel().getEndPosition())) {
            return;
        }
        this.anchor = this.start = position2;
        this.lead = this.end = position;
        this.getEditor().moveCaretPosition(this.start);
        this.updateEditor();
    }

    public void deselect() {
        if (this.anchor != null) {
            this.end = null;
            this.start = null;
            this.lead = null;
            this.anchor = null;
            this.updateEditor();
        }
    }

    public void updateEditor() {
        BTextEditor bTextEditor = this.getEditor();
        bTextEditor.updateEnableStates();
        bTextEditor.repaint();
        bTextEditor.fireSelectionModified(new BWidgetEvent(1, this.getEditor()));
    }
}

