/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.ui.BDropDown;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;

public class TextRenderer
extends BTextEditor.TextSupport {
    static BBrush inverseBrush = BBrush.makeInverse((BColor)BColor.black);
    BFont font;
    double cellHeight;
    double baseline;
    Position matchOpenPos;
    Position matchClosePos;

    public TextRenderer() {
        this(Theme.textEditor().getFixedWidthFont());
    }

    public TextRenderer(BFont bFont) {
        this.font = bFont;
        double d = bFont.width(".");
        double d2 = bFont.width("m");
        if (d != d2) {
            throw new IllegalStateException("Not fixed width font: " + bFont.getName());
        }
        this.cellHeight = bFont.getHeight() - 1.0;
        this.baseline = this.cellHeight - 2.0;
    }

    public double getLineHeight() {
        return this.cellHeight;
    }

    public double getLineWidth(Line line) {
        return line.getWidth(this.font);
    }

    public double getLineWidth(Line line, int n, int n2) {
        return line.getWidth(this.font, n, n2);
    }

    public double getColumnWidth(Line line, int n) {
        if (line == null || n >= line.buffer.length) {
            return this.font.width("m");
        }
        return this.font.width((int)line.buffer[n]);
    }

    public double columnToX(Line line, int n) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 = (int)((double)n2 + this.getColumnWidth(line, i));
        }
        return n2;
    }

    public int xToColumn(Line line, double d) {
        int n = line.getColumnCountWithoutNewline();
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < n; ++i) {
            d3 = this.getColumnWidth(line, i);
            if (!((d2 += d3) > d)) continue;
            double d4 = d2 - d;
            if (d4 < d3 / 2.0 && i < n - 1) {
                return i + 1;
            }
            return i;
        }
        return n;
    }

    public void paintBackground(Graphics graphics) {
        IRectGeom iRectGeom = graphics.getClipBounds();
        BInsets bInsets = this.editor.getInsets();
        double d = this.getLineHeight();
        graphics.setBrush(this.getBackground());
        if (this.editor.isSingleLine() && !(this.editor.getParent() instanceof BDropDown)) {
            graphics.fillRect(0.0, 0.0, 32000.0, d + bInsets.top + bInsets.bottom);
        } else {
            graphics.fill((IGeom)iRectGeom);
        }
    }

    public void paintLine(Graphics graphics, LineInfo lineInfo) {
        double d;
        char[] cArray = lineInfo.line.buffer;
        Segment[] segmentArray = lineInfo.line.segments;
        double d2 = 0.0;
        int n = lineInfo.selectionStartColumn;
        int n2 = lineInfo.selectionEndColumn;
        boolean bl = n >= 0;
        int n3 = lineInfo.lineIndex;
        if (this.matchOpenPos != null) {
            double d3;
            if (this.matchOpenPos.line == n3) {
                graphics.setBrush(BColor.yellow);
                d = this.getColumnWidth(lineInfo.line, this.matchOpenPos.column);
                d3 = this.columnToX(lineInfo.line, this.matchOpenPos.column);
                graphics.fillRect(d3, 0.0, d, this.cellHeight);
            }
            if (this.matchClosePos.line == n3) {
                graphics.setBrush(BColor.yellow);
                d = this.getColumnWidth(lineInfo.line, this.matchClosePos.column);
                d3 = this.columnToX(lineInfo.line, this.matchClosePos.column);
                graphics.fillRect(d3, 0.0, d, this.cellHeight);
            }
        }
        if (bl) {
            d = n2 == Integer.MAX_VALUE ? this.getEditor().getWidth() : this.columnToX(lineInfo.line, n2) - this.columnToX(lineInfo.line, n);
            graphics.setBrush(this.getSelectionBackground());
            graphics.fillRect(this.columnToX(lineInfo.line, n), 0.0, d, this.cellHeight);
        }
        graphics.setFont(this.font);
        for (int i = 0; i < segmentArray.length; ++i) {
            Segment segment = segmentArray[i];
            int n4 = segment.type;
            int n5 = segment.modifiers;
            int n6 = segment.offset;
            int n7 = segment.length;
            if (bl && n <= n6 && n6 + n7 <= n2) {
                graphics.setBrush(this.getSelectionForeground());
                d2 += this.paintSegment(graphics, d2, cArray, n4, n5, n6, n7);
                continue;
            }
            graphics.setBrush(this.getForeground(segment));
            d2 += this.paintSegment(graphics, d2, cArray, n4, n5, n6, n7);
            if (!bl || n > n6 + n7 || n6 > n2) continue;
            int n8 = n6 < n ? n : n6;
            double d4 = this.columnToX(lineInfo.line, n8);
            int n9 = Math.min(n7 - (n8 - n6), n2 - n8);
            double d5 = this.columnToX(lineInfo.line, n8 + n9) - d4;
            graphics.setBrush(this.getSelectionForeground());
            this.paintSegment(graphics, d4, cArray, n4, n5, n8, n9);
        }
    }

    public BBrush getSelectionForeground() {
        return Theme.textEditor().getSelectionForeground();
    }

    public BBrush getSelectionBackground() {
        return Theme.textEditor().getSelectionBackground();
    }

    public BBrush getBackground() {
        return Theme.textEditor().getTextBackground(this.editor);
    }

    public BBrush getForeground(Segment segment) {
        if (!this.getEditor().isEnabled() || !this.getEditor().getParentWidget().isEnabled()) {
            return Theme.textEditor().getDisabledTextBrush(this.getEditor());
        }
        return BTextEditorOptions.make().getColorCoding().getColor(segment).toBrush();
    }

    double paintSegment(Graphics graphics, double d, char[] cArray, int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                if (this.getOptions().getShowSpaces()) {
                    this.paintSpaces(graphics, d, n4);
                }
                return this.font.width(" ") * (double)n4;
            }
            case 2: {
                if (this.getOptions().getShowTabs()) {
                    this.paintTab(graphics, d);
                }
                return this.font.width("\t");
            }
            case 3: {
                if (this.getOptions().getShowNewlines()) {
                    this.paintNewline(graphics, d, n2);
                }
                return 0.0;
            }
        }
        graphics.drawString(cArray, n3, n4, d, this.baseline);
        return this.font.width(cArray, n3, n4);
    }

    void paintSpaces(Graphics graphics, double d, int n) {
        double d2 = this.font.width(" ");
        for (int i = 0; i < n; ++i) {
            graphics.strokeLine(d + 1.0, this.baseline - 1.0, d + d2 - 2.0, this.baseline - 1.0);
            d += d2;
        }
    }

    double paintTab(Graphics graphics, double d) {
        double d2 = this.font.width("\t");
        graphics.strokeLine(d + 1.0, 2.0, d2 - 3.0, this.baseline - 3.0);
        return d + d2;
    }

    void paintNewline(Graphics graphics, double d, int n) {
        double d2 = d + 1.0;
        double d3 = 2.0;
        double d4 = this.font.width("n") - 2.0;
        double d5 = this.baseline - 3.0;
        if ((n & 1) != 0) {
            graphics.drawString("n", d2, this.baseline);
        } else if ((n & 2) != 0) {
            graphics.drawString("r", d2, this.baseline);
        } else {
            graphics.strokeRect(d2, d3, d4, d5);
        }
    }

    public void paintCaret(Graphics graphics, LineInfo lineInfo, int n) {
        graphics.setBrush(inverseBrush);
        graphics.fillRect(this.columnToX(lineInfo.line, n), 0.0, 2.0, this.cellHeight - 1.0);
    }

    public static class LineInfo {
        public Line line;
        public int lineIndex;
        public int selectionStartColumn;
        public int selectionEndColumn;
    }
}

