/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.util.ArrayList;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Segment;

public class TextParser
extends BTextEditor.TextSupport {
    protected char[] buffer;
    protected int length;
    protected int lineStart;
    protected int segmentStart;
    protected int pos;
    protected int lastLast = -1;
    protected int last = -1;
    protected int current = -1;
    protected int next = -1;

    public synchronized Line[] parse(char[] cArray) {
        this.buffer = cArray;
        this.length = cArray.length;
        this.pos = 0;
        this.last = -1;
        this.current = this.length > 0 ? cArray[0] : -1;
        this.next = this.length > 1 ? cArray[1] : -1;
        this.segmentStart = 0;
        this.lineStart = 0;
        ArrayList<Line> arrayList = new ArrayList<Line>();
        ArrayList<Segment> arrayList2 = new ArrayList<Segment>();
        while (this.pos < this.length) {
            Segment segment = this.nextSegment();
            arrayList2.add(segment);
            if (segment.type == 3) {
                int n = this.pos - this.lineStart;
                if (segment.modifiers == 4) {
                    --n;
                }
                arrayList.add(new Line(cArray, this.lineStart, n, arrayList2));
                arrayList2.clear();
                this.lineStart = this.pos;
            }
            this.segmentStart = this.pos;
        }
        if (arrayList2.size() > 0) {
            arrayList.add(new Line(cArray, this.lineStart, cArray.length - this.lineStart, arrayList2));
        }
        if (arrayList.size() == 0) {
            arrayList.add(new Line(new char[0], new Segment[0]));
        }
        return arrayList.toArray(new Line[arrayList.size()]);
    }

    protected Segment nextSegment() {
        Segment segment = this.parseWhitespace();
        if (segment != null) {
            return segment;
        }
        int n = this.current;
        while (n != 32 && n != 10 && n != 13 && n != 9 && this.advance()) {
            n = this.current;
        }
        return this.newSegment(0, 8);
    }

    protected Segment parseWhitespace() {
        int n = this.current;
        if (n == 10 || n == 13) {
            int n2 = 1;
            int n3 = this.pos;
            if (n == 13) {
                n2 = 2;
                this.buffer[n3] = 10;
                if (this.next == 10) {
                    this.advance();
                    n2 = 4;
                }
            }
            this.advance();
            return new Segment(3, n2, n3 - this.lineStart, 1);
        }
        if (n == 32 || n == 9) {
            boolean bl = true;
            while (this.current == 32 || this.current == 9) {
                if (this.current == 9) {
                    this.buffer[this.pos] = 32;
                }
                this.advance();
            }
            return this.newSegment(1);
        }
        return null;
    }

    protected final Segment newSegment(int n) {
        return new Segment(n, this.segmentStart - this.lineStart, this.pos - this.segmentStart);
    }

    protected final Segment newSegment(int n, int n2) {
        return new Segment(n, n2, this.segmentStart - this.lineStart, this.pos - this.segmentStart);
    }

    protected final int getSegmentOffset() {
        return this.segmentStart - this.lineStart;
    }

    protected final int getSegmentLength() {
        return this.pos - this.segmentStart - 1;
    }

    protected final boolean advance() {
        ++this.pos;
        this.lastLast = this.last;
        this.last = this.current;
        this.current = this.next;
        this.next = this.pos + 1 < this.length ? this.buffer[this.pos + 1] : -1;
        return this.current != -1;
    }

    protected boolean isCurrent(String string) {
        int n;
        int n2 = string.length();
        if (this.pos + n2 >= this.length) {
            return false;
        }
        for (n = 0; n < n2; ++n) {
            if (this.buffer[this.pos + n] == string.charAt(n)) continue;
            return false;
        }
        for (n = 0; n < n2; ++n) {
            this.advance();
        }
        return true;
    }
}

