/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.FindPattern;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;

public class TextModel
extends BTextEditor.TextSupport {
    private String text;
    private Line[] lines = new Line[]{new Line(new char[0], new Segment[0])};
    double prefWidth;
    double prefHeight;
    int textLength = 0;
    double anchorX = 0.0;

    public int getLineCount() {
        return this.lines.length;
    }

    public Line getLine(int n) {
        try {
            if (n >= this.lines.length) {
                return this.lines[this.lines.length - 1];
            }
            if (n < 0) {
                return this.lines[0];
            }
            return this.lines[n];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.out.println("ERROR TextModel.getLine(" + n + ") length=" + this.lines.length);
            throw arrayIndexOutOfBoundsException;
        }
    }

    public String getText() {
        if (this.text == null) {
            try {
                StringWriter stringWriter = new StringWriter();
                this.write(stringWriter);
                this.text = stringWriter.toString();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                throw new IllegalStateException(iOException.toString());
            }
        }
        return this.text;
    }

    public String getText(Position position, Position position2) {
        return new String(this.getCharArray(position, position2));
    }

    public char[] getCharArray(Position position, Position position2) {
        if (position2.compareTo(position) < 0) {
            throw new IllegalArgumentException("toPos < fromPos");
        }
        char[] cArray = new char[256];
        int n = 0;
        for (int i = position.line; i <= position2.line; ++i) {
            int n2;
            Line line = this.getLine(i);
            int n3 = line.buffer.length;
            int n4 = i == position2.line ? Math.min(position2.column, n3 - 1) : n3 - 1;
            int n5 = n4 - (n2 = i == position.line ? Math.min(position.column, n3 - 1) : 0) + 1;
            if (n + n5 >= cArray.length) {
                char[] cArray2 = new char[Math.max(n * 2, n + n5)];
                System.arraycopy(cArray, 0, cArray2, 0, n);
                cArray = cArray2;
            }
            try {
                if (n2 < 0) continue;
                System.arraycopy(line.buffer, n2, cArray, n, n5);
                n += n5;
                continue;
            }
            catch (RuntimeException runtimeException) {
                System.out.println("ERROR: TextModel.getCharArray(" + position + "," + position2 + ")");
                System.out.println("  q          = " + i);
                System.out.println("  buf.length = " + cArray.length);
                System.out.println("  count      = " + n);
                System.out.println("  len        = " + n5);
                System.out.println("  lineLen    = " + n3);
                System.out.println("  c1         = " + n2);
                System.out.println("  c2         = " + n4);
                System.out.println("  e          = " + runtimeException);
                throw runtimeException;
            }
        }
        char[] cArray3 = new char[n];
        System.arraycopy(cArray, 0, cArray3, 0, n);
        return cArray3;
    }

    public void setText(String string) {
        this.update(string.toCharArray());
        this.text = string;
    }

    public double getAnchorX() {
        return this.anchorX;
    }

    public void setAnchorX(double d) {
        this.anchorX = d;
    }

    public void read(Reader reader, int n) throws IOException {
        int n2;
        char[] cArray = new char[n];
        for (int i = 0; i < n; i += n2) {
            n2 = reader.read(cArray, i, n - i);
            if (n2 >= 0) continue;
            throw new IOException("Unexpected EOF: " + this);
        }
        this.update(cArray);
    }

    public void read(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[256];
        while ((n = reader.read(cArray)) >= 0) {
            charArrayWriter.write(cArray, 0, n);
        }
        this.update(charArrayWriter.toCharArray());
    }

    public void read(char[] cArray) {
        this.update(cArray);
    }

    public void write(Writer writer) throws IOException {
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i].write(writer);
        }
    }

    public Position getStartPosition() {
        return new Position(0, 0);
    }

    public Position getEndPosition() {
        int n = this.getLineCount() - 1;
        return new Position(n, this.getLine(n).getColumnCount());
    }

    public Position getPrevPosition(Position position) {
        int n = position.column - 1;
        int n2 = position.line;
        if (n < 0) {
            if (n2 == 0) {
                return this.getStartPosition();
            }
            n = this.getLine(--n2).getColumnCount() - 1;
        }
        return new Position(n2, n);
    }

    public Position getNextPosition(Position position) {
        return new Position(position.line, position.column + 1);
    }

    public Position getWordLeft(Position position) {
        block1: {
            Position position2;
            Segment segment;
            int n = position.line;
            int n2 = this.lines[n].getSegmentIndexAt(position.column);
            n2 = n2 == -1 ? this.lines[n].segments.length : ++n2;
            do {
                if (--n2 >= 0) continue;
                if (--n < 0) break block1;
                n2 = this.lines[n].segments.length - 1;
            } while (!(segment = this.lines[n].segments[n2]).isWord() || (position2 = new Position(n, segment.offset)).equals(position));
            return position2;
        }
        return this.getStartPosition();
    }

    public Position getWordRight(Position position) {
        block7: {
            Segment segment;
            boolean bl = this.editor.getOptions().getWordRightToEndOfWord();
            int n = position.line;
            int n2 = this.getLine(n).getSegmentIndexAt(position.column);
            if (n2 == -1) {
                n2 = this.lines[n].segments.length;
            } else if (bl) {
                --n2;
            }
            if (!bl && n2 == this.lines[n].segments.length - 2) {
                Segment segment2 = this.lines[n].segments[n2];
                return new Position(n, segment2.offset + segment2.length);
            }
            while (true) {
                if (++n2 >= this.lines[n].segments.length) {
                    if (++n < this.lines.length) {
                        n2 = 0;
                        if (this.lines[n].segments.length <= 1) continue;
                    }
                    break block7;
                }
                if ((segment = this.lines[n].segments[n2]).isWord()) break;
            }
            return new Position(n, bl ? segment.offset + segment.length : segment.offset);
        }
        return this.getEndPosition();
    }

    public Position findNext(FindPattern findPattern) {
        String string = findPattern.string;
        if (string == null || string.length() == 0) {
            return null;
        }
        Position position = this.getEditor().getCaretPosition();
        int n = position.column;
        int n2 = string.length();
        for (int i = position.line; i < this.lines.length; ++i) {
            char[] cArray = this.lines[i].buffer;
            int n3 = findPattern.findNext(cArray, n, cArray.length - n);
            if (n3 != -1) {
                return new Position(i, n3);
            }
            n = 0;
        }
        return null;
    }

    public Position findPrev(FindPattern findPattern) {
        String string = findPattern.string;
        if (string == null || string.length() == 0) {
            return null;
        }
        Position position = this.getEditor().getCaretPosition();
        int n = string.length();
        for (int i = position.line; i >= 0; --i) {
            int n2;
            char[] cArray = this.lines[i].buffer;
            int n3 = cArray.length - n;
            if (i == position.line && position.column - 1 < cArray.length) {
                n3 = position.column - n - 1;
            }
            if ((n2 = findPattern.findPrev(cArray, n3, cArray.length - n3)) == -1) continue;
            return new Position(i, n2);
        }
        return null;
    }

    public Position insert(Position position, String string) {
        char[] cArray = string.toCharArray();
        return this.insert(position, cArray, 0, cArray.length);
    }

    public Position insert(Position position, char[] cArray, int n, int n2) {
        if (position.line >= this.lines.length) {
            throw new IllegalArgumentException("Position out of bounds: " + position);
        }
        Line line = this.lines[position.line];
        char[] cArray2 = line.toCharArrayGrowAsNeeded(position.column);
        char[] cArray3 = new char[cArray2.length + n2];
        System.arraycopy(cArray2, 0, cArray3, 0, position.column);
        int n3 = position.column;
        System.arraycopy(cArray, n, cArray3, n3, n2);
        n3 += n2;
        if (cArray2.length > position.column) {
            System.arraycopy(cArray2, position.column, cArray3, n3, cArray2.length - position.column);
        }
        this.splice(position.line, 1, cArray3);
        int n4 = position.line;
        int n5 = position.column;
        for (int i = 0; i < n2 && n4 < this.lines.length; ++i) {
            if (++n5 < this.lines[n4].buffer.length) continue;
            ++n4;
            n5 = 0;
        }
        if (n4 >= this.lines.length) {
            return this.getEndPosition();
        }
        return new Position(n4, n5);
    }

    public void remove(Position position, Position position2) {
        if (position2.compareTo(position) < 0) {
            throw new IllegalArgumentException("toPosition < fromPosition");
        }
        Line line = this.lines[position.line];
        Line line2 = this.lines[position2.line];
        char[] cArray = line.toCharArrayGrowAsNeeded(position.column);
        int n = position.column;
        char[] cArray2 = line2.toCharArrayGrowAsNeeded(position2.column);
        int n2 = cArray2.length - position2.column - 1;
        if (n + n2 < 0) {
            return;
        }
        char[] cArray3 = new char[n + n2];
        if (n >= 0 && n2 >= 0) {
            System.arraycopy(cArray, 0, cArray3, 0, n);
            System.arraycopy(cArray2, position2.column + 1, cArray3, position.column, n2);
            this.splice(position.line, position2.line - position.line + 1, cArray3);
        }
    }

    private void splice(int n, int n2, char[] object) {
        Line[] lineArray;
        Object object2;
        Object object3;
        if ((((char[])object).length == 0 || object[((char[])object).length - 1] != '\n') && n + n2 < this.lines.length) {
            object3 = this.lines[n + n2];
            object2 = new char[((char[])object).length + object3.buffer.length];
            System.arraycopy(object, 0, object2, 0, ((char[])object).length);
            System.arraycopy(object3.buffer, 0, object2, ((char[])object).length, object3.buffer.length);
            object = object2;
            ++n2;
        }
        if (((Line)(object2 = (object3 = this.getParser().parse((char[])object))[((Line[])object3).length - 1])).endsWithNewline() && n + n2 >= this.lines.length) {
            lineArray = new Line[((Line[])object3).length + 1];
            System.arraycopy(object3, 0, lineArray, 0, ((Line[])object3).length);
            lineArray[((Line[])object3).length] = new Line(new char[0], new Segment[0]);
            object3 = lineArray;
        }
        if (n2 == ((Line[])object3).length) {
            for (int i = 0; i < ((Line[])object3).length; ++i) {
                this.lines[i + n] = object3[i];
            }
        } else {
            lineArray = new Line[this.lines.length + ((Line[])object3).length - n2];
            System.arraycopy(this.lines, 0, lineArray, 0, n);
            System.arraycopy(object3, 0, lineArray, n, ((Line[])object3).length);
            System.arraycopy(this.lines, n + n2, lineArray, n + ((Line[])object3).length, this.lines.length - n - n2);
            this.lines = lineArray;
        }
        this.update(this.lines);
    }

    public void cut() {
        this.getCommandFactory().make("cut").invoke();
    }

    public void copy() {
        this.getCommandFactory().make("copy").invoke();
    }

    public void paste() {
        this.getCommandFactory().make("paste").invoke();
    }

    public String getSelectedText() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        Position position = this.getSelection().getStart();
        Position position2 = this.getSelection().getEnd();
        position2 = this.getPrevPosition(position2);
        return this.getText(position, position2);
    }

    public char[] getSelectedCharArray() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        Position position = this.getSelection().getStart();
        Position position2 = this.getSelection().getEnd();
        position = this.getPrevPosition(position);
        return this.getCharArray(position, position2);
    }

    protected void update(char[] cArray) {
        this.update(this.getParser().parse(cArray));
    }

    protected void update(Line[] lineArray) {
        Position position;
        Position position2;
        BTextEditor bTextEditor = this.getEditor();
        boolean bl = bTextEditor.isSingleLine();
        this.lines = lineArray;
        this.text = null;
        double d = this.prefWidth;
        double d2 = this.prefHeight;
        if (!bl) {
            this.walkLines(lineArray);
        }
        if ((position2 = bTextEditor.getCaretPosition()).compareTo(position = this.getEndPosition()) > 0) {
            bTextEditor.moveCaretPosition(position);
        }
        if (!(d == this.prefWidth && d2 == this.prefHeight || bl)) {
            bTextEditor.relayout();
        } else {
            bTextEditor.repaint();
        }
        bTextEditor.fireTextModified(new BWidgetEvent(1, this.getEditor()));
        this.textModified();
    }

    protected void textModified() {
    }

    private void walkLines(Line[] lineArray) {
        TextRenderer textRenderer = this.getRenderer();
        int n = lineArray.length;
        Segment segment = null;
        Segment segment2 = null;
        Segment segment3 = null;
        char c = '\u0000';
        int n2 = 0;
        double d = 10.0;
        int n3 = -488;
        int n4 = 1;
        Line line = lineArray[0];
        if (line.segments.length > 0) {
            Segment segment4 = line.segments[line.segments.length - 1];
            if (segment4.isNewlineR()) {
                n4 = 2;
            } else if (segment4.isNewlineRN()) {
                n4 = 4;
            }
        }
        int n5 = 0;
        for (int i = 0; i < n; ++i) {
            Segment[] segmentArray = lineArray[i].segments;
            char[] cArray = lineArray[i].buffer;
            n5 += cArray.length;
            d = Math.max(d, textRenderer.getLineWidth(lineArray[i]));
            int n6 = segmentArray.length;
            for (int j = 0; j < n6; ++j) {
                Segment segment5 = segmentArray[j];
                int n7 = segment5.type;
                segment5.modifiers &= n3;
                if (n7 == 3) {
                    segment5.modifiers |= n4;
                }
                if (segment2 != null) {
                    segment5.modifiers |= n2;
                    if (n7 != 12) continue;
                    segment2 = null;
                    n2 = 0;
                    continue;
                }
                if (segment3 != null) {
                    segment5.modifiers |= n2;
                    continue;
                }
                if (segment != null) {
                    segment5.modifiers |= n2;
                    if (n7 != 9 || cArray[segment5.offset] != c) continue;
                    segment = null;
                    n2 = 0;
                    continue;
                }
                if (n7 == 11) {
                    segment2 = segment5;
                    n2 = 128;
                    if (segment5.isNonJavadoc()) {
                        n2 |= 0x100;
                    }
                    segment5.modifiers |= n2;
                    continue;
                }
                if (n7 == 10) {
                    segment3 = segment5;
                    n2 = 64;
                    segment5.modifiers |= n2;
                    continue;
                }
                if (n7 != 9) continue;
                segment = segment5;
                c = cArray[segment5.offset];
                n2 = 32;
                segment5.modifiers |= n2;
            }
            segment = null;
            segment3 = null;
        }
        this.textLength = n5;
        this.prefWidth = d;
        this.prefHeight = textRenderer.getLineHeight() * (double)n;
    }

    public int getTextLength() {
        return this.textLength;
    }

    public double getPreferredWidth() {
        return this.prefWidth;
    }

    public double getPreferredHeight() {
        return this.prefHeight;
    }

    public void dump() {
        PrintWriter printWriter = new PrintWriter(System.out);
        this.dump(printWriter);
        printWriter.flush();
    }

    public void dump(PrintWriter printWriter) {
        for (int i = 0; i < this.lines.length && i < 20; ++i) {
            this.dump(printWriter, i, this.lines[i]);
        }
    }

    void dump(PrintWriter printWriter, int n, Line line) {
        printWriter.println(TextUtil.padRight((String)("" + n + ": "), (int)3) + TextModel.toString(line.buffer));
        Segment[] segmentArray = line.segments;
        for (int i = 0; i < segmentArray.length; ++i) {
            printWriter.println("   " + segmentArray[i]);
        }
    }

    public static String toString(char[] cArray) {
        if (cArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c == '\n') {
                stringBuffer.append("\\n");
                continue;
            }
            if (c == '\r') {
                stringBuffer.append("\\r");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }
}

