/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.UiEnv;
import java.lang.reflect.Constructor;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import javax.baja.nre.util.TextUtil;
import javax.baja.ui.Command;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.text.BKeyBindings;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.text.commands.ComposeText;
import javax.baja.ui.text.commands.InsertText;

public class TextController
extends BTextEditor.TextSupport {
    private StringBuffer committedText = new StringBuffer();
    private AttributedCharacterIterator composedText = null;
    private Position composedOriginPos = null;
    private int composedStart = 0;
    private int composedEnd = 0;
    static final char BACKSPACE = '\b';
    static final char TAB = '\t';
    static final char NEWLINE = '\n';
    static final char ESCAPE = '\u001b';
    static final char DELETE = '\u007f';
    private Position mouseAnchor;
    protected final ITextControllerImpl impl;
    static /* synthetic */ Class class$javax$baja$ui$text$TextController;

    public TextController() {
        ITextControllerImpl iTextControllerImpl;
        try {
            Class<?> clazz = Class.forName("java.awt.Component");
            Constructor<?> constructor = Class.forName("com.tridium.ui.awt.se.AwtTextControllerImpl").getConstructor(class$javax$baja$ui$text$TextController == null ? (class$javax$baja$ui$text$TextController = TextController.class$("javax.baja.ui.text.TextController")) : class$javax$baja$ui$text$TextController);
            iTextControllerImpl = (ITextControllerImpl)constructor.newInstance(this);
        }
        catch (Throwable throwable) {
            iTextControllerImpl = new TextControllerImpl(this);
        }
        this.impl = iTextControllerImpl;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        BTextEditor bTextEditor = this.getEditor();
        bTextEditor.setCaretBlinking(true);
        if (bTextEditor.isSingleLine() && bTextEditor.isEditable()) {
            this.getSelection().selectAll();
        }
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.getEditor().setCaretBlinking(false);
        this.getSelection().deselect();
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        int n = bKeyEvent.getKeyCode();
        this.clearMatchHighlight();
        if (this.getEditor().isSingleLine() && (n == 9 || n == 38 || n == 40)) {
            return;
        }
        BKeyBindings bKeyBindings = this.getOptions().getKeyBindings();
        Command command = bKeyBindings.eventToCommand(this.getEditor(), bKeyEvent);
        if (command != null) {
            bKeyEvent.consume();
            command.invoke();
        }
        if (bKeyEvent.isAltDown() && bKeyEvent.isControlDown() && bKeyEvent.getKeyCode() == 123) {
            this.getEditor().getModel().dump();
        }
        if (n == 10 && !this.getEditor().isSingleLine()) {
            bKeyEvent.consume();
        }
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        int n = bKeyEvent.getKeyCode();
        if (n == 10 && !this.getEditor().isSingleLine()) {
            bKeyEvent.consume();
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        int n;
        char c = bKeyEvent.getKeyChar();
        if (bKeyEvent.isControlDown() || bKeyEvent.isAltDown()) {
            return;
        }
        bKeyEvent.consume();
        if (c == '\b' || c == '\t' || c == '\u001b' || c == '\u007f') {
            return;
        }
        String string = String.valueOf(c);
        if (c == '\n' && (n = this.columnForNewline()) > 0) {
            string = string + TextUtil.getSpaces((int)n);
        }
        new InsertText(this.getEditor(), string).invoke();
        if (this.composedText != null) {
            this.composedText = null;
            this.committedText = new StringBuffer();
            this.setComposedPosition(null);
            this.setTextBeginIndex(0);
            this.setTextEndIndex(0);
        }
        BTextEditorOptions bTextEditorOptions = this.getEditor().getOptions();
        if (c == '}' && bTextEditorOptions.getMatchBraces()) {
            this.matchPrev('{', '}');
        }
        if (c == ')' && bTextEditorOptions.getMatchParens()) {
            this.matchPrev('(', ')');
        }
        if (c == ']' && bTextEditorOptions.getMatchBrackets()) {
            this.matchPrev('[', ']');
        }
    }

    protected int columnForNewline() {
        Position position = this.getEditor().getCaretPosition();
        if (position.line == 0) {
            return 0;
        }
        Line line = this.getModel().getLine(position.line);
        int n = -1;
        for (int i = 0; i < line.segments.length; ++i) {
            if (line.segments[i].isWhitespace()) continue;
            n = i;
            break;
        }
        if (n != -1) {
            return line.segments[n].offset;
        }
        return position.column;
    }

    public void caretPositionChanged(BInputMethodEvent bInputMethodEvent) {
        System.out.println("TextController - change the character at the current position");
    }

    public void imTextChanged(BInputMethodEvent bInputMethodEvent) {
        boolean bl = true;
        if (this.composedText == null) {
            bl = false;
        }
        int n = bInputMethodEvent.getCommittedCharacterCount();
        AttributedCharacterIterator attributedCharacterIterator = bInputMethodEvent.getText();
        this.composedText = null;
        char c = '\u0000';
        if (attributedCharacterIterator != null) {
            int n2 = n;
            c = attributedCharacterIterator.first();
            while (n2-- > 0) {
                this.committedText.append(c);
                c = attributedCharacterIterator.next();
            }
            if (attributedCharacterIterator.getEndIndex() - (attributedCharacterIterator.getBeginIndex() + n) > 0) {
                AttributedString attributedString = new AttributedString(attributedCharacterIterator, attributedCharacterIterator.getBeginIndex() + n, attributedCharacterIterator.getEndIndex(), this.impl.getIMAtrributes());
                this.composedText = attributedString.getIterator();
            }
        }
        bInputMethodEvent.consume();
        String string = this.getText(this.composedText);
        int n3 = this.composedText == null ? 0 : attributedCharacterIterator.getBeginIndex();
        int n4 = this.composedText == null ? 0 : attributedCharacterIterator.getEndIndex();
        boolean bl2 = false;
        if (n > 0) {
            bl2 = true;
        }
        new ComposeText(this.getEditor(), string, this.committedText.toString(), n3, n4, bInputMethodEvent.getCaret().getCharIndex(), bl2, bl).invoke();
        if (n == 0) {
            this.committedText = new StringBuffer();
        }
    }

    protected String getText(AttributedCharacterIterator attributedCharacterIterator) {
        if (attributedCharacterIterator == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(attributedCharacterIterator.getEndIndex() - attributedCharacterIterator.getBeginIndex());
        char c = attributedCharacterIterator.first();
        while (c != '\uffff') {
            stringBuffer.append(c);
            c = attributedCharacterIterator.next();
        }
        return stringBuffer.toString();
    }

    private void matchPrev(char c, char c2) {
        Object object;
        Position position = this.getEditor().getCaretPosition();
        int n = 1;
        int n2 = position.line;
        int n3 = position.column - 2;
        if (n3 < 0) {
            --n2;
            n3 = -1;
        }
        block0: while (n2 >= 0) {
            object = this.getModel().getLine(n2);
            char[] cArray = ((Line)object).buffer;
            if (n3 == -1) {
                n3 = cArray.length - 1;
            }
            while (n3 >= 0) {
                char c3 = cArray[n3];
                if (c3 == c2) {
                    ++n;
                }
                if (c3 == c) {
                    --n;
                }
                if (n == 0) break block0;
                --n3;
            }
            --n2;
        }
        if (n2 == -1) {
            return;
        }
        if (n2 == position.line && n3 == position.column - 2) {
            return;
        }
        object = this.getEditor().getRenderer();
        ((TextRenderer)object).matchOpenPos = new Position(n2, n3);
        ((TextRenderer)object).matchClosePos = new Position(position.line, position.column - 1);
    }

    public void clearMatchHighlight() {
        TextRenderer textRenderer = this.getEditor().getRenderer();
        if (textRenderer != null) {
            textRenderer.matchOpenPos = null;
            textRenderer.matchClosePos = null;
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.getEditor().requestFocus();
        Position position = this.mouseEventToPosition(bMouseEvent);
        if (bMouseEvent.isShiftDown()) {
            this.mouseAnchor = this.getSelection().getAnchor();
            if (this.mouseAnchor == null) {
                this.mouseAnchor = this.getEditor().getCaretPosition();
            }
            this.getSelection().select(this.mouseAnchor, position);
        } else {
            this.mouseAnchor = position;
            this.getSelection().deselect();
        }
        this.getEditor().moveCaretPosition(position);
        this.getEditor().updateAnchorX();
        if (bMouseEvent.getClickCount() % 2 == 0) {
            Line line = this.getModel().getLine(position.line);
            Segment segment = line.getSegmentAt(position.column);
            if (segment == null) {
                int n = line.segments.length;
                if (n > 1) {
                    segment = line.segments[n - 2];
                } else if (n > 0) {
                    segment = line.segments[n - 1];
                }
            }
            if (segment != null) {
                Position position2 = new Position(position.line, segment.offset);
                Position position3 = new Position(position.line, segment.offset + segment.length);
                this.getSelection().select(position2, position3);
            }
        } else if (bMouseEvent.getClickCount() % 3 == 0) {
            Line line = this.getModel().getLine(position.line);
            Position position4 = new Position(position.line, 0);
            Position position5 = new Position(position.line + 1, 0);
            Position position6 = this.getModel().getEndPosition();
            if (position5.compareTo(position6) > 0) {
                position5 = position6;
            }
            this.getSelection().select(position4, position5);
            this.getEditor().moveCaretPosition(position);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        BTextEditor bTextEditor = this.getEditor();
        if (!UiEnv.get().hasKeyboard() && bTextEditor.isEditable()) {
            UiEnv.get().input(bTextEditor);
            return;
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.getEditor().setMouseCursor(MouseCursor.text);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.getEditor().setMouseCursor(MouseCursor.normal);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        Position position;
        if (bMouseEvent.isButton1Down() && !(position = this.mouseEventToPosition(bMouseEvent)).equals(this.getEditor().getCaretPosition())) {
            this.getSelection().select(this.mouseAnchor, position);
            this.getEditor().moveCaretPosition(position);
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
    }

    private Position mouseEventToPosition(BMouseEvent bMouseEvent) {
        Position position = this.getEditor().getPositionAt(bMouseEvent.getX(), bMouseEvent.getY());
        Position position2 = this.getModel().getEndPosition();
        int n = position.line;
        int n2 = position.column;
        if (n < 0) {
            n = 0;
        } else if (n > position2.line) {
            n = position2.line;
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n == position2.line && n2 > position2.column) {
            n2 = position2.column;
        }
        return new Position(n, n2);
    }

    public AttributedCharacterIterator cancelLatestCommittedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public AttributedCharacterIterator getCommittedText(int n, int n2, AttributedCharacterIterator.Attribute[] attributeArray) {
        AttributedString attributedString = new AttributedString(this.committedText.toString());
        return attributedString.getIterator(null, n, n2);
    }

    public int getCommittedTextLength() {
        return this.committedText.length();
    }

    public int getInsertPositionOffset() {
        return 0;
    }

    public Object getLocationOffset(int n, int n2) {
        return this.impl.getLocationOffset(n, n2);
    }

    public AttributedCharacterIterator getSelectedText(AttributedCharacterIterator.Attribute[] attributeArray) {
        return null;
    }

    public Object getTextLocation(Object object) {
        return this.impl.getTextLocation(object);
    }

    public int getTextBeginIndex() {
        return this.composedStart;
    }

    public int getTextEndIndex() {
        return this.composedEnd;
    }

    public void setTextBeginIndex(int n) {
        this.composedStart = n;
    }

    public void setTextEndIndex(int n) {
        this.composedEnd = n;
    }

    public Position getComposedPosition() {
        return this.composedOriginPos;
    }

    public void setComposedPosition(Position position) {
        this.composedOriginPos = position;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface ITextControllerImpl {
        public Object getLocationOffset(int var1, int var2);

        public AttributedCharacterIterator.Attribute[] getIMAtrributes();

        public Object getTextLocation(Object var1);
    }

    public class TextControllerImpl
    implements ITextControllerImpl {
        private TextController textController;

        public TextControllerImpl(TextController textController2) {
            this.textController = textController2;
        }

        public Object getLocationOffset(int n, int n2) {
            return null;
        }

        public AttributedCharacterIterator.Attribute[] getIMAtrributes() {
            return new AttributedCharacterIterator.Attribute[0];
        }

        public Object getTextLocation(Object object) {
            return null;
        }
    }
}

