/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import javax.baja.ui.Command;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.commands.Backspace;
import javax.baja.ui.text.commands.CutLine;
import javax.baja.ui.text.commands.Delete;
import javax.baja.ui.text.commands.DeleteWord;
import javax.baja.ui.text.commands.DocumentEnd;
import javax.baja.ui.text.commands.DocumentStart;
import javax.baja.ui.text.commands.Find;
import javax.baja.ui.text.commands.FindNext;
import javax.baja.ui.text.commands.FindPrev;
import javax.baja.ui.text.commands.Goto;
import javax.baja.ui.text.commands.LineEnd;
import javax.baja.ui.text.commands.LineStart;
import javax.baja.ui.text.commands.MoveDown;
import javax.baja.ui.text.commands.MoveLeft;
import javax.baja.ui.text.commands.MoveRight;
import javax.baja.ui.text.commands.MoveUp;
import javax.baja.ui.text.commands.PageDown;
import javax.baja.ui.text.commands.PageUp;
import javax.baja.ui.text.commands.ReloadMacros;
import javax.baja.ui.text.commands.Replace;
import javax.baja.ui.text.commands.SelectAll;
import javax.baja.ui.text.commands.TabBack;
import javax.baja.ui.text.commands.TabForward;
import javax.baja.ui.text.commands.ToggleSlashSlash;
import javax.baja.ui.text.commands.WordLeft;
import javax.baja.ui.text.commands.WordRight;
import javax.baja.ui.text.commands.WordWrap;

public class TextCommandFactory
extends BTextEditor.TextSupport {
    public static final String MOVE_UP = "moveUp";
    public static final String MOVE_DOWN = "moveDown";
    public static final String MOVE_LEFT = "moveLeft";
    public static final String MOVE_RIGHT = "moveRight";
    public static final String PAGE_UP = "pageUp";
    public static final String PAGE_DOWN = "pageDown";
    public static final String LINE_START = "lineStart";
    public static final String LINE_END = "lineEnd";
    public static final String DOCUMENT_START = "documentStart";
    public static final String DOCUMENT_END = "documentEnd";
    public static final String WORD_LEFT = "wordLeft";
    public static final String WORD_RIGHT = "wordRight";
    public static final String END = "redo";
    public static final String CUT = "cut";
    public static final String COPY = "copy";
    public static final String PASTE = "paste";
    public static final String CUT2 = "cut2";
    public static final String COPY2 = "copy2";
    public static final String PASTE2 = "paste2";
    public static final String UNDO = "undo";
    public static final String REDO = "redo";
    public static final String DELETE = "delete";
    public static final String BACKSPACE = "backspace";
    public static final String DELETE_WORD = "deleteWord";
    public static final String CUT_LINE = "cutLine";
    public static final String TAB_FORWARD = "tabForward";
    public static final String TAB_BACK = "tabBack";
    public static final String TOGGLE_SLASH_SLASH = "toggleSlashSlash";
    public static final String FIND = "find";
    public static final String FIND_NEXT = "findNext";
    public static final String FIND_PREV = "findPrev";
    public static final String REPLACE = "replace";
    public static final String GOTO = "goTo";
    public static final String WORD_WRAP = "wordWrap";
    public static final String RELOAD_MACROS = "reloadMacros";
    public static final String SELECT_ALL = "selectAll";

    public Command make(String string) {
        BTextEditor bTextEditor = this.getEditor();
        if (bTextEditor.getShell() == null) {
            return null;
        }
        String string2 = string.intern();
        switch (string2.charAt(0)) {
            case 'b': {
                if (string2 == BACKSPACE) {
                    return new Backspace(bTextEditor);
                }
                return null;
            }
            case 'c': {
                if (string2 == CUT) {
                    return new CutCommand(bTextEditor);
                }
                if (string2 == CUT2) {
                    return new CutCommand(bTextEditor);
                }
                if (string2 == COPY) {
                    return new CopyCommand(bTextEditor);
                }
                if (string2 == COPY2) {
                    return new CopyCommand(bTextEditor);
                }
                if (string2 == CUT_LINE) {
                    return new CutLine(bTextEditor);
                }
                return null;
            }
            case 'd': {
                if (string2 == DOCUMENT_START) {
                    return new DocumentStart(bTextEditor);
                }
                if (string2 == DOCUMENT_END) {
                    return new DocumentEnd(bTextEditor);
                }
                if (string2 == DELETE) {
                    return new Delete(bTextEditor);
                }
                if (string2 == DELETE_WORD) {
                    return new DeleteWord(bTextEditor);
                }
                return null;
            }
            case 'f': {
                if (string2 == FIND) {
                    return new Find(bTextEditor);
                }
                if (string2 == FIND_NEXT) {
                    return new FindNext(bTextEditor);
                }
                if (string2 == FIND_PREV) {
                    return new FindPrev(bTextEditor);
                }
                return null;
            }
            case 'g': {
                if (string2 == GOTO) {
                    return new Goto(bTextEditor);
                }
                return null;
            }
            case 'l': {
                if (string2 == LINE_START) {
                    return new LineStart(bTextEditor);
                }
                if (string2 == LINE_END) {
                    return new LineEnd(bTextEditor);
                }
                return null;
            }
            case 'm': {
                if (string2 == MOVE_UP) {
                    return new MoveUp(bTextEditor);
                }
                if (string2 == MOVE_DOWN) {
                    return new MoveDown(bTextEditor);
                }
                if (string2 == MOVE_LEFT) {
                    return new MoveLeft(bTextEditor);
                }
                if (string2 == MOVE_RIGHT) {
                    return new MoveRight(bTextEditor);
                }
                return null;
            }
            case 'p': {
                if (string2 == PASTE) {
                    return new PasteCommand(bTextEditor);
                }
                if (string2 == PASTE2) {
                    return new PasteCommand(bTextEditor);
                }
                if (string2 == PAGE_DOWN) {
                    return new PageDown(bTextEditor);
                }
                if (string2 == PAGE_UP) {
                    return new PageUp(bTextEditor);
                }
                return null;
            }
            case 'r': {
                if (string2 == "redo") {
                    return bTextEditor.getUndoManager().getRedoCommand();
                }
                if (string2 == REPLACE) {
                    return new Replace(bTextEditor);
                }
                if (string2 == RELOAD_MACROS) {
                    return new ReloadMacros(bTextEditor);
                }
                return null;
            }
            case 's': {
                if (string2 == SELECT_ALL) {
                    return new SelectAll(bTextEditor);
                }
                return null;
            }
            case 't': {
                if (string2 == TAB_FORWARD) {
                    return new TabForward(bTextEditor);
                }
                if (string2 == TAB_BACK) {
                    return new TabBack(bTextEditor);
                }
                if (string2 == TOGGLE_SLASH_SLASH) {
                    return new ToggleSlashSlash(bTextEditor);
                }
                return null;
            }
            case 'u': {
                if (string2 == UNDO) {
                    return bTextEditor.getUndoManager().getUndoCommand();
                }
                return null;
            }
            case 'w': {
                if (string2 == WORD_LEFT) {
                    return new WordLeft(bTextEditor);
                }
                if (string2 == WORD_RIGHT) {
                    return new WordRight(bTextEditor);
                }
                if (string2 == WORD_WRAP) {
                    return new WordWrap(bTextEditor);
                }
                return null;
            }
        }
        return null;
    }
}

