/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

public class Segment {
    public static final int TEXT = 0;
    public static final int SPACES = 1;
    public static final int TAB = 2;
    public static final int NEWLINE = 3;
    public static final int NUMBER_LITERAL = 4;
    public static final int IDENTIFIER = 5;
    public static final int KEYWORD = 6;
    public static final int PREPROCESSOR = 7;
    public static final int BRACKET = 8;
    public static final int STRING_DELIMITER = 9;
    public static final int LINE_COMMENT = 10;
    public static final int MULTI_LINE_COMMENT_START = 11;
    public static final int MULTI_LINE_COMMENT_END = 12;
    private static final String[] typeStrings = new String[]{"text", "spaces", "tab", "newline", "numberLiteral", "keyword", "identifier", "preprocessor", "brackets", "stringDelimiter", "lineComment", "multiLineCommentStart", "multiLineCommentEnd"};
    public static final int MOD_NEWLINE_N = 1;
    public static final int MOD_NEWLINE_R = 2;
    public static final int MOD_NEWLINE_RN = 4;
    public static final int MOD_WORD = 8;
    public static final int MOD_NON_JAVADOC = 16;
    public static final int MOD_IN_STRING_LITERAL = 32;
    public static final int MOD_IN_LINE_COMMENT = 64;
    public static final int MOD_IN_MULTI_LINE_COMMENT = 128;
    public static final int MOD_IN_NON_JAVADOC = 256;
    public final int type;
    public int modifiers;
    public final int offset;
    public final int length;

    public Segment(int n, int n2, int n3) {
        this.type = n;
        this.modifiers = 0;
        this.offset = n2;
        this.length = n3;
    }

    public Segment(int n, int n2, int n3, int n4) {
        this.type = n;
        this.modifiers = n2;
        this.offset = n3;
        this.length = n4;
    }

    public boolean isWhitespace() {
        return this.type == 3 || this.type == 1 || this.type == 2;
    }

    public final boolean isNewlineN() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isNewlineR() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isNewlineRN() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isWord() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isNonJavadoc() {
        return (this.modifiers & 0x10) != 0;
    }

    public final boolean isInStringLiteral() {
        return (this.modifiers & 0x20) != 0;
    }

    public final boolean isInLineComment() {
        return (this.modifiers & 0x40) != 0;
    }

    public final boolean isInMultiLineComment() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isInNonJavadoc() {
        return (this.modifiers & 0x100) != 0;
    }

    public String toString() {
        String string = this.type >= 0 && this.type < typeStrings.length ? typeStrings[this.type] : String.valueOf(this.type);
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isInLineComment()) {
            stringBuffer.append("// ");
        } else if (this.isInMultiLineComment()) {
            stringBuffer.append("/*");
        } else {
            stringBuffer.append("   ");
        }
        stringBuffer.append(" [").append(string);
        if (this.modifiers != 0) {
            stringBuffer.append(",0x").append(Integer.toHexString(this.modifiers));
        }
        stringBuffer.append("] ");
        stringBuffer.append(this.offset).append(',').append(this.length);
        return stringBuffer.toString();
    }
}

