/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BValue;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.commands.CompoundCommand;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.commands.DocumentEnd;
import javax.baja.ui.text.commands.DocumentStart;
import javax.baja.ui.text.commands.InsertText;
import javax.baja.ui.text.commands.LineEnd;
import javax.baja.ui.text.commands.LineStart;
import javax.baja.ui.text.commands.MoveDown;
import javax.baja.ui.text.commands.MoveLeft;
import javax.baja.ui.text.commands.MoveRight;
import javax.baja.ui.text.commands.MoveUp;
import javax.baja.ui.text.commands.WordLeft;
import javax.baja.ui.text.commands.WordRight;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.xml.XElem;

class Macro {
    BAccelerator acc;
    Phrase[] phrases;
    Prompt[] prompts;
    private static String[] validPhrases = new String[]{"text", "nl", "date", "up", "down", "left", "right", "docEnd", "docStart", "lineEnd", "lineStart", "wordLeft", "wordRight", "replace"};
    private static Set validPhraseSet = new HashSet();

    Macro(XElem xElem) {
        BAccelerator bAccelerator = BAccelerator.make(xElem.get("accelerator"));
        this.prompts = Macro.decodePrompts(xElem.elems("prompts"));
        HashMap<String, Prompt> hashMap = new HashMap<String, Prompt>();
        for (int i = 0; i < this.prompts.length; ++i) {
            hashMap.put(this.prompts[i].name, this.prompts[i]);
        }
        XElem[] xElemArray = xElem.elems();
        ArrayList<Phrase> arrayList = new ArrayList<Phrase>();
        for (int i = 0; i < xElemArray.length; ++i) {
            String string = xElemArray[i].name();
            if (validPhraseSet.contains(string)) {
                if (string.equals("text")) {
                    arrayList.add(new TextPhrase(xElemArray[i].get("val")));
                    continue;
                }
                if (string.equals("date")) {
                    arrayList.add(new DatePhrase(xElemArray[i].get("format")));
                    continue;
                }
                if (string.equals("nl")) {
                    arrayList.add(new NewlinePhrase());
                    continue;
                }
                if (string.equals("replace")) {
                    arrayList.add(new ReplacePhrase(xElemArray[i].get("from"), xElemArray[i].get("to"), xElemArray[i].get("options", "")));
                    continue;
                }
                arrayList.add(new NavPhrase(string));
                continue;
            }
            if (string.equals("prompts")) continue;
            Prompt prompt = (Prompt)hashMap.get(string);
            if (prompt == null) {
                System.out.println("WARNING: ignoring invalid macro phrase '" + string + "'.");
                continue;
            }
            arrayList.add(new PromptPhrase(prompt));
        }
        this.acc = bAccelerator;
        this.phrases = arrayList.toArray(new Phrase[arrayList.size()]);
    }

    CompoundCommand makeCommand(BTextEditor bTextEditor) {
        ArrayList<Command> arrayList = new ArrayList<Command>();
        if (!this.loadPrompts(bTextEditor)) {
            return null;
        }
        for (int i = 0; i < this.phrases.length; ++i) {
            Command command = this.phrases[i].makeCommand(bTextEditor);
            if (command == null) continue;
            arrayList.add(command);
        }
        return new CompoundCommand((BWidget)bTextEditor, null, arrayList.toArray(new Command[arrayList.size()]));
    }

    private static Prompt[] decodePrompts(XElem[] xElemArray) {
        if (xElemArray.length > 0) {
            if (xElemArray.length > 1) {
                System.out.println("WARNING: ignoring extra extraneous prompts definitions.");
            }
            XElem[] xElemArray2 = xElemArray[0].elems();
            Prompt[] promptArray = new Prompt[xElemArray2.length];
            for (int i = 0; i < xElemArray2.length; ++i) {
                promptArray[i] = new Prompt(xElemArray2[i].name(), xElemArray2[i].get("default", null));
            }
            return promptArray;
        }
        return new Prompt[0];
    }

    private boolean loadPrompts(BTextEditor bTextEditor) {
        int n;
        if (this.prompts.length == 0) {
            return true;
        }
        BGridPane bGridPane = new BGridPane();
        BTextField[] bTextFieldArray = new BTextField[this.prompts.length];
        for (n = 0; n < this.prompts.length; ++n) {
            bTextFieldArray[n] = new BTextField();
            if (this.prompts[n].defaultVal != null) {
                bTextFieldArray[n].setText(this.prompts[n].defaultVal);
            }
            bGridPane.add(null, (BValue)new BLabel(TextUtil.capitalize((String)(this.prompts[n].name + ":"))));
            bGridPane.add(null, (BValue)bTextFieldArray[n]);
        }
        if (BDialog.open(bTextEditor, null, bGridPane, 3) == 2) {
            return false;
        }
        for (n = 0; n < this.prompts.length; ++n) {
            this.prompts[n].val = bTextFieldArray[n].getText();
        }
        return true;
    }

    static {
        for (int i = 0; i < validPhrases.length; ++i) {
            validPhraseSet.add(validPhrases[i]);
        }
    }

    private static class NavPhrase
    extends Phrase {
        private String name;

        private NavPhrase(String string) {
            this.name = string;
        }

        Command makeCommand(BTextEditor bTextEditor) {
            if (this.name.equals("up")) {
                return new MoveUp(bTextEditor);
            }
            if (this.name.equals("down")) {
                return new MoveDown(bTextEditor);
            }
            if (this.name.equals("left")) {
                return new MoveLeft(bTextEditor);
            }
            if (this.name.equals("right")) {
                return new MoveRight(bTextEditor);
            }
            if (this.name.equals("docEnd")) {
                return new DocumentEnd(bTextEditor);
            }
            if (this.name.equals("docStart")) {
                return new DocumentStart(bTextEditor);
            }
            if (this.name.equals("lineEnd")) {
                return new LineEnd(bTextEditor);
            }
            if (this.name.equals("lineStart")) {
                return new LineStart(bTextEditor);
            }
            if (this.name.equals("wordLeft")) {
                return new WordLeft(bTextEditor);
            }
            if (this.name.equals("wordRight")) {
                return new WordRight(bTextEditor);
            }
            throw new IllegalStateException();
        }
    }

    private static class ReplacePhrase
    extends Phrase {
        private String from;
        private String to;
        private String options;
        private Map promptMap;

        private ReplacePhrase(String string, String string2, String string3) {
            this.from = string;
            this.to = string2;
            this.options = string3;
        }

        Command makeCommand(BTextEditor bTextEditor) {
            String string = Clipboard.getDefault().getContents().getData(TransferFormat.string).toString();
            String string2 = TextUtil.replace((String)string, (String)this.from, (String)this.to);
            if (this.options != null && this.options.indexOf("trimRight") > -1) {
                string2 = TextUtil.trimRight((String)string2);
            }
            if (this.options != null && this.options.indexOf("clipBoard") > -1) {
                Clipboard.getDefault().setContents(TransferEnvelope.make(string2));
                return ReplacePhrase.makeInsert(bTextEditor, "");
            }
            return ReplacePhrase.makeInsert(bTextEditor, string2);
        }
    }

    private static class NewlinePhrase
    extends Phrase {
        private NewlinePhrase() {
        }

        Command makeCommand(BTextEditor bTextEditor) {
            return NewlinePhrase.makeInsert(bTextEditor, "\n" + TextUtil.getSpaces((int)bTextEditor.getController().columnForNewline()));
        }
    }

    private static class DatePhrase
    extends Phrase {
        private String format;

        private DatePhrase(String string) {
            this.format = string;
        }

        Command makeCommand(BTextEditor bTextEditor) {
            return DatePhrase.makeInsert(bTextEditor, new SimpleDateFormat(this.format).format(new Date(System.currentTimeMillis())));
        }
    }

    private static class PromptPhrase
    extends Phrase {
        private Prompt prompt;

        private PromptPhrase(Prompt prompt) {
            this.prompt = prompt;
        }

        Command makeCommand(BTextEditor bTextEditor) {
            return PromptPhrase.makeInsert(bTextEditor, this.prompt.val);
        }
    }

    private static class TextPhrase
    extends Phrase {
        private String val;

        private TextPhrase(String string) {
            this.val = string;
        }

        Command makeCommand(BTextEditor bTextEditor) {
            return TextPhrase.makeInsert(bTextEditor, this.val);
        }
    }

    private static abstract class Phrase {
        private Phrase() {
        }

        abstract Command makeCommand(BTextEditor var1);

        static InsertText makeInsert(BTextEditor bTextEditor, String string) {
            if (string == null || string.length() == 0) {
                return null;
            }
            return new InsertText(bTextEditor, string);
        }
    }

    static class Prompt {
        private String name;
        private String defaultVal;
        private String val;

        Prompt(String string, String string2) {
            this.name = string;
            this.defaultVal = string2;
            this.val = null;
        }
    }
}

