/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import javax.baja.gx.BFont;
import javax.baja.ui.text.Segment;

public class Line {
    public final char[] buffer;
    public final Segment[] segments;

    public Line(char[] cArray, Segment[] segmentArray) {
        this.buffer = cArray;
        this.segments = segmentArray;
    }

    public Line(char[] cArray, int n, int n2, List list) {
        this.buffer = new char[n2];
        System.arraycopy(cArray, n, this.buffer, 0, n2);
        this.segments = list.toArray(new Segment[list.size()]);
    }

    public Line(Line line, Line line2) {
        if (line.segments[line.segments.length - 1].type == 3) {
            throw new IllegalArgumentException();
        }
        this.buffer = new char[line.buffer.length + line2.buffer.length];
        this.segments = new Segment[line.segments.length + line2.segments.length];
        System.arraycopy(line.buffer, 0, this.buffer, 0, line.buffer.length);
        System.arraycopy(line2.buffer, 0, this.buffer, line.buffer.length, line2.buffer.length);
        System.arraycopy(line.segments, 0, this.segments, 0, line.segments.length);
        System.arraycopy(line2.segments, 0, this.segments, line.segments.length, line2.segments.length);
    }

    public int getColumnCount() {
        return this.buffer.length;
    }

    public Segment getSegmentAt(int n) {
        int n2 = this.getSegmentIndexAt(n);
        if (n2 < 0) {
            return null;
        }
        return this.segments[n2];
    }

    public int getSegmentIndexAt(int n) {
        if (n < 0 || n > this.buffer.length) {
            return -1;
        }
        for (int i = 0; i < this.segments.length; ++i) {
            if (n >= this.segments[i].offset + this.segments[i].length) continue;
            return i;
        }
        return -1;
    }

    public boolean endsWithNewline() {
        int n = this.buffer.length;
        if (n == 0) {
            return false;
        }
        return this.buffer[n - 1] == '\n';
    }

    public int getColumnCountWithoutNewline() {
        int n = this.buffer.length;
        if (n == 0) {
            return 0;
        }
        return this.buffer[n - 1] == '\n' ? n - 1 : n;
    }

    public double getWidth(BFont bFont) {
        return bFont.width(this.buffer, 0, this.buffer.length);
    }

    public double getWidth(BFont bFont, int n, int n2) {
        if (n2 > this.buffer.length - 1) {
            n2 = this.buffer.length == 0 ? 0 : this.buffer.length - 1;
        }
        return bFont.width(this.buffer, n, n2);
    }

    public String toString() {
        return "Line: " + new String(this.buffer);
    }

    Line stripNewline() {
        if (!this.endsWithNewline()) {
            return this;
        }
        char[] cArray = new char[this.buffer.length - 1];
        System.arraycopy(this.buffer, 0, cArray, 0, cArray.length);
        Segment[] segmentArray = new Segment[this.segments.length - 1];
        System.arraycopy(this.segments, 0, segmentArray, 0, segmentArray.length);
        return new Line(cArray, segmentArray);
    }

    void write(Writer writer) throws IOException {
        if (this.buffer.length == 0) {
            return;
        }
        Segment segment = this.segments[this.segments.length - 1];
        if (segment.type == 3) {
            writer.write(this.buffer, 0, this.buffer.length - 1);
            if (segment.isNewlineR()) {
                writer.write(13);
            } else if (segment.isNewlineRN()) {
                writer.write("\r\n");
            } else {
                writer.write(10);
            }
        } else {
            writer.write(this.buffer, 0, this.buffer.length);
        }
    }

    char[] toCharArrayGrowAsNeeded(int n) {
        char[] cArray = this.buffer;
        if (n < this.getColumnCountWithoutNewline()) {
            return cArray;
        }
        if (this.endsWithNewline()) {
            char[] cArray2 = new char[n + 1];
            System.arraycopy(cArray, 0, cArray2, 0, cArray.length - 1);
            for (int i = cArray.length - 1; i < n; ++i) {
                cArray2[i] = 32;
            }
            cArray2[n] = 10;
            return cArray2;
        }
        char[] cArray3 = new char[n];
        System.arraycopy(cArray, 0, cArray3, 0, cArray.length);
        for (int i = cArray.length; i < n; ++i) {
            cArray3[i] = 32;
        }
        return cArray3;
    }
}

