/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.BFindPane;
import javax.baja.gx.BImage;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;
import javax.baja.ui.util.UiLexicon;

public class FindPattern {
    static BImage icon = BImage.make((String)"module://icons/x32/magnifyingGlass.png");
    static FindPattern current = new FindPattern("", false, false, false);
    static final int FORWARD = 0;
    static final int BACKWARD = 1;
    public final String string;
    public final boolean matchCase;
    public final boolean matchWord;
    public final boolean fromTop;
    private char[] buffer;

    public static FindPattern getCurrent() {
        return current;
    }

    public static void setCurrent(FindPattern findPattern) {
        current = findPattern;
    }

    public static FindPattern query(BWidget bWidget) {
        BFindPane bFindPane;
        UiLexicon uiLexicon = UiLexicon.bajaui();
        String string = uiLexicon.getText("commands.find.label");
        if (BDialog.open(bWidget, string, bFindPane = new BFindPane(bWidget), 3, icon) == 2) {
            return null;
        }
        current = bFindPane.save();
        if (FindPattern.current.fromTop && bWidget instanceof BTextEditor) {
            ((BTextEditor)bWidget).moveCaretPosition(new Position(0, 0));
        }
        return current;
    }

    public FindPattern(String string, boolean bl, boolean bl2) {
        this(string, bl, bl2, false);
    }

    public FindPattern(String string, boolean bl, boolean bl2, boolean bl3) {
        this.string = string;
        this.matchCase = bl;
        this.matchWord = bl2;
        this.fromTop = bl3;
    }

    public int findNext(String string, int n) {
        return this.find(string, n, 0);
    }

    public int findPrev(String string, int n) {
        return this.find(string, n, 1);
    }

    public int findNext(char[] cArray, int n, int n2) {
        return this.find(cArray, n, n2, 0);
    }

    public int findPrev(char[] cArray, int n, int n2) {
        return this.find(cArray, n, n2, 1);
    }

    private int find(String string, int n, int n2) {
        if (this.buffer == null) {
            this.buffer = new char[Math.max(64, string.length())];
        }
        if (string.length() > this.buffer.length) {
            this.buffer = new char[string.length()];
        }
        string.getChars(0, string.length(), this.buffer, 0);
        return this.find(this.buffer, n, string.length() - n, n2);
    }

    private int find(char[] cArray, int n, int n2, int n3) {
        int n4 = n + n2 - this.string.length();
        if (n4 < 0 || n4 >= cArray.length) {
            return -1;
        }
        if (n3 == 0) {
            for (int i = n; i <= n4; ++i) {
                if (!this.isMatch(cArray, i)) continue;
                return i;
            }
            return -1;
        }
        for (int i = n; i >= 0; --i) {
            if (!this.isMatch(cArray, i)) continue;
            return i;
        }
        return -1;
    }

    private boolean isMatch(char[] cArray, int n) {
        String string = this.string;
        boolean bl = this.matchCase;
        int n2 = string.length();
        if (this.matchWord) {
            if (n > 0 && this.isWord(cArray[n - 1])) {
                return false;
            }
            if (n + n2 < cArray.length && this.isWord(cArray[n + n2])) {
                return false;
            }
        }
        for (int i = 0; i < n2; ++i) {
            if (!(bl ? cArray[n + i] != string.charAt(i) : Character.toLowerCase(cArray[n + i]) != Character.toLowerCase(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private boolean isWord(char c) {
        return Character.isLetterOrDigit(c) || c == '_' || c == '$';
    }

    public String toString() {
        return this.string;
    }

    public String replace(String string, String string2) {
        char[] cArray = string.toCharArray();
        return this.replace(cArray, 0, cArray.length, string2);
    }

    public String replace(char[] cArray, int n, int n2, String string) {
        int n3;
        StringBuffer stringBuffer = new StringBuffer(n2 - n);
        while ((n3 = this.findNext(cArray, n, n2 - n)) >= 0) {
            if (n < n3) {
                stringBuffer.append(cArray, n, n3 - n);
            }
            stringBuffer.append(string);
            n = n3 + this.string.length();
        }
        if (n < n2) {
            stringBuffer.append(cArray, n, n2 - n);
        }
        return stringBuffer.toString();
    }
}

