/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import javax.baja.ui.BWidget;
import javax.baja.ui.text.BTextEditor;

class Blinker
extends Thread {
    private static Blinker blinker;
    private BTextEditor widget;
    private boolean isAlive;
    private boolean visible;

    static synchronized void startBlinking(BTextEditor bTextEditor) {
        Blinker.stopBlinking();
        blinker = new Blinker(bTextEditor);
        blinker.start();
    }

    static synchronized void stopBlinking() {
        if (blinker != null) {
            Blinker.blinker.isAlive = false;
            Blinker.blinker.widget = null;
            blinker = null;
        }
    }

    static synchronized void pauseBlinking() {
        if (blinker != null) {
            blinker.interrupt();
        }
    }

    static BWidget getBlinkingWidget() {
        Blinker blinker = Blinker.blinker;
        if (blinker == null) {
            return null;
        }
        return blinker.widget;
    }

    private Blinker(BTextEditor bTextEditor) {
        super("Ui:CaretBlinker");
        this.widget = bTextEditor;
        this.isAlive = true;
    }

    public void run() {
        while (this.isAlive) {
            try {
                this.visible = !this.visible;
                this.widget.blinkCaret(this.visible);
                Blinker.sleep(500L);
            }
            catch (InterruptedException interruptedException) {
                try {
                    if (this.widget != null) {
                        this.widget.blinkCaret(true);
                    }
                    this.visible = false;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

