/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.CaretTracker;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Blinker;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextCommandFactory;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.text.TextSelection;
import javax.baja.ui.text.commands.InsertText;
import javax.baja.ui.text.commands.RemoveText;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;

public class BTextEditor
extends BTransferWidget
implements UndoManager.Scope {
    public static final Property editable = BTextEditor.newProperty((int)0, (boolean)true, null);
    public static final Topic textModified = BTextEditor.newTopic((int)0, null);
    public static final Topic selectionModified = BTextEditor.newTopic((int)0, null);
    public static final Topic inputMethodEvent = BTextEditor.newTopic((int)0);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$text$BTextEditor == null ? (class$javax$baja$ui$text$BTextEditor = BTextEditor.class$("javax.baja.ui.text.BTextEditor")) : class$javax$baja$ui$text$BTextEditor));
    private static final BIcon icon = BIcon.std((String)"widgets/textEditor.png");
    private static BInsets insets = BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0);
    private TextModel model;
    private TextController controller;
    private TextRenderer renderer;
    private TextSelection selection;
    private TextParser parser;
    private TextCommandFactory commandFactory;
    private BTextEditorOptions options;
    private TextRenderer.LineInfo lineInfo = new TextRenderer.LineInfo();
    private Position caretPos = new Position(0, 0);
    private boolean caretVisible;
    private boolean firstPaint = true;
    private boolean allowCopying = true;
    private UndoManager undoManager = null;
    static /* synthetic */ Class class$javax$baja$ui$text$BTextEditor;

    public boolean getEditable() {
        return this.getBoolean(editable);
    }

    public void setEditable(boolean bl) {
        this.setBoolean(editable, bl, null);
    }

    public void fireTextModified(BWidgetEvent bWidgetEvent) {
        this.fire(textModified, (BValue)bWidgetEvent, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public final void fireInputMethodEvent(BInputMethodEvent bInputMethodEvent) {
        switch (bInputMethodEvent.getId()) {
            case 1101: {
                this.caretPositionChanged(bInputMethodEvent);
                break;
            }
            case 1100: {
                this.imTextChanged(bInputMethodEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(inputMethodEvent, (BValue)bInputMethodEvent, null);
    }

    public void caretPositionChanged(BInputMethodEvent bInputMethodEvent) {
        this.controller.caretPositionChanged(bInputMethodEvent);
    }

    public void imTextChanged(BInputMethodEvent bInputMethodEvent) {
        this.controller.imTextChanged(bInputMethodEvent);
    }

    public Type getType() {
        return TYPE;
    }

    public BTextEditor(String string, boolean bl) {
        this();
        this.setText(string);
        this.setEditable(bl);
        this.updateEnableStates();
    }

    public BTextEditor() {
        this.setModel(new TextModel());
        this.setController(new TextController());
        this.setRenderer(new TextRenderer());
        this.setParser(new TextParser());
        this.setCommandFactory(new TextCommandFactory());
        this.setSelection(new TextSelection());
        this.setOptions(BTextEditorOptions.make());
        this.updateEnableStates();
    }

    public TextModel getModel() {
        return this.model;
    }

    public void setModel(TextModel textModel) {
        this.installSupport(this.model, textModel);
        this.model = textModel;
    }

    public TextController getController() {
        return this.controller;
    }

    public void setController(TextController textController) {
        this.installSupport(this.controller, textController);
        this.controller = textController;
    }

    public TextParser getParser() {
        return this.parser;
    }

    public void setParser(TextParser textParser) {
        this.installSupport(this.parser, textParser);
        this.parser = textParser;
    }

    public TextCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(TextCommandFactory textCommandFactory) {
        this.installSupport(this.commandFactory, textCommandFactory);
        this.commandFactory = textCommandFactory;
    }

    public TextSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TextSelection textSelection) {
        this.installSupport(this.selection, textSelection);
        this.selection = textSelection;
    }

    public TextRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TextRenderer textRenderer) {
        this.installSupport(this.renderer, textRenderer);
        this.renderer = textRenderer;
    }

    public BTextEditorOptions getOptions() {
        return this.options;
    }

    public void setOptions(BTextEditorOptions bTextEditorOptions) {
        if (bTextEditorOptions == null) {
            throw new NullPointerException();
        }
        this.options = bTextEditorOptions;
    }

    private void installSupport(TextSupport textSupport, TextSupport textSupport2) {
        if (textSupport2 == null) {
            throw new NullPointerException();
        }
        if (textSupport == textSupport2) {
            return;
        }
        if (textSupport2.editor != null) {
            throw new IllegalArgumentException("Already installed on another text widget");
        }
        if (textSupport != null) {
            textSupport.editor = null;
        }
        textSupport2.editor = this;
    }

    public final boolean isEditable() {
        return this.getEditable();
    }

    public boolean isSingleLine() {
        return false;
    }

    public String getText() {
        return this.model.getText();
    }

    public void setText(String string) {
        this.model.setText(string);
    }

    public boolean getAllowCopying() {
        return this.allowCopying;
    }

    public void setAllowCopying(boolean bl) {
        this.allowCopying = bl;
    }

    public Position getCaretPosition() {
        return this.caretPos;
    }

    public void moveCaretPosition(Position position) {
        BComplex bComplex;
        Position position2 = this.model.getEndPosition();
        if (position.compareTo(position2) > 0) {
            position = position2;
        }
        this.caretPos = position;
        if (this.hasFocus()) {
            Blinker.pauseBlinking();
        }
        this.scrollToVisible(position);
        BComplex bComplex2 = this.getParent();
        if (bComplex2 != null && (bComplex = bComplex2.getParent()) instanceof CaretTracker) {
            ((CaretTracker)bComplex).caretMoved(position);
        }
        this.repaint();
    }

    public boolean isCaretBlinking() {
        return this == Blinker.getBlinkingWidget();
    }

    public void setCaretBlinking(boolean bl) {
        if (bl) {
            Blinker.startBlinking(this);
        } else {
            Blinker.stopBlinking();
            this.caretVisible = false;
        }
        try {
            this.repaint();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void blinkCaret(boolean bl) {
        this.caretVisible = bl;
        try {
            this.repaint();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public int getVisibleLineCount() {
        double d = this.getHeight();
        BWidget bWidget = this.getParentWidget();
        if (bWidget instanceof BScrollPane) {
            d = bWidget.getHeight() - 4.0;
        }
        return (int)(d / this.renderer.getLineHeight());
    }

    public void scrollToVisible(Position position) {
        if (position.line >= this.model.getLineCount()) {
            return;
        }
        Line line = this.model.getLine(position.line);
        BInsets bInsets = this.getInsets();
        double d = this.renderer.getLineHeight();
        double d2 = this.renderer.getColumnWidth(line, position.column);
        double d3 = this.renderer.columnToX(line, position.column) + bInsets.left;
        double d4 = d * (double)position.line + bInsets.top;
        double d5 = d2;
        double d6 = this.renderer.getLineHeight() + bInsets.top;
        this.scrollToVisible(new RectGeom(d3 -= d2, d4 -= d, d5 += d2 * 2.0, d6 += d * 2.0));
    }

    public Position getPositionAt(double d, double d2) {
        BInsets bInsets = this.getInsets();
        int n = (int)Math.ceil((int)((d2 -= bInsets.top) / this.renderer.getLineHeight()));
        Line line = this.renderer.getModel().getLine(n);
        int n2 = this.renderer.xToColumn(line, d -= bInsets.left);
        return new Position(n, n2);
    }

    public void computePreferredSize() {
        BInsets bInsets = this.getInsets();
        double d = this.model.getPreferredWidth() + bInsets.left + bInsets.right;
        double d2 = this.model.getPreferredHeight() + bInsets.top + bInsets.bottom;
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
    }

    protected BInsets getInsets() {
        return insets;
    }

    public void paint(Graphics graphics) {
        int n;
        TextModel textModel = this.model;
        TextRenderer textRenderer = this.renderer;
        double d = textModel.getLineCount();
        double d2 = textRenderer.getLineHeight();
        Position position = this.getSelection().getStart();
        Position position2 = this.getSelection().getEnd();
        IRectGeom iRectGeom = graphics.getClipBounds();
        BInsets bInsets = this.getInsets();
        int n2 = Math.max(0, (int)((iRectGeom.y() - bInsets.top) / d2));
        int n3 = (int)Math.min(d - 1.0, (double)((int)((iRectGeom.y() + iRectGeom.height() - bInsets.top) / d2)));
        this.getRenderer().paintBackground(graphics);
        graphics.translate(bInsets.left, bInsets.top);
        int n4 = this.getOptions().getShowMargin();
        if (n4 > 0 && !this.isSingleLine()) {
            graphics.setBrush(this.getOptions().getColorCoding().getWhitespace());
            double d3 = (double)n4 * textRenderer.getColumnWidth(null, 0);
            graphics.strokeLine(d3, iRectGeom.y(), d3, iRectGeom.y() + iRectGeom.height());
        }
        for (n = n2; n <= n3; ++n) {
            Line line;
            this.lineInfo.line = line = textModel.getLine(n);
            this.lineInfo.lineIndex = n;
            this.lineInfo.selectionStartColumn = -1;
            this.lineInfo.selectionEndColumn = -1;
            if (position != null && position.line <= n && n <= position2.line) {
                this.lineInfo.selectionStartColumn = position.line == n ? position.column : 0;
                this.lineInfo.selectionEndColumn = position2.line == n ? position2.column : Integer.MAX_VALUE;
            }
            graphics.translate(0.0, (double)n * d2);
            textRenderer.paintLine(graphics, this.lineInfo);
            graphics.translate(0.0, (double)(-n) * d2);
        }
        if (this.caretVisible) {
            n = this.caretPos.line;
            this.lineInfo.line = textModel.getLine(n);
            this.lineInfo.lineIndex = n;
            this.lineInfo.selectionStartColumn = -1;
            this.lineInfo.selectionEndColumn = -1;
            graphics.translate(0.0, (double)n * d2);
            textRenderer.paintCaret(graphics, this.lineInfo, this.caretPos.column);
            graphics.translate(0.0, (double)(-n) * d2);
        }
        graphics.translate(-bInsets.left, -bInsets.top);
    }

    public String getStyleSelector() {
        return "text-editor";
    }

    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.controller.focusGained(bFocusEvent);
        this.scrollToVisible(this.caretPos);
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.controller.focusLost(bFocusEvent);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        this.controller.keyPressed(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        this.controller.keyReleased(bKeyEvent);
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        this.controller.keyTyped(bKeyEvent);
    }

    public void fireKeyEvent(BKeyEvent bKeyEvent) {
        switch (bKeyEvent.getId()) {
            case 401: {
                this.keyPressed(bKeyEvent);
                break;
            }
            case 402: {
                this.keyReleased(bKeyEvent);
                break;
            }
            case 400: {
                this.keyTyped(bKeyEvent);
            }
        }
        this.fire(keyEvent, (BValue)bKeyEvent, null);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.controller.mousePressed(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.controller.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.controller.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.controller.mouseExited(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.controller.mouseMoved(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.controller.mouseDragged(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.controller.mousePulsed(bMouseEvent);
    }

    public void changed(Property property, Context context) {
        if (property == null) {
            this.updateEnableStates();
        } else if (property == editable) {
            StyleUtils.toggleStyleClass(this, "readonly", !this.getEditable());
        } else if (property == enabled) {
            StyleUtils.toggleStyleClass(this, "disabled", !this.isEnabled());
        }
        this.repaint();
    }

    public void updateEnableStates() {
        boolean bl = this.getEditable();
        boolean bl2 = !this.selection.isEmpty();
        this.setCopyEnabled(this.getAllowCopying() && bl2);
        this.setCutEnabled(this.getAllowCopying() && bl && bl2);
        this.setPasteEnabled(bl);
        this.setDeleteEnabled(bl && bl2);
    }

    public void updateAnchorX() {
        this.updateAnchorX(this.getCaretPosition());
    }

    public void updateAnchorX(Position position) {
        TextModel textModel = this.getModel();
        Line line = textModel.getLine(position.line);
        textModel.setAnchorX(this.getRenderer().columnToX(line, position.column));
    }

    public CommandArtifact doFind() throws Exception {
        return this.commandFactory.make("find").doInvoke();
    }

    public CommandArtifact doFindPrev() throws Exception {
        return this.commandFactory.make("findPrev").doInvoke();
    }

    public CommandArtifact doFindNext() throws Exception {
        return this.commandFactory.make("findNext").doInvoke();
    }

    public CommandArtifact doReplace() throws Exception {
        return this.commandFactory.make("replace").doInvoke();
    }

    public CommandArtifact doGoto() throws Exception {
        return this.commandFactory.make("goTo").doInvoke();
    }

    public CommandArtifact doDelete() throws Exception {
        return new RemoveText(this).doInvoke();
    }

    public TransferEnvelope getTransferData() throws Exception {
        String string = this.getModel().getSelectedText();
        return TransferEnvelope.make(string);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return new RemoveText(this).doInvoke();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        String string = (String)transferContext.getEnvelope().getData(TransferFormat.string);
        return new InsertText(this, string).doInvoke();
    }

    public BIcon getIcon() {
        return icon;
    }

    public UndoManager getInstalledUndoManager() {
        return this.undoManager;
    }

    public void setInstalledUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class TextSupport {
        BTextEditor editor;

        public final BTextEditor getEditor() {
            return this.editor;
        }

        public TextModel getModel() {
            return this.editor.model;
        }

        public TextController getController() {
            return this.editor.controller;
        }

        public TextRenderer getRenderer() {
            return this.editor.renderer;
        }

        public TextSelection getSelection() {
            return this.editor.selection;
        }

        public BTextEditorOptions getOptions() {
            return this.editor.options;
        }

        public TextParser getParser() {
            return this.editor.parser;
        }

        public TextCommandFactory getCommandFactory() {
            return this.editor.commandFactory;
        }

        public BWidgetShell getShell() {
            return this.editor.getShell();
        }
    }
}

