/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.BitSet;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableSubject;

public class TableSelection
extends BTable.TableSupport {
    private BitSet bits = new BitSet();
    private int lead = -1;
    private int anchor = -1;

    public boolean isSelected(int n, int n2) {
        return this.isSelected(n);
    }

    public boolean isSelected(int n) {
        return this.bits.get(n);
    }

    public void selectAll() {
        int n = this.getModel().getRowCount();
        if (n > 0) {
            this.select(0, n - 1);
        }
    }

    public void select(int n) {
        this.select(n, false);
    }

    public void select(int n, boolean bl) {
        if (bl || n < 0) {
            this.bits = new BitSet(this.bits.size());
        }
        if (n >= 0) {
            this.bits.set(n);
            this.anchor = this.lead = n;
        }
        this.updateTable();
    }

    public void select(int n, int n2) {
        this.select(n, n2, false);
    }

    public void select(int n, int n2, boolean bl) {
        int n3;
        if (bl) {
            this.bits = new BitSet(this.bits.size());
        }
        this.anchor = n;
        this.lead = n2;
        int n4 = n2;
        int n5 = n;
        if (n4 < n5) {
            n3 = n5;
            n5 = n4;
            n4 = n3;
        }
        for (n3 = n5; n3 <= n4; ++n3) {
            this.bits.set(n3);
        }
        this.updateTable();
    }

    public void select(int[] nArray) {
        this.bits = new BitSet(this.bits.size());
        if (nArray.length == 0) {
            return;
        }
        this.anchor = nArray[0];
        this.lead = nArray[nArray.length - 1];
        for (int i = 0; i < nArray.length; ++i) {
            this.bits.set(nArray[i]);
        }
        this.updateTable();
    }

    public void deselect(int n) {
        this.bits.clear(n);
        this.anchor = this.lead = n;
        this.updateTable();
    }

    public void deselectAll() {
        this.bits = new BitSet(this.bits.size());
        this.updateTable();
    }

    public boolean isEmpty() {
        return this.getRowCount() == 0;
    }

    public int getRowCount() {
        int n = this.getTable().getModel().getRowCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.bits.get(i)) continue;
            ++n2;
        }
        return n2;
    }

    public int getRow() {
        for (int i = 0; i < this.bits.size(); ++i) {
            if (!this.bits.get(i)) continue;
            return i;
        }
        return -1;
    }

    public int[] getRows() {
        int n = this.getTable().getModel().getRowCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (!this.bits.get(i)) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getLead() {
        return this.lead;
    }

    public final TableSubject getSubject() {
        return this.getSubject(this.lead);
    }

    public TableSubject getSubject(int n) {
        return new TableSubject(this.getTable(), this.getRows(), n);
    }

    public void updateTable() {
        BTable bTable = this.getTable();
        if (bTable != null) {
            bTable.repaint();
            this.getTable().fireSelectionModified(new BWidgetEvent(1, this.getTable()));
        }
    }
}

