/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.baja.collection.BITable;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.util.UiLexicon;

public class TableController
extends BTable.TableSupport {
    private int overResize = -1;
    private int overHeader = -1;
    private int overRow = -1;
    private int overColumn = -1;
    private boolean overBackground;
    private boolean checkSelectionOnRelease;
    private String searchText = "";
    private long lastSearchTime = 0L;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;
    static /* synthetic */ Class class$javax$baja$collection$BITable;

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        BTable bTable = this.getTable();
        TableSelection tableSelection = bTable.getSelection();
        if (tableSelection.getRow() == -1 && bTable.getModel().getRowCount() > 0) {
            tableSelection.select(0);
        }
        this.getTable().repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.getTable().repaint();
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0 && bKeyEvent.getModifiers() != 1) {
            return;
        }
        int n = bKeyEvent.getKeyCode();
        BTable bTable = this.getTable();
        TableSelection tableSelection = bTable.getSelection();
        int n2 = tableSelection.getAnchor();
        int n3 = tableSelection.getLead();
        int n4 = bTable.getVisibleRowCount();
        int n5 = bTable.getVscrollBar().getPosition();
        int n6 = -1;
        switch (n) {
            case 36: {
                n6 = 0;
                this.searchText = "";
                break;
            }
            case 35: {
                n6 = bTable.getModel().getRowCount() - 1;
                this.searchText = "";
                break;
            }
            case 38: {
                n6 = Math.max(n3 - 1, 0);
                this.searchText = "";
                break;
            }
            case 40: {
                n6 = Math.min(n3 + 1, bTable.getModel().getRowCount() - 1);
                this.searchText = "";
                break;
            }
            case 33: {
                n6 = n3 > n5 && n3 <= n5 + n4 ? Math.max(n5, 0) : Math.max(n3 - n4 + 1, 0);
                this.searchText = "";
                break;
            }
            case 34: {
                n6 = n3 > n5 && n3 < n5 + n4 - 1 ? Math.min(n5 + n4 - 1, bTable.getModel().getRowCount() - 1) : Math.min(n3 + n4 - 1, bTable.getModel().getRowCount() - 1);
                this.searchText = "";
            }
        }
        if (n6 != -1) {
            bKeyEvent.consume();
            if (bKeyEvent.isShiftDown()) {
                tableSelection.select(n2, n6, true);
            } else {
                tableSelection.select(n6, true);
            }
            bTable.ensureRowIsVisible(n6);
        } else if (this.getTextSearchColumn() != -1) {
            char c = bKeyEvent.getKeyChar();
            if (32 <= n && n <= 57 || 65 <= n && n <= 90) {
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + c : "" + c;
                if (!this.search(this.searchText)) {
                    // empty if block
                }
                this.lastSearchTime = Clock.ticks();
                bKeyEvent.consume();
            }
        }
    }

    public int getTextSearchColumn() {
        return -1;
    }

    private boolean search(String string) {
        TableModel tableModel = this.table.getModel();
        TableSelection tableSelection = this.getSelection();
        int n = -1;
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            String string2 = tableModel.getValueAt(i, this.getTextSearchColumn()).toString();
            if (string2 == null || string2.length() <= 0 || !string2.toLowerCase().startsWith(string.toLowerCase())) continue;
            n = i;
            break;
        }
        if (n >= 0) {
            tableSelection.select(n, true);
            this.table.ensureRowIsVisible(n);
            return true;
        }
        return false;
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        if (bKeyEvent.getKeyCode() == 10) {
            this.handleEnter(bKeyEvent);
        } else if (bKeyEvent.getKeyCode() == 27) {
            this.handleEscape(bKeyEvent);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    protected void handleEnter(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
    }

    protected void handleEscape(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getTable().fireCancelled(new BWidgetEvent(2, this.getTable()));
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellPressed(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerPressed(bMouseEvent, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotPressed(bMouseEvent, this.overResize);
        } else if (this.overBackground) {
            this.backgroundPressed(bMouseEvent);
        }
        if (this.overRow != -1) {
            this.getTable().requestFocus();
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellReleased(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerReleased(bMouseEvent, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotReleased(bMouseEvent, this.overResize);
        } else if (this.overBackground) {
            this.backgroundReleased(bMouseEvent);
        }
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.fireExit(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        if (this.checkMouseOver(bMouseEvent)) {
            return;
        }
        if (this.overRow != -1) {
            this.cellMoved(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerMoved(bMouseEvent, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotMoved(bMouseEvent, this.overResize);
        } else if (this.overBackground) {
            this.backgroundMoved(bMouseEvent);
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellDragged(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerDragged(bMouseEvent, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotDragged(bMouseEvent, this.overResize);
        } else if (this.overBackground) {
            this.backgroundDragged(bMouseEvent);
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellPulsed(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerPulsed(bMouseEvent, this.overHeader);
        } else if (this.overResize != -1) {
            this.resizeHotspotPulsed(bMouseEvent, this.overResize);
        } else if (this.overBackground) {
            this.backgroundPulsed(bMouseEvent);
        }
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        BScrollBar bScrollBar = this.getTable().getVscrollBar();
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            bScrollBar.incrementByUnit();
        } else {
            bScrollBar.decrementByUnit();
        }
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellHover(bMouseEvent, this.overRow, this.overColumn);
        } else if (this.overHeader != -1) {
            this.headerHover(bMouseEvent, this.overHeader);
        } else if (this.overBackground) {
            this.backgroundHover(bMouseEvent);
        }
    }

    private boolean checkMouseOver(BMouseEvent bMouseEvent) {
        BTable bTable = this.getTable();
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        int n = bTable.getRowAt(d2);
        int n2 = bTable.getColumnAt(d);
        if (n == -1 || n2 == -1) {
            if (!this.overBackground) {
                this.fireExit(bMouseEvent);
                this.overBackground = true;
                this.backgroundEntered(bMouseEvent);
                return true;
            }
        } else if (n == Integer.MAX_VALUE) {
            int n3 = this.getResize(bTable, n2, d);
            if (n3 != -1) {
                if (this.overResize != n3) {
                    this.fireExit(bMouseEvent);
                    this.overResize = n3;
                    this.resizeHotspotEntered(bMouseEvent, this.overResize);
                    return true;
                }
                return false;
            }
            if (this.overHeader != n2) {
                this.fireExit(bMouseEvent);
                this.overHeader = n2;
                this.headerEntered(bMouseEvent, this.overHeader);
                return true;
            }
        } else {
            int n4;
            if (this.getTable().getExtendedResize() && (n4 = this.getResize(bTable, n2, d)) != -1) {
                if (this.overResize != n4) {
                    this.fireExit(bMouseEvent);
                    this.overResize = n4;
                    this.resizeHotspotEntered(bMouseEvent, this.overResize);
                    return true;
                }
                return false;
            }
            if (this.overRow != n || this.overColumn != n2) {
                this.fireExit(bMouseEvent);
                this.overRow = n;
                this.overColumn = n2;
                this.cellEntered(bMouseEvent, this.overRow, this.overColumn);
                return true;
            }
        }
        return false;
    }

    private int getResize(BTable bTable, int n, double d) {
        d = bTable.translateXToTable(d);
        int n2 = bTable.getModel().getColumnCount();
        int n3 = -1;
        RectGeom rectGeom = bTable.getHeaderBounds(n);
        double d2 = rectGeom.x;
        double d3 = rectGeom.x + rectGeom.width;
        if (d > d3 - 4.0 && n != n2 - 1) {
            n3 = n + 1;
        } else if (d < d2 + 4.0 && n != 0) {
            n3 = n;
        }
        return n3;
    }

    private void fireExit(BMouseEvent bMouseEvent) {
        if (this.overRow != -1) {
            this.cellExited(bMouseEvent, this.overRow, this.overColumn);
            this.overColumn = -1;
            this.overRow = -1;
        } else if (this.overHeader != -1) {
            this.headerExited(bMouseEvent, this.overHeader);
            this.overHeader = -1;
        } else if (this.overResize != -1) {
            this.resizeHotspotExited(bMouseEvent, this.overResize);
            this.overResize = -1;
        } else if (this.overBackground) {
            this.backgroundExited(bMouseEvent);
            this.overBackground = false;
        }
    }

    public int getMouseOverHeader() {
        return this.overHeader;
    }

    public int getMouseOverColumn() {
        return this.overColumn;
    }

    public int getMouseOverRow() {
        return this.overRow;
    }

    public int getMouseOverResizeColumn() {
        return this.overResize;
    }

    protected void headerEntered(BMouseEvent bMouseEvent, int n) {
    }

    protected void headerExited(BMouseEvent bMouseEvent, int n) {
    }

    protected void headerPressed(BMouseEvent bMouseEvent, int n) {
        BTable bTable;
        if (bMouseEvent.isButton1Down() && (bTable = this.getTable()).getModel().isColumnSortable(n)) {
            boolean bl = bTable.isSortAscending();
            if (bTable.getSortColumn() == n) {
                bTable.sortByColumn(n, !bl);
            } else {
                bTable.sortByColumn(n, bl);
            }
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.headerPopup(bMouseEvent, n);
        }
    }

    protected void headerReleased(BMouseEvent bMouseEvent, int n) {
        if (bMouseEvent.isPopupTrigger()) {
            this.headerPopup(bMouseEvent, n);
        }
    }

    protected void headerMoved(BMouseEvent bMouseEvent, int n) {
    }

    protected void headerDragged(BMouseEvent bMouseEvent, int n) {
    }

    protected void headerPulsed(BMouseEvent bMouseEvent, int n) {
    }

    protected void headerPopup(BMouseEvent bMouseEvent, int n) {
        DynamicTableModel dynamicTableModel;
        TableModel tableModel = this.getModel();
        if (tableModel instanceof DynamicTableModel && (dynamicTableModel = (DynamicTableModel)tableModel).isColumnShowable(n = dynamicTableModel.toRootColumnIndex(n))) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, new HideColumnCommand(dynamicTableModel, n));
            bMenu.open(this.getTable(), bMouseEvent.getX(), bMouseEvent.getY());
        }
    }

    protected void headerHover(BMouseEvent bMouseEvent, int n) {
    }

    protected void cellEntered(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellExited(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellPressed(BMouseEvent bMouseEvent, int n, int n2) {
        if (this.getSelection().isSelected(n)) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(bMouseEvent, n);
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.cellPopup(bMouseEvent, n, n2);
        }
        if (bMouseEvent.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.cellDoubleClicked(bMouseEvent, n, n2);
        }
    }

    protected void cellReleased(BMouseEvent bMouseEvent, int n, int n2) {
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!bMouseEvent.isPopupTrigger()) {
                this.checkSelection(bMouseEvent, n);
            }
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.cellPopup(bMouseEvent, n, n2);
        }
    }

    protected void cellMoved(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellDragged(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellPulsed(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void cellHover(BMouseEvent bMouseEvent, int n, int n2) {
    }

    protected void resizeHotspotPressed(BMouseEvent bMouseEvent, int n) {
    }

    protected void resizeHotspotReleased(BMouseEvent bMouseEvent, int n) {
    }

    protected void resizeHotspotEntered(BMouseEvent bMouseEvent, int n) {
        this.getTable().setMouseCursor(MouseCursor.eResize);
    }

    protected void resizeHotspotExited(BMouseEvent bMouseEvent, int n) {
        this.getTable().setMouseCursor(MouseCursor.normal);
    }

    protected void resizeHotspotMoved(BMouseEvent bMouseEvent, int n) {
    }

    protected void resizeHotspotDragged(BMouseEvent bMouseEvent, int n) {
        this.getTable().setColumnPosition(n, bMouseEvent.getX());
    }

    protected void resizeHotspotPulsed(BMouseEvent bMouseEvent, int n) {
    }

    protected void backgroundEntered(BMouseEvent bMouseEvent) {
    }

    protected void backgroundExited(BMouseEvent bMouseEvent) {
    }

    protected void backgroundPressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.backgroundPopup(bMouseEvent);
        } else if (!bMouseEvent.isButton3Down()) {
            this.getSelection().deselectAll();
        }
    }

    protected void backgroundReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.backgroundPopup(bMouseEvent);
        }
    }

    protected void backgroundMoved(BMouseEvent bMouseEvent) {
    }

    protected void backgroundDragged(BMouseEvent bMouseEvent) {
    }

    protected void backgroundPulsed(BMouseEvent bMouseEvent) {
    }

    protected void backgroundHover(BMouseEvent bMouseEvent) {
    }

    protected void cellPopup(BMouseEvent bMouseEvent, int n, int n2) {
        this.popup(bMouseEvent, n, n2);
    }

    protected void backgroundPopup(BMouseEvent bMouseEvent) {
        this.popup(bMouseEvent, -1, -1);
    }

    protected void popup(BMouseEvent bMouseEvent, int n, int n2) {
        TableSubject tableSubject = this.getSelection().getSubject(n);
        BMenu bMenu = this.makePopup(tableSubject);
        if (bMenu != null) {
            bMenu.removeConsecutiveSeparators();
            bMenu.open(bMouseEvent);
        }
    }

    protected BMenu makePopup(TableSubject tableSubject) {
        return null;
    }

    public void doOptions() {
        BMenu bMenu = this.makeOptionsMenu();
        if (bMenu != null) {
            BTable bTable = this.getTable();
            bMenu.computePreferredSize();
            BButton bButton = bTable.getOptionsButton();
            double d = bButton.getX() + bButton.getWidth();
            double d2 = bButton.getY() + bButton.getHeight();
            if (d <= 0.0) {
                d = 0.0;
            }
            if (d2 <= 0.0) {
                d2 = 0.0;
            }
            bMenu.open(bTable, d -= bMenu.getPreferredWidth(), d2);
        }
    }

    protected BMenu makeOptionsMenu() {
        BTable bTable = this.getTable();
        TableModel tableModel = this.getModel();
        BMenu bMenu = new BMenu();
        bMenu.add("resizeColumns", new ResizeColumnsCommand(bTable));
        bMenu.add("export", new ExportCommand(bTable));
        if (tableModel instanceof DynamicTableModel) {
            DynamicTableModel dynamicTableModel = (DynamicTableModel)tableModel;
            bMenu.add("showSep", (BValue)new BSeparator());
            int n = 0;
            for (int i = 0; i < dynamicTableModel.getRootColumnCount(); ++i) {
                if (!dynamicTableModel.isColumnShowable(i)) continue;
                bMenu.add(null, new ShowColumnCommand(dynamicTableModel, i));
                ++n;
            }
            if (n == 0) {
                bMenu.remove("showSep");
            }
        }
        return bMenu;
    }

    static CommandArtifact exportDialog(BTable bTable, boolean bl) throws Exception {
        try {
            BITable bITable = bTable.getModel().export();
            Type type = Sys.getType((String)"workbench:ExportDialog");
            Class clazz = type.getTypeClass();
            Method method = clazz.getMethod("invoke", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = TableController.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget, class$javax$baja$collection$BITable == null ? (class$javax$baja$collection$BITable = TableController.class$("javax.baja.collection.BITable")) : class$javax$baja$collection$BITable, Boolean.TYPE);
            return (CommandArtifact)method.invoke(null, bTable, bITable, new Boolean(bl));
        }
        catch (InvocationTargetException invocationTargetException) {
            throw (Exception)invocationTargetException.getTargetException();
        }
    }

    protected void checkSelection(BMouseEvent bMouseEvent, int n) {
        BTable bTable = this.getTable();
        TableSelection tableSelection = bTable.getSelection();
        if (bTable.getMultipleSelection()) {
            if (bMouseEvent.isShiftDown() && tableSelection.getAnchor() >= 0) {
                tableSelection.select(tableSelection.getAnchor(), n, !bMouseEvent.isControlDown());
            } else if (bMouseEvent.isControlDown()) {
                if (tableSelection.isSelected(n)) {
                    tableSelection.deselect(n);
                } else {
                    tableSelection.select(n);
                }
            } else {
                tableSelection.select(n, true);
                this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
            }
        } else {
            tableSelection.select(n, true);
            this.getTable().fireActionPerformed(new BWidgetEvent(2, this.getTable()));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class ShowColumnCommand
    extends ToggleCommand {
        DynamicTableModel model;
        int column;

        ShowColumnCommand(DynamicTableModel dynamicTableModel, int n) {
            super(dynamicTableModel.getTable(), dynamicTableModel.getRootColumnName(n));
            this.model = dynamicTableModel;
            this.column = n;
            this.setSelected(dynamicTableModel.showColumn(n));
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            this.model.setShowColumn(this.column, bl);
        }
    }

    class HideColumnCommand
    extends Command {
        DynamicTableModel model;
        int column;

        HideColumnCommand(DynamicTableModel dynamicTableModel, int n) {
            super((BWidget)dynamicTableModel.getTable(), UiLexicon.bajaui().module, "commands.table.hideColumn");
            this.model = dynamicTableModel;
            this.column = n;
        }

        public CommandArtifact doInvoke() {
            this.model.setShowColumn(this.column, false);
            return null;
        }
    }

    public class ExportCommand
    extends Command {
        public ExportCommand(BTable bTable) {
            super((BWidget)bTable, UiLexicon.bajaui().module, "commands.export");
            this.accelerator = null;
        }

        public CommandArtifact doInvoke() throws Exception {
            return TableController.exportDialog((BTable)this.getOwner(), true);
        }
    }

    class PrintCommand
    extends Command {
        PrintCommand(BTable bTable) {
            super((BWidget)bTable, UiLexicon.bajaui().module, "commands.print");
            this.accelerator = null;
        }

        public CommandArtifact doInvoke() throws Exception {
            return TableController.exportDialog((BTable)this.getOwner(), true);
        }
    }

    public class ResizeColumnsCommand
    extends Command {
        public ResizeColumnsCommand(BTable bTable) {
            super((BWidget)bTable, UiLexicon.bajaui().module, "commands.table.resizeColumns");
        }

        public CommandArtifact doInvoke() {
            TableController.this.getTable().sizeColumnsToFit();
            return null;
        }
    }
}

