/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;

public class TableCellRenderer
extends BTable.TableSupport {
    private RectGeom clip = new RectGeom();

    public BBrush getForeground(Cell cell) {
        return Theme.table().getTextBrush(this.getTable());
    }

    public BBrush getBackground(Cell cell) {
        return null;
    }

    public BFont getFont(Cell cell) {
        return Theme.table().getCellFont(this.getTable());
    }

    public BBrush getSelectionForeground(Cell cell) {
        return Theme.table().getSelectionForeground(this.getTable());
    }

    public BBrush getSelectionBackground(Cell cell) {
        return Theme.table().getSelectionBackground(this.getTable());
    }

    public double getCellHeight() {
        return Math.max(Theme.table().getCellHeight(), 16.0);
    }

    public double getPreferredCellWidth(Cell cell) {
        String string = this.getCellText(cell);
        double d = this.getFont(cell).width(string) + 12.0;
        if (cell.column == 0 && this.getTable().getModel().getRowIcon(cell.row) != null) {
            d += 20.0;
        }
        return d;
    }

    public IGeom getClip(Cell cell) {
        this.clip.set(0.0, 0.0, cell.width, cell.height);
        return this.clip;
    }

    public String getCellText(Cell cell) {
        return String.valueOf(cell.value);
    }

    public void paintCell(Graphics graphics, Cell cell) {
        String string;
        TableModel tableModel = this.getTable().getModel();
        this.paintCellBackground(graphics, cell);
        double d = 2.0;
        double d2 = (cell.height - 16.0) / 2.0;
        if (cell.column == 0 && (string = tableModel.getRowIcon(cell.row)) != null) {
            graphics.drawImage((BImage)string, d, d2);
            d += 20.0;
        }
        string = this.getCellText(cell);
        BFont bFont = this.getFont(cell);
        switch (tableModel.getColumnAlignment(cell.column).getOrdinal()) {
            case 2: {
                d = cell.width - 2.0 - bFont.width(string);
                break;
            }
            case 1: {
                d = (cell.width - bFont.width(string)) / 2.0;
            }
        }
        graphics.setFont(bFont);
        if (cell.selected) {
            graphics.setBrush(this.getSelectionForeground(cell));
        } else {
            graphics.setBrush(this.getForeground(cell));
        }
        graphics.drawString(string, d, (cell.height + bFont.getAscent() - bFont.getDescent()) / 2.0);
    }

    protected void paintCellBackground(Graphics graphics, Cell cell) {
        if (cell.selected) {
            BBrush bBrush = this.getSelectionBackground(cell);
            if (bBrush != null && !bBrush.isNull()) {
                graphics.setBrush(bBrush);
                graphics.fillRect(0.0, 0.0, cell.width, cell.height);
            }
            graphics.setBrush(this.getSelectionForeground(cell));
        } else {
            BBrush bBrush = this.getBackground(cell);
            if (bBrush != null && !bBrush.isNull()) {
                graphics.setBrush(bBrush);
                graphics.fillRect(0.0, 0.0, cell.width, cell.height);
            }
            graphics.setBrush(this.getForeground(cell));
        }
        graphics.setFont(this.getFont(cell));
    }

    public static class Cell {
        public int row;
        public int column;
        public Object value;
        public double width;
        public double height;
        public boolean selected;
    }
}

