/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.BitSet;
import javax.baja.sys.BObject;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;

public class DynamicTableModel
extends WrapperTableModel {
    BitSet showCols = new BitSet();
    BitSet showable = new BitSet();
    int showCount = -1;
    int[] toRootMap;
    int[] fromRootMap;

    public DynamicTableModel(TableModel tableModel, int[] nArray) {
        super(tableModel);
        for (int i = 0; i < nArray.length; ++i) {
            this.showCols.set(nArray[i]);
        }
        DynamicTableModel.set(this.showable, 0, tableModel.getColumnCount());
    }

    public DynamicTableModel(TableModel tableModel) {
        super(tableModel);
        DynamicTableModel.set(this.showCols, 0, 255);
        DynamicTableModel.set(this.showable, 0, 255);
    }

    public int getColumnCount() {
        if (this.showCount < 0) {
            this.columnsModified();
        }
        return this.showCount;
    }

    public String getColumnName(int n) {
        return this.root.getColumnName(this.toRootColumnIndex(n));
    }

    public Object getValueAt(int n, int n2) {
        return this.root.getValueAt(n, this.toRootColumnIndex(n2));
    }

    public Object getSubject(int n) {
        return this.root.getSubject(n);
    }

    public BHalign getColumnAlignment(int n) {
        return this.root.getColumnAlignment(this.toRootColumnIndex(n));
    }

    public boolean isColumnSortable(int n) {
        return this.root.isColumnSortable(this.toRootColumnIndex(n));
    }

    public void sortByColumn(int n, boolean bl) {
        this.root.sortByColumn(this.toRootColumnIndex(n), bl);
    }

    public int getRootColumnCount() {
        return this.root.getColumnCount();
    }

    public String getRootColumnName(int n) {
        return this.root.getColumnName(n);
    }

    public int toRootColumnIndex(int n) {
        if (n < 0) {
            return n;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.toRootMap[n];
    }

    public int fromRootColumnIndex(int n) {
        if (n < 0) {
            return n;
        }
        if (this.fromRootMap == null) {
            this.columnsModified();
        }
        return this.fromRootMap[n];
    }

    public boolean showColumn(int n) {
        return this.showCols.get(n);
    }

    public void setShowColumn(int n, boolean bl) {
        if (!this.showable.get(n)) {
            return;
        }
        BTable bTable = this.getTable();
        if (this.showCols.get(n) != bl) {
            int n2 = -1;
            boolean bl2 = true;
            if (bTable != null) {
                this.toRootColumnIndex(bTable.getSortColumn());
                bl2 = bTable.isSortAscending();
            }
            DynamicTableModel.set(this.showCols, n, bl);
            this.columnsModified();
            if (bTable != null) {
                this.getTable().sizeColumnsToFit();
            }
            if (bTable != null) {
                int n3;
                bTable.sortByColumn(-1, bl2);
                if (n2 >= 0 && this.showColumn(n2) && (n3 = this.fromRootColumnIndex(n2)) >= 0 && this.root.isColumnSortable(n3)) {
                    bTable.sortByColumn(n3, bl2);
                }
            }
        }
    }

    public void columnsModified() {
        int n = this.getRootColumnCount();
        int n2 = 0;
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            if (this.showColumn(i)) {
                nArray[n2++] = i;
                nArray2[i] = n2 - 1;
                continue;
            }
            nArray2[i] = -1;
        }
        this.showCount = n2;
        this.toRootMap = nArray;
        this.fromRootMap = nArray2;
    }

    public void setColumnShowable(int n, boolean bl) {
        DynamicTableModel.set(this.showable, n, bl);
    }

    public boolean isColumnShowable(int n) {
        return this.showable.get(n);
    }

    public BObject export(int n, int n2) {
        return this.root.export(n, this.toRootColumnIndex(n2));
    }

    static void set(BitSet bitSet, int n, int n2) {
        for (int i = n; i < n2; ++i) {
            bitSet.set(i);
        }
    }

    static void set(BitSet bitSet, int n, boolean bl) {
        if (bl) {
            bitSet.set(n);
        } else {
            bitSet.clear(n);
        }
    }
}

