/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import java.util.List;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.ui.table.TableModel;

public class DefaultTableModel
extends TableModel {
    private String[] columnNames;
    private int count;
    private Row[] rows;

    public DefaultTableModel() {
        this.columnNames = new String[0];
        this.rows = new Row[16];
    }

    public DefaultTableModel(String[] stringArray) {
        this.columnNames = stringArray;
        this.rows = new Row[16];
    }

    public synchronized int getRowCount() {
        return this.count;
    }

    public synchronized int getColumnCount() {
        return this.columnNames.length;
    }

    public synchronized String getColumnName(int n) {
        return this.columnNames[n];
    }

    public synchronized BImage getRowIcon(int n) {
        return this.rows[n].icon;
    }

    public synchronized Object getValueAt(int n, int n2) {
        return this.rows[n].columns[n2];
    }

    public synchronized Object getSubject(int n) {
        return this.getRowValues(n);
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public synchronized void sortByColumn(int n, boolean bl) {
        Object[] objectArray = this.getColumnValues(n);
        Object[] objectArray2 = new Row[objectArray.length];
        System.arraycopy(this.rows, 0, objectArray2, 0, objectArray.length);
        SortUtil.sort((Object[])objectArray, (Object[])objectArray2, (boolean)bl);
        this.rows = objectArray2;
    }

    public synchronized void set(int n, int n2, Object object) {
        this.rows[n].columns[n2] = object;
        this.updateTable();
    }

    public void addRow(Object[] objectArray) {
        this.addRow(new Row(null, objectArray));
    }

    public void addRow(BImage bImage, Object[] objectArray) {
        this.addRow(new Row(bImage, objectArray));
    }

    public void addRow(List list) {
        this.addRow(new Row(null, list.toArray()));
    }

    public void addRow(BImage bImage, List list) {
        this.addRow(new Row(bImage, list.toArray()));
    }

    private synchronized void addRow(Row row) {
        if (row.columns.length != this.columnNames.length) {
            throw new IllegalArgumentException("invalid number of columns");
        }
        if (this.count >= this.rows.length) {
            Row[] rowArray = new Row[this.count * 2 + 1];
            System.arraycopy(this.rows, 0, rowArray, 0, this.count);
            this.rows = rowArray;
        }
        this.rows[this.count++] = row;
        this.updateTable();
    }

    public synchronized void removeRow(int n) {
        System.arraycopy(this.rows, n + 1, this.rows, n, this.count - n - 1);
        this.rows[this.count - 1] = null;
        --this.count;
        this.updateTable();
    }

    public synchronized void removeAllRows() {
        this.count = 0;
        this.updateTable();
    }

    static class Row {
        BImage icon;
        Object[] columns;

        Row(BImage bImage, Object[] objectArray) {
            this.icon = bImage;
            this.columns = objectArray;
        }
    }
}

