/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.table;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableHeaderRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

public class BTable
extends BTransferWidget {
    public static final Property multipleSelection = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property headerVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property optionsButtonVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property hgridVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property vgridVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property extendedResize = BTable.newProperty((int)0, (boolean)false, null);
    public static final Property hscrollBarVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property vscrollBarVisible = BTable.newProperty((int)0, (boolean)true, null);
    public static final Property gridBrush = BTable.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property hscrollBar = BTable.newProperty((int)7, (BValue)new BScrollBar(BOrientation.horizontal), null);
    public static final Property vscrollBar = BTable.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical), null);
    public static final Property optionsButton = BTable.newProperty((int)3, (BValue)new BButton(), null);
    public static final Action vscroll = BTable.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Action hscroll = BTable.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Topic actionPerformed = BTable.newTopic((int)0, null);
    public static final Topic cancelled = BTable.newTopic((int)0, null);
    public static final Topic tableModified = BTable.newTopic((int)0, null);
    public static final Topic selectionModified = BTable.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$table$BTable == null ? (class$javax$baja$ui$table$BTable = BTable.class$("javax.baja.ui.table.BTable")) : class$javax$baja$ui$table$BTable));
    private static final BIcon icon = BIcon.std((String)"widgets/table.png");
    private BScrollBar vsb;
    private BScrollBar hsb;
    private BButton optButton;
    private TableModel model;
    private TableController controller;
    private TableHeaderRenderer headerRenderer;
    private TableCellRenderer cellRenderer;
    private TableSelection selection;
    private double[] columnPositions = new double[0];
    private double[] columnWidths = new double[0];
    private double preferredWidth;
    private double cellHeight;
    private double headerHeight;
    private boolean needsColumnLayout = true;
    private TableHeaderRenderer.Header header = new TableHeaderRenderer.Header();
    private TableCellRenderer.Cell cell = new TableCellRenderer.Cell();
    private int sortColumn = -1;
    private boolean sortAscending = true;
    static /* synthetic */ Class class$javax$baja$ui$table$BTable;

    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    public void setMultipleSelection(boolean bl) {
        this.setBoolean(multipleSelection, bl, null);
    }

    public boolean getHeaderVisible() {
        return this.getBoolean(headerVisible);
    }

    public void setHeaderVisible(boolean bl) {
        this.setBoolean(headerVisible, bl, null);
    }

    public boolean getOptionsButtonVisible() {
        return this.getBoolean(optionsButtonVisible);
    }

    public void setOptionsButtonVisible(boolean bl) {
        this.setBoolean(optionsButtonVisible, bl, null);
    }

    public boolean getHgridVisible() {
        return this.getBoolean(hgridVisible);
    }

    public void setHgridVisible(boolean bl) {
        this.setBoolean(hgridVisible, bl, null);
    }

    public boolean getVgridVisible() {
        return this.getBoolean(vgridVisible);
    }

    public void setVgridVisible(boolean bl) {
        this.setBoolean(vgridVisible, bl, null);
    }

    public boolean getExtendedResize() {
        return this.getBoolean(extendedResize);
    }

    public void setExtendedResize(boolean bl) {
        this.setBoolean(extendedResize, bl, null);
    }

    public boolean getHscrollBarVisible() {
        return this.getBoolean(hscrollBarVisible);
    }

    public void setHscrollBarVisible(boolean bl) {
        this.setBoolean(hscrollBarVisible, bl, null);
    }

    public boolean getVscrollBarVisible() {
        return this.getBoolean(vscrollBarVisible);
    }

    public void setVscrollBarVisible(boolean bl) {
        this.setBoolean(vscrollBarVisible, bl, null);
    }

    public BBrush getGridBrush() {
        return (BBrush)this.get(gridBrush);
    }

    public void setGridBrush(BBrush bBrush) {
        this.set(gridBrush, (BValue)bBrush, null);
    }

    public BScrollBar getHscrollBar() {
        return (BScrollBar)this.get(hscrollBar);
    }

    public void setHscrollBar(BScrollBar bScrollBar) {
        this.set(hscrollBar, (BValue)bScrollBar, null);
    }

    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    public void setVscrollBar(BScrollBar bScrollBar) {
        this.set(vscrollBar, (BValue)bScrollBar, null);
    }

    public BButton getOptionsButton() {
        return (BButton)this.get(optionsButton);
    }

    public void setOptionsButton(BButton bButton) {
        this.set(optionsButton, (BValue)bButton, null);
    }

    public void vscroll(BScrollEvent bScrollEvent) {
        this.invoke(vscroll, (BValue)bScrollEvent, null);
    }

    public void hscroll(BScrollEvent bScrollEvent) {
        this.invoke(hscroll, (BValue)bScrollEvent, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public void fireCancelled(BWidgetEvent bWidgetEvent) {
        this.fire(cancelled, (BValue)bWidgetEvent, null);
    }

    public void fireTableModified(BWidgetEvent bWidgetEvent) {
        this.fire(tableModified, (BValue)bWidgetEvent, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTable() {
        this(new DefaultTableModel(), new TableController(), new TableSelection());
    }

    public BTable(TableModel tableModel) {
        this(tableModel, new TableController(), new TableSelection(), new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel tableModel, TableController tableController) {
        this(tableModel, tableController, new TableSelection(), new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel tableModel, TableController tableController, TableSelection tableSelection) {
        this(tableModel, tableController, tableSelection, new TableHeaderRenderer(), new TableCellRenderer());
    }

    public BTable(TableModel tableModel, TableController tableController, TableSelection tableSelection, TableHeaderRenderer tableHeaderRenderer, TableCellRenderer tableCellRenderer) {
        this.setModel(tableModel);
        this.setController(tableController);
        this.setSelection(tableSelection);
        this.setHeaderRenderer(tableHeaderRenderer);
        this.setCellRenderer(tableCellRenderer);
        this.initUIComponents();
    }

    protected void initUIComponents() {
        this.vsb = this.getVscrollBar();
        this.hsb = this.getHscrollBar();
        this.optButton = this.getOptionsButton();
        this.optButton.setFocusTraversable(false);
        this.optButton.setCommand(new OptionsCommand(this), false, true);
        this.linkTo(this.vsb, (Slot)BScrollBar.positionChanged, (Slot)vscroll);
        this.linkTo(this.hsb, (Slot)BScrollBar.positionChanged, (Slot)hscroll);
    }

    public TableModel getModel() {
        return this.model;
    }

    public void setModel(TableModel tableModel) {
        this.installSupport(this.model, tableModel);
        this.model = tableModel;
        this.fireTableModified(new BWidgetEvent(1, this));
    }

    public TableController getController() {
        return this.controller;
    }

    public void setController(TableController tableController) {
        this.installSupport(this.controller, tableController);
        this.controller = tableController;
    }

    public TableSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TableSelection tableSelection) {
        this.installSupport(this.selection, tableSelection);
        this.selection = tableSelection;
    }

    public TableHeaderRenderer getHeaderRenderer() {
        return this.headerRenderer;
    }

    public void setHeaderRenderer(TableHeaderRenderer tableHeaderRenderer) {
        this.installSupport(this.headerRenderer, tableHeaderRenderer);
        this.headerRenderer = tableHeaderRenderer;
        this.headerHeight = this.getHeaderVisible() ? tableHeaderRenderer.getHeaderHeight() : 1.0;
    }

    public TableCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(TableCellRenderer tableCellRenderer) {
        this.installSupport(this.cellRenderer, tableCellRenderer);
        this.cellRenderer = tableCellRenderer;
        this.cellHeight = tableCellRenderer.getCellHeight();
    }

    private void installSupport(TableSupport tableSupport, TableSupport tableSupport2) {
        if (tableSupport2 == null) {
            throw new NullPointerException();
        }
        if (tableSupport == tableSupport2) {
            return;
        }
        if (tableSupport2.table != null) {
            throw new IllegalArgumentException("Already installed on another table");
        }
        if (tableSupport != null) {
            tableSupport.setTable(null);
        }
        tableSupport2.setTable(this);
    }

    public void changed(Property property, Context context) {
        this.relayout();
    }

    public void computePreferredSize() {
        int n = 0;
        int n2 = 0;
        int n3 = this.model.getColumnCount();
        if (this.needsColumnLayout || n3 != this.columnPositions.length) {
            this.layoutColumns();
        }
        n = (int)((double)n + this.preferredWidth);
        if (this.getHeaderVisible()) {
            n2 = (int)((double)n2 + this.headerRenderer.getHeaderHeight());
        }
        n2 = (int)((double)n2 + (double)this.model.getRowCount() * this.cellHeight);
        n = Math.max(n, 10);
        n2 = Math.max(n2, 10);
        this.setPreferredSize(n, n2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = this.model.getColumnCount();
        double d3 = Theme.scrollBar().getFixedWidth();
        this.headerHeight = this.getHeaderVisible() ? this.headerRenderer.getHeaderHeight() : 1.0;
        this.layoutVertScrollBar();
        if (this.getOptionsButtonVisible() && this.getHeaderVisible()) {
            this.optButton.setBounds(d - d3, 0.0, d3, this.headerHeight);
            double d4 = (this.headerHeight - 7.0) / 2.0;
            this.optButton.setPadding(BInsets.make((double)d4, (double)3.0, (double)0.0, (double)3.0));
        } else {
            this.optButton.setVisible(false);
        }
        if (this.needsColumnLayout || n != this.columnPositions.length) {
            this.layoutColumns();
        }
        this.layoutHorizScrollBar();
    }

    private void layoutVertScrollBar() {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        int n = this.model.getRowCount();
        int n2 = this.model.getColumnCount();
        double d4 = Theme.scrollBar().getFixedWidth();
        int n3 = this.getVisibleRowCount();
        double d5 = d = this.hsb.isVisible() ? d4 - 1.0 : 0.0;
        if (n3 < n && this.getVscrollBarVisible()) {
            this.vsb.setVisible(true);
            this.vsb.setMin(0);
            this.vsb.setMax(n);
            this.vsb.setExtent(n3);
            this.vsb.setBlockIncrement(Math.max(3, n3 - 1));
            double d6 = this.getHeaderVisible() ? this.headerHeight - 1.0 : this.headerHeight;
            this.vsb.setBounds(d2 - d4, d6, d4, d3 - d6 - d);
        } else {
            this.vsb.setVisible(false);
            this.vsb.setBounds(0.0, 0.0, 0.0, 0.0);
            this.vsb.setPosition(0);
            this.vsb.setMin(0);
            this.vsb.setMax(n3);
            this.vsb.setExtent(n3);
        }
    }

    private void layoutHorizScrollBar() {
        int n;
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n2 = this.model.getRowCount();
        double d3 = Theme.scrollBar().getFixedWidth();
        double d4 = 0.0;
        for (n = 0; n < this.columnWidths.length; ++n) {
            d4 += this.columnWidths[n];
        }
        n = this.hsb.isVisible() ? 1 : 0;
        if (d4 > d && this.getHscrollBarVisible()) {
            this.hsb.setVisible(true);
            this.hsb.setMin(0);
            this.hsb.setMax((int)d4);
            this.hsb.setExtent((int)(d - d3));
            double d5 = this.getVisibleRowCount() < n2 ? d3 - 1.0 : 0.0;
            this.hsb.setBounds(0.0, d2 - d3, d - d5, d3);
            if (n == 0) {
                this.layoutVertScrollBar();
            }
        } else {
            this.hsb.setVisible(false);
            if (n != 0) {
                this.layoutVertScrollBar();
            }
        }
    }

    private void layoutColumns() {
        int n;
        TableHeaderRenderer tableHeaderRenderer = this.headerRenderer;
        TableCellRenderer tableCellRenderer = this.cellRenderer;
        TableModel tableModel = this.model;
        int n2 = tableModel.getRowCount();
        int n3 = tableModel.getColumnCount();
        double[] dArray = new double[n3];
        if (this.getHeaderVisible()) {
            for (n = 0; n < n3; ++n) {
                String string = tableModel.getColumnName(n);
                if (string == null) {
                    string = "";
                }
                this.header.column = n;
                this.header.name = string;
                dArray[n] = tableHeaderRenderer.getPreferredHeaderWidth(this.header);
            }
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                this.cell.row = n;
                this.cell.column = i;
                try {
                    this.cell.value = tableModel.getValueAt(n, i);
                    double d = tableCellRenderer.getPreferredCellWidth(this.cell);
                    dArray[i] = Math.max(dArray[i], d);
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        double d = 0.0;
        if (n3 > 0) {
            d = dArray[0];
        }
        double[] dArray2 = new double[n3];
        for (int i = 1; i < n3; ++i) {
            d += dArray[i];
            dArray2[i] = dArray2[i - 1] + dArray[i - 1];
        }
        this.columnPositions = dArray2;
        this.preferredWidth = d;
        this.needsColumnLayout = false;
        this.columnWidths = dArray;
    }

    public void sizeColumnsToFit() {
        this.needsColumnLayout = true;
        this.relayout();
    }

    double translateXToTable(double d) {
        if (this.hsb.isVisible()) {
            return d + (double)this.hsb.getPosition();
        }
        return d;
    }

    public int getColumnAt(double d) {
        d = this.translateXToTable(d);
        double[] dArray = this.columnPositions;
        for (int i = 1; i < dArray.length; ++i) {
            if (!(d < dArray[i])) continue;
            return i - 1;
        }
        return dArray.length - 1;
    }

    public int getRowAt(double d) {
        if (d < 0.0 || d > this.getHeight()) {
            return -1;
        }
        if (d < this.headerHeight) {
            return Integer.MAX_VALUE;
        }
        int n = (int)((d - this.headerHeight) / this.cellHeight) + this.vsb.getPosition();
        if (n < this.model.getRowCount()) {
            return n;
        }
        return -1;
    }

    public double getHeaderWidth(int n) {
        double[] dArray = this.columnWidths;
        double[] dArray2 = this.columnPositions;
        boolean bl = this.getOptionsButtonVisible();
        double d = Theme.scrollBar().getFixedWidth();
        return n < dArray2.length - 1 ? dArray2[n + 1] - dArray2[n] : (this.hsb.isVisible() ? (double)this.hsb.getMax() - dArray2[n] + (bl ? 0.0 : d - 1.0) : this.getWidth() - (bl ? d : 1.0) - dArray2[n]);
    }

    public double getCellWidth(int n) {
        double[] dArray = this.columnWidths;
        double[] dArray2 = this.columnPositions;
        boolean bl = this.vsb.isVisible();
        double d = Theme.scrollBar().getFixedWidth();
        return n < dArray2.length - 1 ? dArray2[n + 1] - dArray2[n] : (this.hsb.isVisible() ? (double)this.hsb.getMax() - dArray2[n] + (bl ? 0.0 : d) : this.getWidth() - (bl ? d : 0.0) - dArray2[n]);
    }

    public RectGeom getHeaderBounds(int n) {
        double d = this.columnPositions[n];
        double d2 = this.getHeaderWidth(n);
        return new RectGeom(d, 0.0, d2, this.headerHeight);
    }

    public RectGeom getCellBounds(int n, int n2) {
        double d = this.columnPositions[n2];
        double d2 = this.headerHeight + (double)n * this.cellHeight;
        double d3 = this.getCellWidth(n2);
        return new RectGeom(d, d2, d3, this.cellHeight);
    }

    public void setColumnPosition(int n, double d) {
        double d2;
        double[] dArray = this.columnPositions;
        double[] dArray2 = this.columnWidths;
        double d3 = 0.0;
        if (n > 0) {
            d3 = dArray[n - 1] + 6.0;
        }
        if (this.hsb.isVisible()) {
            d += (double)this.hsb.getPosition();
        }
        if (d < d3) {
            d = d3;
        }
        if ((d2 = d - dArray[n]) != 0.0) {
            int n2 = n;
            while (n2 < dArray.length) {
                int n3 = n2++;
                dArray[n3] = dArray[n3] + d2;
            }
            int n4 = n;
            dArray2[n4] = dArray2[n4] + d2;
            this.layoutHorizScrollBar();
            this.repaint();
        }
    }

    public int getVisibleRowCount() {
        double d = this.getHeight() - this.headerHeight;
        if (this.hsb.isVisible()) {
            d -= Theme.scrollBar().getFixedWidth();
        }
        return (int)(d / this.cellHeight);
    }

    public void ensureRowIsVisible(int n) {
        int n2 = this.getVisibleRowCount();
        int n3 = this.vsb.getPosition();
        int n4 = n3 + n2;
        int n5 = this.model.getRowCount();
        this.vsb.setMax(Math.max(n2, n5));
        if (n < n3) {
            this.vsb.setPosition(n);
        } else if (n >= n4) {
            int n6 = n - n2 + 1;
            if (n6 >= n5) {
                n6 = n5 - 1;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            this.vsb.setPosition(n6);
        }
    }

    public void doVscroll(BScrollEvent bScrollEvent) {
        this.repaint();
    }

    public void doHscroll(BScrollEvent bScrollEvent) {
        this.repaint();
    }

    public int getSortColumn() {
        return this.sortColumn;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void sortByColumn(int n, boolean bl) {
        this.sortColumn = n;
        this.sortAscending = bl;
        if (n >= 0) {
            this.getModel().sortByColumn(n, bl);
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        int n;
        int n2;
        this.paintBackground(graphics);
        if (this.hsb.isVisible()) {
            graphics.translate((double)(-this.hsb.getPosition()), 0.0);
        }
        IGeom iGeom = graphics.getClip();
        int n3 = this.model.getRowCount();
        int n4 = this.getVisibleRowCount();
        double d = this.headerHeight;
        double d2 = this.cellHeight;
        double d3 = this.getWidth();
        double d4 = this.getHeight();
        double[] dArray = this.columnPositions;
        int n5 = dArray.length;
        if (this.getHeaderVisible()) {
            for (n2 = 0; n2 < n5; ++n2) {
                graphics.push();
                try {
                    this.paintHeader(graphics, n2);
                    continue;
                }
                finally {
                    graphics.pop();
                }
            }
        }
        n2 = this.vsb.getPosition();
        int n6 = Math.min(n2 + n4 + 1, n3);
        double d5 = this.headerHeight;
        for (int i = n2; i < n6; ++i) {
            for (int j = 0; j < n5; ++j) {
                graphics.push();
                try {
                    this.paintCell(graphics, i, j, d5);
                    continue;
                }
                finally {
                    graphics.pop();
                }
            }
            d5 += this.cellHeight;
        }
        double d6 = this.hsb.isVisible() ? (double)this.hsb.getPosition() : 0.0;
        BBrush bBrush = this.getGridBrush();
        if (!bBrush.isNull()) {
            graphics.setBrush(bBrush);
        } else {
            graphics.setBrush(Theme.table().getGridBrush());
        }
        if (this.paintHorizontalGrid()) {
            for (n = 1; n <= n6 - n2; ++n) {
                graphics.strokeLine(d6 + 1.0, (double)n * d2 + d - 1.0, d6 + d3 - 2.0, (double)n * d2 + d - 1.0);
            }
        }
        if (this.paintVerticalGrid()) {
            for (n = 1; n < n5; ++n) {
                graphics.strokeLine(dArray[n], d, dArray[n], d5 - 1.0);
            }
        }
        if (this.hsb.isVisible()) {
            graphics.translate((double)this.hsb.getPosition(), 0.0);
        }
        graphics.setBrush(BColor.black.toBrush());
        graphics.strokeRect(0.0, 0.0, d3 - 1.0, d4 - 1.0);
        this.paintChildren(graphics);
        if (this.hsb.isVisible() && this.vsb.isVisible()) {
            graphics.setBrush(Theme.widget().getControlBackground());
            graphics.fillRect(this.vsb.getX() + 1.0, this.hsb.getY() + 1.0, this.vsb.getWidth() - 2.0, Theme.scrollBar().getFixedWidth() - 2.0);
        }
    }

    protected void paintBackground(Graphics graphics) {
        Theme.table().paintBackground(graphics, this);
    }

    private void paintHeader(Graphics graphics, int n) {
        TableHeaderRenderer.Header header = this.header;
        double d = this.columnPositions[n];
        double d2 = 0.0;
        header.column = n;
        header.name = this.model.getColumnName(n);
        header.height = this.headerHeight;
        header.width = this.getHeaderWidth(n);
        double d3 = Math.min(header.width, this.translateXToTable(this.getWidth()) - d);
        double d4 = Math.min(header.height, this.getHeight());
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        graphics.clip(d, 0.0, d3, d4);
        graphics.translate(d, 0.0);
        this.headerRenderer.paintHeader(graphics, header);
    }

    private void paintCell(Graphics graphics, int n, int n2, double d) {
        TableCellRenderer.Cell cell = this.cell;
        double d2 = this.columnPositions[n2] + 1.0;
        Object object = "?";
        try {
            object = this.model.getValueAt(n, n2);
        }
        catch (Exception exception) {
            System.out.println("ERROR:  BTable.paintCell: " + n + "," + n2);
            System.out.println("  " + exception);
        }
        cell.row = n;
        cell.column = n2;
        cell.value = object;
        cell.width = this.getCellWidth(n2);
        cell.height = this.cellHeight;
        cell.selected = this.selection.isSelected(n, n2);
        double d3 = this.translateXToTable(this.getWidth()) - d2;
        double d4 = this.getHeight() - d;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        graphics.clip(d2, d, d3, d4);
        graphics.translate(d2, d);
        graphics.clip(this.cellRenderer.getClip(cell));
        this.cellRenderer.paintCell(graphics, cell);
    }

    protected boolean paintHorizontalGrid() {
        return this.getHgridVisible();
    }

    protected boolean paintVerticalGrid() {
        return this.getVgridVisible();
    }

    public String getStyleSelector() {
        return "table";
    }

    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.controller.focusGained(bFocusEvent);
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.controller.focusLost(bFocusEvent);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        this.controller.keyPressed(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        this.controller.keyReleased(bKeyEvent);
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        this.controller.keyTyped(bKeyEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.controller.mousePressed(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.controller.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.controller.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.controller.mouseExited(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.resetHover();
        this.controller.mouseMoved(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.controller.mouseDragged(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.controller.mousePulsed(bMouseEvent);
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        this.controller.mouseWheel(bMouseWheelEvent);
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
        this.controller.mouseHover(bMouseEvent);
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class TableSupport {
        BTable table;

        public final BTable getTable() {
            return this.table;
        }

        public TableModel getModel() {
            return this.table.model;
        }

        public TableController getController() {
            return this.table.controller;
        }

        public TableHeaderRenderer getHeaderRenderer() {
            return this.table.headerRenderer;
        }

        public TableCellRenderer getCellRenderer() {
            return this.table.cellRenderer;
        }

        public TableSelection getSelection() {
            return this.table.selection;
        }

        public BWidgetShell getShell() {
            return this.table.getShell();
        }

        public void setTable(BTable bTable) {
            this.table = bTable;
        }
    }

    class OptionsCommand
    extends Command {
        OptionsCommand(BTable bTable2) {
            super(bTable2, "Options");
            this.icon = BImage.make((String)"module://bajaui/com/tridium/ui/images/tableColumns.png");
        }

        public CommandArtifact doInvoke() {
            BTable.this.getController().doOptions();
            return null;
        }
    }
}

