/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.xml.XWriter;

public class PxEncoder
extends XWriter {
    private static final int NEVER = 0;
    private static final int ATTRIB = 1;
    private static final int SUBELEM = 2;
    private boolean preserveIdentities;

    public boolean getPreserveIdentities() {
        return this.preserveIdentities;
    }

    public PxEncoder setPreserveIdentities(boolean bl) {
        this.preserveIdentities = bl;
        return this;
    }

    public void encodeDocument(BWidget bWidget) throws IOException {
        this.encodeDocument(bWidget, null, null);
    }

    public void encodeDocument(BWidget bWidget, PxProperty[] pxPropertyArray, BAbstractPxView bAbstractPxView) throws IOException {
        this.encodeDocument(bWidget, pxPropertyArray, null, bAbstractPxView);
    }

    public void encodeDocument(BWidget bWidget, PxProperty[] pxPropertyArray, PxLayer[] pxLayerArray, BAbstractPxView bAbstractPxView) throws IOException {
        this.w("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.w("<!-- Niagara Presentation XML -->\n");
        this.w("<px version=\"1.0\"");
        if (bAbstractPxView != null) {
            this.w(" media=\"").w((Object)bAbstractPxView.getMedia()).w((Object)"\"");
        }
        this.w(">\n");
        this.encodeImport(bWidget);
        this.encodeProperties(bWidget, pxPropertyArray);
        this.encodeLayers(bWidget, pxLayerArray);
        this.encodeContent(bWidget);
        this.w("</px>\n");
        this.flush();
    }

    private final void encodeImport(BWidget bWidget) {
        HashMap hashMap = new HashMap();
        this.scanModules(hashMap, (BObject)bWidget);
        Object[] objectArray = hashMap.keySet().toArray(new String[hashMap.size()]);
        SortUtil.sort((Object[])objectArray);
        this.w("<import>\n");
        int n = 0;
        while (n < objectArray.length) {
            this.w("  <module name=\"").w(objectArray[n]).w((Object)"\"/>\n");
            ++n;
        }
        this.w("</import>\n");
    }

    private final void scanModules(HashMap hashMap, BObject bObject) {
        String string = bObject.getType().getModule().getModuleName();
        hashMap.put(string, "");
        if (bObject instanceof BComplex) {
            SlotCursor slotCursor = ((BComplex)bObject).getProperties();
            while (slotCursor.next()) {
                if (slotCursor.getTypeAccess() != 7 || Flags.isRemoveOnClone((BComplex)((BComplex)bObject), (Slot)slotCursor.property())) continue;
                this.scanModules(hashMap, slotCursor.get());
            }
        }
    }

    private final void encodeProperties(BWidget bWidget, PxProperty[] pxPropertyArray) throws IOException {
        if (pxPropertyArray == null) {
            return;
        }
        if (pxPropertyArray.length == 0) {
            return;
        }
        this.w("<properties>\n\n");
        int n = 0;
        while (n < pxPropertyArray.length) {
            PxProperty pxProperty = pxPropertyArray[n];
            this.w("  <property");
            this.w(" name=\"").w((Object)pxProperty.getName()).w((Object)"\"");
            this.w(" type=\"").w((Object)pxProperty.getTypeSpec().toString()).w((Object)"\"");
            this.w(" value=\"").w((Object)((BSimple)pxProperty.getValue()).encodeToString()).w((Object)"\"");
            this.w(">\n");
            SlotPath[] slotPathArray = pxProperty.getTargets();
            int n2 = 0;
            while (n2 < slotPathArray.length) {
                this.w("    <target");
                this.w(" ord=\"").w((Object)slotPathArray[n2]).w((Object)"\"");
                this.w("/>\n");
                ++n2;
            }
            this.w("  </property>\n\n");
            ++n;
        }
        this.w("</properties>\n");
    }

    private final void encodeLayers(BWidget bWidget, PxLayer[] pxLayerArray) throws IOException {
        if (pxLayerArray == null) {
            return;
        }
        if (pxLayerArray.length == 0) {
            return;
        }
        this.w("<layers>\n");
        int n = 0;
        while (n < pxLayerArray.length) {
            PxLayer pxLayer = pxLayerArray[n];
            this.w("  <layer");
            this.w(" name=\"").w((Object)pxLayer.getName()).w((Object)"\"");
            this.w(" status=\"").w((Object)pxLayer.getStatus().encodeToString()).w((Object)"\"");
            this.w("/>\n");
            ++n;
        }
        this.w("</layers>\n");
    }

    private final void encodeContent(BWidget bWidget) throws IOException {
        this.w("<content>\n");
        this.encodeToElem(null, (BValue)bWidget, 0);
        this.w("</content>\n");
    }

    private final void encodeToElem(Property property, BValue bValue, int n) throws IOException {
        String string = bValue.getType().getTypeName();
        this.indent(n).w((Object)"<").w((Object)string);
        if (property != null && (property.isFrozen() || !bValue.isComponent() || this.preserveIdentities)) {
            this.w(" name=\"").w((Object)property.getName()).w((Object)"\"");
        }
        if (this.preserveIdentities && bValue.isComponent() && bValue.asComponent().getHandle() != null) {
            this.w(" h=\"").w(bValue.asComponent().getHandle()).w((Object)"\"");
        }
        if (bValue.isSimple()) {
            BSimple bSimple = (BSimple)bValue;
            this.w(" value=\"").safe(bSimple.encodeToString()).w((Object)"\"/>\n");
        } else {
            boolean bl = this.encodeProps((BComplex)bValue, n + 2);
            if (bl) {
                this.w("/>\n");
            } else {
                this.indent(n).w((Object)"</").w((Object)string).w((Object)">\n");
            }
        }
    }

    private final boolean encodeProps(BComplex bComplex, int n) throws IOException {
        Property[] propertyArray = bComplex.getPropertiesArray();
        boolean bl = false;
        while (bl < propertyArray.length) {
            BValue bValue;
            Property property = propertyArray[bl];
            if (!Flags.isRemoveOnClone((BComplex)bComplex, (Slot)property) && this.encodeAs(bComplex, property, bValue = bComplex.get(property)) == 1) {
                this.w(' ').attr(property.getName(), bValue.asSimple().encodeToString());
            }
            bl += 1;
        }
        bl = true;
        boolean bl2 = bComplex instanceof BPane;
        int n2 = 0;
        while (n2 < propertyArray.length) {
            BValue bValue;
            Property property = propertyArray[n2];
            if (!Flags.isRemoveOnClone((BComplex)bComplex, (Slot)property) && this.encodeAs(bComplex, property, bValue = bComplex.get(property)) == 2) {
                if (bl) {
                    this.w(">\n");
                    if (bl2) {
                        this.w("\n");
                    }
                    bl = false;
                }
                this.encodeToElem(property, bValue, n);
                if (bl2) {
                    this.w("\n");
                }
            }
            ++n2;
        }
        return bl;
    }

    private final int encodeAs(BComplex bComplex, Property property, BValue bValue) {
        if (property.isFrozen()) {
            if (Flags.isTransient((BComplex)bComplex, (Slot)property)) {
                return 0;
            }
            if (property.isEquivalentToDefaultValue(bValue)) {
                return 0;
            }
            if (bComplex instanceof BWidget && ((BWidget)bComplex).isOverriddenByBinding(property)) {
                return 0;
            }
        } else if (bComplex instanceof BPxInclude) {
            BPxInclude bPxInclude = (BPxInclude)bComplex;
            if (bValue == bPxInclude.root) {
                return 0;
            }
            int n = 0;
            while (n < bPxInclude.props.length) {
                String string = bPxInclude.props[n].getName();
                BValue bValue2 = bPxInclude.props[n].getValue();
                if (property.getName().equals(string) && bValue.equals((Object)bValue2)) {
                    return 0;
                }
                ++n;
            }
        } else if (Flags.isTransient((BComplex)bComplex, (Slot)property)) {
            return 0;
        }
        int n = 0;
        if (property.isFrozen() && !property.getType().isAbstract() && bValue.isSimple()) {
            n = 1;
        }
        return 2 - n;
    }

    public PxEncoder(File file) throws IOException {
        super(file);
    }

    public PxEncoder(OutputStream outputStream) throws IOException {
        super(outputStream);
    }
}

