/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.px;

import com.tridium.sys.schema.ComponentSlotMap;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.TypeNotFoundException;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.BLayerStatus;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.util.BTypeSpec;
import javax.baja.xml.XElem;
import javax.baja.xml.XException;
import javax.baja.xml.XParser;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class PxDecoder
extends XParser {
    private String[] modules;
    private PxProperty[] props;
    private PxLayer[] layers;
    private HashMap types;
    private BOrd baseOrd;
    private TypeInfo media;
    private Context cx;

    public BWidget decodeDocument() throws Exception {
        return this.decodeDocument(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BWidget decodeDocument(boolean bl) throws Exception {
        BWidget bWidget;
        block7: {
            try {
                XElem xElem = this.parse();
                if (!xElem.name().equals("px")) {
                    throw this.err("Root element must be \"px\"", xElem);
                }
                String string = xElem.get("version");
                if (!string.equals("1.0")) {
                    throw this.err("Only version 1.0 is supported", xElem);
                }
                String string2 = xElem.get("media", null);
                if (string2 != null) {
                    try {
                        this.media = Sys.getRegistry().getType(string2);
                    }
                    catch (TypeNotFoundException typeNotFoundException) {
                        this.warning("Media not found: " + string2, xElem);
                    }
                }
                this.decodeImport(xElem);
                this.decodeLayers(xElem);
                BWidget bWidget2 = this.decodeContent(xElem);
                this.decodeProperties(xElem, bWidget2);
                bWidget = bWidget2;
                Object var3_8 = null;
                if (!bl) break block7;
            }
            catch (Throwable throwable) {
                block8: {
                    Object var3_9 = null;
                    if (!bl) break block8;
                    this.close();
                }
                throw throwable;
            }
            this.close();
        }
        return bWidget;
    }

    public TypeInfo getMedia() {
        return this.media;
    }

    private final void decodeImport(XElem xElem) throws Exception {
        XElem xElem2 = xElem.elem("import");
        if (xElem2 == null) {
            throw this.err("Missing <import> element", xElem);
        }
        XElem[] xElemArray = xElem2.elems("module");
        this.modules = new String[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            this.modules[n] = xElemArray[n].get("name");
            ++n;
        }
    }

    private final void decodeProperties(XElem xElem, BWidget bWidget) throws Exception {
        XElem xElem2 = xElem.elem("properties");
        if (xElem2 == null) {
            this.props = new PxProperty[0];
            return;
        }
        XElem[] xElemArray = xElem2.elems("property");
        this.props = new PxProperty[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("name");
            BTypeSpec bTypeSpec = BTypeSpec.make((String)xElemArray[n].get("type"));
            BSimple bSimple = this.decodeSimple((BValue)bTypeSpec.getResolvedType().getInstance(), xElemArray[n].get("value"));
            XElem[] xElemArray2 = xElemArray[n].elems("target");
            SlotPath[] slotPathArray = new SlotPath[xElemArray2.length];
            int n2 = 0;
            while (n2 < xElemArray2.length) {
                String string2 = xElemArray2[n2].get("ord");
                slotPathArray[n2] = new SlotPath(string2.substring("slot:".length()));
                ++n2;
            }
            this.props[n] = new PxProperty(string, bTypeSpec, (BValue)bSimple, slotPathArray);
            ++n;
        }
    }

    private final void decodeLayers(XElem xElem) throws Exception {
        XElem xElem2 = xElem.elem("layers");
        if (xElem2 == null) {
            this.layers = new PxLayer[0];
            return;
        }
        XElem[] xElemArray = xElem2.elems("layer");
        this.layers = new PxLayer[xElemArray.length];
        int n = 0;
        while (n < xElemArray.length) {
            String string = xElemArray[n].get("name");
            BLayerStatus bLayerStatus = BLayerStatus.make(xElemArray[n].get("status"));
            this.layers[n] = new PxLayer(string, bLayerStatus);
            ++n;
        }
    }

    private final BWidget decodeContent(XElem xElem) throws Exception {
        XElem xElem2 = xElem.elem("content");
        if (xElem2 == null) {
            throw this.err("Missing <content> element", xElem);
        }
        XElem[] xElemArray = xElem2.elems();
        if (xElemArray.length != 1) {
            throw this.err("There must be exactly one child element under <content>", xElem2);
        }
        XElem xElem3 = xElemArray[0];
        BValue bValue = this.decodeFromElem(xElem3);
        if (bValue == null || bValue instanceof BWidget) {
            return (BWidget)bValue;
        }
        throw this.err("Content type " + bValue.getType() + " is not a Widget", xElem3);
    }

    private final BValue decodeFromElem(XElem xElem) throws Exception {
        TypeInfo typeInfo = this.toType(xElem);
        BValue bValue = null;
        try {
            bValue = (BValue)typeInfo.getInstance();
            if (bValue instanceof BPxInclude) {
                bValue.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
            }
        }
        catch (Throwable throwable) {
            throw this.err("Cannot create instance of " + typeInfo, xElem, throwable);
        }
        if (bValue instanceof BSimple) {
            String string = xElem.get("value");
            bValue = this.decodeSimple(bValue, string);
        } else {
            this.decodeProps(xElem, (BComplex)bValue);
        }
        return bValue;
    }

    private final void decodeProps(XElem xElem, BComplex bComplex) throws Exception {
        Object object;
        Property property;
        String string = bComplex.getType().getTypeName();
        int n = 0;
        while (n < xElem.attrSize()) {
            String string2 = xElem.attrName(n);
            try {
                property = bComplex.getProperty(string2);
                if (property == null) {
                    if (string2.equals("h") && bComplex.isComponent()) {
                        ((ComponentSlotMap)bComplex.fw(1)).setHandle((Object)xElem.attrValue(n));
                    }
                } else {
                    object = bComplex.get(property);
                    if (!object.isSimple()) {
                        throw this.err("Expecting simple prop: " + string2, xElem);
                    }
                    object = this.decodeSimple((BValue)object, xElem.attrValue(n));
                    bComplex.set(property, object);
                }
            }
            catch (XException xException) {
                throw xException;
            }
            catch (Exception exception) {
                throw this.err("Cannot decode " + string + '.' + string2, xElem, exception);
            }
            ++n;
        }
        XElem[] xElemArray = xElem.elems();
        int n2 = 0;
        while (n2 < xElemArray.length) {
            property = xElemArray[n2];
            object = property.get("name", null);
            BValue bValue = this.decodeFromElem((XElem)property);
            try {
                if (object != null && bComplex.getProperty((String)object) != null) {
                    bComplex.set((String)object, bValue);
                } else {
                    bComplex.asComponent().add((String)object, bValue);
                }
            }
            catch (XException xException) {
                throw xException;
            }
            catch (Exception exception) {
                throw this.err("Cannot decode " + string + '.' + (String)object, (XElem)property, exception);
            }
            ++n2;
        }
    }

    private final TypeInfo toType(XElem xElem) {
        String string = xElem.name();
        TypeInfo typeInfo = (TypeInfo)this.types.get(string);
        if (typeInfo != null) {
            return typeInfo;
        }
        int n = 0;
        while (n < this.modules.length) {
            try {
                typeInfo = Sys.getRegistry().getType(this.modules[n] + ':' + string);
                this.types.put(string, typeInfo);
                return typeInfo;
            }
            catch (Exception exception) {
                ++n;
            }
        }
        throw this.err("Unknown type " + string, xElem);
    }

    private final BSimple decodeSimple(BValue bValue, String string) throws Exception {
        BSimple bSimple = (BSimple)((BSimple)bValue).decodeFromString(string);
        bSimple.fw(205, (Object)this.baseOrd, (Object)this.cx, null, null);
        return bSimple;
    }

    private final void loadBrush(BBrush bBrush) {
        BBrush.Paint paint = bBrush.getPaint();
        if (paint instanceof BBrush.Image) {
            BImage bImage = ((BBrush.Image)paint).getImage();
            bImage.setBaseOrd(this.baseOrd);
        }
    }

    XException err(String string, XElem xElem, Throwable throwable) {
        return new XException(string, xElem, throwable);
    }

    XException err(String string, XElem xElem) {
        return new XException(string, xElem);
    }

    void warning(String string, XElem xElem) {
        String string2 = "";
        if (xElem != null) {
            string2 = " [line " + xElem.line() + ']';
        }
        System.out.println("WARNING: " + string + string2);
    }

    public PxProperty[] getPxProperties() {
        return (PxProperty[])new Array((Object[])this.props).trim();
    }

    public PxLayer[] getPxLayers() {
        return (PxLayer[])new Array((Object[])this.layers).trim();
    }

    private final /* synthetic */ void this() {
        this.types = new HashMap();
    }

    public PxDecoder(BIFile bIFile) throws Exception {
        this(bIFile, null);
    }

    public PxDecoder(BIFile bIFile, Context context) throws Exception {
        this(bIFile.getAbsoluteOrd(), new BufferedInputStream(bIFile.getInputStream()), context);
    }

    public PxDecoder(BOrd bOrd, InputStream inputStream) throws Exception {
        this(bOrd, inputStream, null);
    }

    public PxDecoder(BOrd bOrd, InputStream inputStream, Context context) throws Exception {
        super(inputStream);
        this.this();
        this.baseOrd = bOrd;
        this.cx = context;
    }
}

