/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.TabbedPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BAlign;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BLabelPaneContainer;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BTabbedPane
extends BLabelPaneContainer {
    public static final Property tabPlacement = BTabbedPane.newProperty((int)0, (BValue)BAlign.top, null);
    public static final Property showSingleTab = BTabbedPane.newProperty((int)0, (boolean)true, null);
    public static final Property tabControl = BTabbedPane.newProperty((int)6, (BValue)new BNullWidget(), null);
    public static final Property paintFullBorder = BTabbedPane.newProperty((int)0, (boolean)true, null);
    public static final Topic selectionModified = BTabbedPane.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private static final String SELECTED_TAB_CLASS = "selected-tab";
    private static final String TAB_CLASS = "tab";
    private BLabelPane selection;
    private int fixedHeight;
    private int fixedWidth;
    private TabSupport support;
    static /* synthetic */ Class class$javax$baja$ui$pane$BTabbedPane;
    static /* synthetic */ Class class$javax$baja$ui$pane$BLabelPane;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public BAlign getTabPlacement() {
        return (BAlign)this.get(tabPlacement);
    }

    public void setTabPlacement(BAlign bAlign) {
        this.set(tabPlacement, (BValue)bAlign, null);
    }

    public boolean getShowSingleTab() {
        return this.getBoolean(showSingleTab);
    }

    public void setShowSingleTab(boolean bl) {
        this.setBoolean(showSingleTab, bl, null);
    }

    public BWidget getTabControl() {
        return (BWidget)this.get(tabControl);
    }

    public void setTabControl(BWidget bWidget) {
        this.set(tabControl, (BValue)bWidget, null);
    }

    public boolean getPaintFullBorder() {
        return this.getBoolean(paintFullBorder);
    }

    public void setPaintFullBorder(boolean bl) {
        this.setBoolean(paintFullBorder, bl, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    private final BLabelPane[] getLabelPanes() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        Class clazz = class$javax$baja$ui$pane$BLabelPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BLabelPane = BTabbedPane.class("[Ljavax.baja.ui.pane.BLabelPane;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bWidgetArray.length) {
            if (bWidgetArray[n] instanceof BLabelPane && ((BLabelPane)bWidgetArray[n]).getVisible()) {
                array.add((Object)((BLabelPane)bWidgetArray[n]));
            }
            ++n;
        }
        return (BLabelPane[])array.trim();
    }

    public BLabelPane getSelectedLabelPane() {
        if (this.selection == null) {
            return null;
        }
        if (!this.selection.isVisible()) {
            BLabelPane[] bLabelPaneArray = this.getLabelPanes();
            if (bLabelPaneArray.length > 0) {
                return bLabelPaneArray[0];
            }
            return null;
        }
        return this.selection;
    }

    public BWidget getSelectedPane() {
        if (this.selection == null) {
            return null;
        }
        return this.selection.getContent();
    }

    public void selectLabelPane(BLabelPane bLabelPane) {
        this.setSelected(bLabelPane);
    }

    public void selectPane(BWidget bWidget) {
        this.setSelected((BLabelPane)bWidget.getParent());
    }

    public void setTabSupport(TabSupport tabSupport) {
        this.support = tabSupport;
    }

    public TabSupport getTabSupport() {
        return this.support;
    }

    public void setEnabledLabelPane(BLabelPane bLabelPane, boolean bl) {
        if (bLabelPane == null) {
            return;
        }
        bLabelPane.setEnabled(bl);
    }

    public void computePreferredSize() {
        BWidget bWidget;
        BLabelPane bLabelPane;
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        if (bLabelPaneArray.length == 1) {
            this.setPreferredSize(200.0, 200.0);
            return;
        }
        if (bLabelPaneArray.length == 2 && !this.getShowSingleTab()) {
            BWidget bWidget2 = bLabelPaneArray[1].getContent();
            bWidget2.computePreferredSize();
            this.setPreferredSize(bWidget2.getPreferredWidth(), bWidget2.getPreferredHeight());
            return;
        }
        double d = 0.0;
        double d2 = 0.0;
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n = 1;
        while (n < bWidgetArray.length) {
            bLabelPane = (BLabelPane)bWidgetArray[n];
            bWidget = bLabelPane.getContent();
            bWidget.computePreferredSize();
            d = Math.max(d, bWidget.getPreferredWidth());
            d2 = Math.max(d2, bWidget.getPreferredHeight());
            ++n;
        }
        BAlign bAlign = this.tabPlacement();
        bLabelPane = Theme.tabbedPane().getTabInsets(bAlign);
        bWidget = Theme.tabbedPane().getContentInsets(bAlign, this.getPaintFullBorder());
        double d3 = 0.0;
        double d4 = 0.0;
        if (bLabelPaneArray.length > 0) {
            BLabel bLabel = bLabelPaneArray[1].getLabel();
            bLabel.computePreferredSize();
            d3 = bLabel.getPreferredWidth();
            d4 = bLabel.getPreferredHeight();
        }
        if (bAlign == BAlign.top || bAlign == BAlign.bottom) {
            d2 += ((BInsets)bLabelPane).top + d4 + ((BInsets)bLabelPane).bottom;
        } else {
            d += ((BInsets)bLabelPane).left + d3 + ((BInsets)bLabelPane).right;
        }
        this.setPreferredSize(d += ((BInsets)bWidget).left + ((BInsets)bWidget).right, d2 += ((BInsets)bWidget).top + ((BInsets)bWidget).bottom);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        Class clazz = class$javax$baja$ui$BWidget;
        if (clazz == null) {
            clazz = class$javax$baja$ui$BWidget = BTabbedPane.class("[Ljavax.baja.ui.BWidget;", false);
        }
        Array array = new Array(clazz);
        int n = 0;
        while (n < bWidgetArray.length) {
            if (bWidgetArray[n].getVisible() || !bWidgetArray[n].getType().is(BLabelPane.TYPE)) {
                array.add((Object)bWidgetArray[n]);
            }
            ++n;
        }
        BWidget[] bWidgetArray2 = (BWidget[])array.trim();
        BWidget bWidget = this.getTabControl();
        if (this.selection == null) {
            if (bWidgetArray2.length == 1) {
                return;
            }
            this.setSelection((BLabelPane)bWidgetArray2[1]);
        }
        if (bWidgetArray2.length == 2 && !this.getShowSingleTab()) {
            bWidgetArray2[1].setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            BWidget bWidget2 = ((BLabelPane)bWidgetArray2[1]).getLabel();
            bWidget2.setVisible(false);
            bWidget2.setBounds(0.0, 0.0, 0.0, 0.0);
            bWidget2 = ((BLabelPane)bWidgetArray2[1]).getContent();
            bWidget2.setVisible(true);
            bWidget2.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            bWidget.setBounds(0.0, 0.0, 0.0, 0.0);
            bWidget.setVisible(false);
            return;
        }
        BAlign bAlign = this.tabPlacement();
        BInsets bInsets = Theme.tabbedPane().getTabInsets(bAlign);
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        double d4 = 0.0;
        double d5 = 0.0;
        this.fixedWidth = 0;
        this.fixedHeight = 0;
        double d6 = 0.0;
        double d7 = 0.0;
        if (bWidget instanceof BNullWidget) {
            bWidget.setBounds(0.0, 0.0, 0.0, 0.0);
            bWidget.setVisible(false);
        } else {
            bWidget.computePreferredSize();
            d6 = bWidget.getPreferredWidth();
            d7 = bWidget.getPreferredHeight();
            double d8 = 0.0;
            double d9 = 0.0;
            switch (bAlign.getOrdinal()) {
                case 0: {
                    d8 = d2 - d6;
                    break;
                }
                case 2: {
                    d8 = d2 - d6;
                    d9 = d3 - d7;
                    break;
                }
                case 1: {
                    d9 = d3 - d7;
                    break;
                }
                case 3: {
                    d8 = d2 - d6;
                    d9 = d3 - d7;
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            bWidget.setBounds(d8, d9, d6, d7);
            bWidget.setVisible(true);
            if (bAlign == BAlign.top || bAlign == BAlign.bottom) {
                this.fixedHeight = (int)d7;
            } else {
                this.fixedWidth = (int)d6;
            }
        }
        int n2 = 1;
        while (n2 < bWidgetArray2.length) {
            BLabelPane bLabelPane = (BLabelPane)bWidgetArray2[n2];
            bLabelPane.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
            BWidget bWidget3 = bLabelPane.getContent();
            bWidget3.setBounds(0.0, 0.0, 0.0, 0.0);
            bWidget3.setVisible(this.selection.getContent().equals(bWidget3));
            BLabel bLabel = bLabelPane.getLabel();
            bLabel.setVisible(true);
            bLabel.computePreferredSize();
            d = bLabel.getPreferredWidth();
            double d10 = bLabel.getPreferredHeight();
            double d11 = d + bInsets.left + bInsets.right;
            double d12 = d10 + bInsets.top + bInsets.bottom;
            if (bAlign == BAlign.top || bAlign == BAlign.bottom) {
                if (d4 + d11 > d2 - d6) {
                    d5 += 1.0;
                    d4 = 0.0;
                }
                bLabel.setBounds(d4 + bInsets.left, d5, d, d10);
                d4 += d11;
                this.fixedHeight = (int)Math.max((double)this.fixedHeight, d12);
            } else {
                if (d5 + d12 > d3 - d7) {
                    d4 += 1.0;
                    d5 = 0.0;
                }
                bLabel.setBounds(d4, d5 + bInsets.top, d, d10);
                d5 += d12;
                this.fixedWidth = (int)Math.max((double)this.fixedWidth, d11);
            }
            ++n2;
        }
        n2 = (int)d5 + 1;
        int n3 = (int)d4 + 1;
        double d13 = n2 * this.fixedHeight;
        d = n3 * this.fixedWidth;
        BInsets bInsets2 = Theme.tabbedPane().getContentInsets(bAlign, this.getPaintFullBorder());
        switch (bAlign.getOrdinal()) {
            case 0: 
            case 2: {
                this.layoutRows(bWidgetArray2, n2);
                break;
            }
            case 1: 
            case 3: {
                this.layoutColumns(bWidgetArray2, n3);
                break;
            }
        }
        int n4 = 1;
        while (n4 < bWidgetArray2.length) {
            BLabelPane bLabelPane = (BLabelPane)bWidgetArray2[n4];
            BWidget bWidget4 = bLabelPane.getContent();
            switch (bAlign.getOrdinal()) {
                case 0: {
                    bWidget4.setBounds(bInsets2.left, d13 + bInsets2.top, d2 - bInsets2.left - bInsets2.right, d3 - d13 - bInsets2.top - bInsets2.bottom);
                    break;
                }
                case 2: {
                    bWidget4.setBounds(bInsets2.left, bInsets2.top, d2 - bInsets2.left - bInsets2.right, d3 - d13 - bInsets2.top - bInsets2.bottom);
                    break;
                }
                case 1: {
                    bWidget4.setBounds(bInsets2.left + d, bInsets2.top, d2 - bInsets2.left - bInsets2.right - d, d3 - bInsets2.top - bInsets2.bottom);
                    break;
                }
                case 3: {
                    bWidget4.setBounds(bInsets2.left, bInsets2.top, d2 - bInsets2.left - bInsets2.right - d, d3 - bInsets2.top - bInsets2.bottom);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            bLabelPane.setBounds(0.0, 0.0, bWidget4.getWidth(), bWidget4.getHeight());
            ++n4;
        }
    }

    private final void layoutRows(BWidget[] bWidgetArray, int n) {
        BInsets bInsets = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 1;
        while (n2 < bWidgetArray.length) {
            BLabel bLabel = ((BLabelPane)bWidgetArray[n2]).getLabel();
            int n3 = (int)bLabel.getY();
            nArray[n3] = nArray[n3] + 1;
            int n4 = (int)bLabel.getY();
            nArray2[n4] = (int)((double)nArray2[n4] + (bLabel.getWidth() + bInsets.left + bInsets.right));
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            int n5 = nArray[n2];
            nArray3[n2] = n5 == 0 ? 0 : ((int)this.getWidth() - nArray2[n2]) / n5;
            ++n2;
        }
        n2 = 0;
        int n6 = 0;
        int n7 = this.rowY(n, n2);
        int n8 = 1;
        while (n8 < bWidgetArray.length) {
            int n9;
            BLabel bLabel = ((BLabelPane)bWidgetArray[n8]).getLabel();
            if ((double)n2 != bLabel.getY()) {
                if (n8 > 1) {
                    BLabel bLabel2 = ((BLabelPane)bWidgetArray[n8 - 1]).getLabel();
                    n9 = ((int)this.getWidth() - nArray2[n2]) % nArray[n2];
                    bLabel2.setSize(bLabel2.getWidth() + (double)n9, bLabel2.getHeight());
                }
                n6 = 0;
                n7 = this.rowY(n, ++n2);
            }
            int n10 = n6 + (int)bInsets.left;
            n9 = n7 + (int)bInsets.top;
            int n11 = (int)bLabel.getWidth() + nArray3[n2];
            int n12 = this.fixedHeight - (int)bInsets.top - (int)bInsets.bottom;
            bLabel.setBounds(n10, n9, n11, n12);
            n6 = n10 + n11 + (int)bInsets.right;
            ++n8;
        }
    }

    private final int rowY(int n, int n2) {
        if (this.tabPlacement() == BAlign.top) {
            return (n - n2 - 1) * this.fixedHeight;
        }
        return (int)this.getHeight() - (n - n2) * this.fixedHeight;
    }

    private final void layoutColumns(BWidget[] bWidgetArray, int n) {
        BInsets bInsets = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        int[] nArray3 = new int[n];
        int n2 = 1;
        while (n2 < bWidgetArray.length) {
            BLabel bLabel = ((BLabelPane)bWidgetArray[n2]).getLabel();
            int n3 = (int)bLabel.getX();
            nArray[n3] = nArray[n3] + 1;
            int n4 = (int)bLabel.getX();
            nArray2[n4] = (int)((double)nArray2[n4] + ((double)((int)bLabel.getHeight()) + bInsets.top + bInsets.bottom));
            ++n2;
        }
        n2 = 0;
        while (n2 < n - 1) {
            nArray3[n2] = nArray[n2] == 0 ? 0 : ((int)this.getHeight() - nArray2[n2]) / nArray[n2];
            ++n2;
        }
        n2 = 0;
        int n5 = this.colX(n, n2);
        int n6 = 0;
        int n7 = 1;
        while (n7 < bWidgetArray.length) {
            int n8;
            BLabel bLabel = ((BLabelPane)bWidgetArray[n7]).getLabel();
            if ((double)n2 != bLabel.getX()) {
                if (n7 > 1) {
                    BLabel bLabel2 = ((BLabelPane)bWidgetArray[n7 - 1]).getLabel();
                    n8 = ((int)this.getHeight() - nArray2[n2]) % nArray[n2];
                    bLabel2.setSize((int)bLabel2.getWidth(), (int)bLabel2.getHeight() + n8);
                }
                n5 = this.colX(n, ++n2);
                n6 = 0;
            }
            int n9 = n5 + (int)bInsets.left;
            n8 = n6 + (int)bInsets.top;
            int n10 = this.fixedWidth - (int)bInsets.left - (int)bInsets.right;
            int n11 = (int)bLabel.getHeight() + nArray3[n2];
            bLabel.setBounds(n9, n8, n10, n11);
            n6 = n8 + n11 + (int)bInsets.top;
            ++n7;
        }
    }

    private final int colX(int n, int n2) {
        if (this.tabPlacement() == BAlign.left) {
            return (n - n2 - 1) * this.fixedWidth;
        }
        return (int)this.getWidth() - (n - n2) * this.fixedWidth;
    }

    private final void resetSelection() {
        int n = -1;
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n2 = 0;
        while (n2 < bWidgetArray.length) {
            if (this.selection == bWidgetArray[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            n2 = n + 1;
            int n3 = 0;
            while (n3 < bWidgetArray.length) {
                BWidget bWidget = bWidgetArray[(n2 + n3) % bWidgetArray.length];
                if (bWidget instanceof BLabelPane && ((BLabelPane)bWidget).isVisible()) {
                    this.setSelected((BLabelPane)bWidget);
                    break;
                }
                ++n3;
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.selection == null) {
            return;
        }
        TabbedPaneTheme tabbedPaneTheme = Theme.tabbedPane();
        BAlign bAlign = this.tabPlacement();
        boolean bl = this.getPaintFullBorder();
        tabbedPaneTheme.paintContentBackground(graphics, this, bAlign, this.selection.getContent(), bl);
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        int n = bLabelPaneArray.length - 1;
        while (n >= 0) {
            if (bLabelPaneArray[n] instanceof BLabelPane) {
                BLabelPane bLabelPane = bLabelPaneArray[n];
                BLabel bLabel = bLabelPane.getLabel();
                boolean bl2 = false;
                if (this.selection == bLabelPane) {
                    bl2 = true;
                }
                boolean bl3 = bl2;
                tabbedPaneTheme.paintTabBackground(graphics, this, bAlign, bLabel, bl3, this.selection.getContent(), bl);
                this.paintChild(graphics, bLabel);
            }
            --n;
        }
        this.paintChild(graphics, this.getTabControl());
        if (!this.selection.isVisible()) {
            this.resetSelection();
        }
        if (this.getLabelPanes().length > 0) {
            this.paintChild(graphics, this.selection.getContent());
        } else {
            this.paintChild(graphics, new BLabelPane());
        }
    }

    public String getStyleSelector() {
        return "pane tabbed-pane";
    }

    public BWidget childAt(Point point) {
        BWidget bWidget;
        if (this.selection != null && (bWidget = this.selection.getContent()).contains(point.x - bWidget.getX(), point.y - bWidget.getY())) {
            return bWidget;
        }
        bWidget = this.getTabControl();
        if (bWidget.contains(point.x - bWidget.getX(), point.y - bWidget.getY())) {
            return bWidget;
        }
        return null;
    }

    public void added(Property property, Context context) {
        super.added(property, context);
        BValue bValue = this.get(property);
        if (bValue instanceof BLabelPane) {
            BLabelPane bLabelPane = (BLabelPane)bValue;
            if (this.selection == null && bLabelPane.getEnabled() && bLabelPane.isVisible()) {
                this.setSelection(bLabelPane);
            } else {
                boolean bl = false;
                if (bLabelPane == this.selection) {
                    bl = true;
                }
                this.updateTabFromTheme(bLabelPane, bl);
            }
        }
    }

    private final void setSelected(BLabelPane bLabelPane) {
        if (this.selection == bLabelPane) {
            return;
        }
        this.setSelection(bLabelPane);
        this.relayout();
        if (!this.hasFocus()) {
            BWidget bWidget = this.selection.getContent();
            this.giveFocus(bWidget);
        }
        this.fireSelectionModified(new BWidgetEvent(1, this));
        this.selectionModified(bLabelPane);
    }

    private final void setSelection(BLabelPane bLabelPane) {
        this.updateTabFromTheme(this.selection, false);
        this.updateTabFromTheme(bLabelPane, true);
        this.selection = bLabelPane;
    }

    private final void updateTabFromTheme(BLabelPane bLabelPane, boolean bl) {
        if (bLabelPane == null) {
            return;
        }
        BLabel bLabel = bLabelPane.getLabel();
        bLabel.setFlags((Slot)BWidget.styleClasses, bLabel.getFlags((Slot)BWidget.styleClasses) | 2);
        if (bl) {
            bLabel.setStyleClasses(SELECTED_TAB_CLASS);
        } else {
            bLabel.setStyleClasses(TAB_CLASS);
        }
    }

    protected void selectionModified(BLabelPane bLabelPane) {
        if (!bLabelPane.isVisible()) {
            BLabelPane[] bLabelPaneArray = this.getLabelPanes();
            int n = 0;
            while (n < bLabelPaneArray.length) {
                BLabelPane bLabelPane2;
                if (bLabelPaneArray[n] instanceof BLabelPane && (bLabelPane2 = bLabelPaneArray[n]).isVisible()) {
                    this.setSelection(bLabelPane2);
                    return;
                }
                ++n;
            }
        }
    }

    private final boolean giveFocus(BWidget bWidget) {
        if (bWidget.isFocusTraversable()) {
            bWidget.requestFocus();
            return true;
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        int n = 1;
        while (n < bWidgetArray.length) {
            if (this.giveFocus(bWidgetArray[n])) {
                return true;
            }
            ++n;
        }
        return false;
    }

    protected BLabelPane tabAt(double d, double d2) {
        RectGeom rectGeom = new RectGeom();
        BInsets bInsets = Theme.tabbedPane().getTabInsets(this.tabPlacement());
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        int n = 0;
        while (n < bLabelPaneArray.length) {
            BLabel bLabel = bLabelPaneArray[n].getLabel();
            rectGeom.x = bLabel.getX() - bInsets.left;
            rectGeom.y = bLabel.getY() - bInsets.top;
            rectGeom.width = bLabel.getWidth() + bInsets.left + bInsets.right;
            rectGeom.height = bLabel.getHeight() + bInsets.top + bInsets.bottom;
            if (rectGeom.contains(d, d2)) {
                return bLabelPaneArray[n];
            }
            ++n;
        }
        return null;
    }

    private final void traverseLeft() {
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        int n = -1;
        int n2 = 0;
        while (n2 < bLabelPaneArray.length) {
            if (this.selection == bLabelPaneArray[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        n2 = n - 1;
        if (n2 < 0) {
            n2 = bLabelPaneArray.length - 1;
        }
        int n3 = 1;
        while (n3 < bLabelPaneArray.length) {
            if (bLabelPaneArray[n2].getEnabled()) {
                this.selectLabelPane(bLabelPaneArray[n2]);
                return;
            }
            if (--n2 < 0) {
                n2 = bLabelPaneArray.length - 1;
            }
            ++n3;
        }
    }

    private final void traverseRight() {
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        int n = -1;
        int n2 = 0;
        while (n2 < bLabelPaneArray.length) {
            if (this.selection == bLabelPaneArray[n2]) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n == -1) {
            return;
        }
        n2 = n + 1;
        if (n2 == bLabelPaneArray.length) {
            n2 = 0;
        }
        int n3 = 1;
        while (n3 < bLabelPaneArray.length) {
            if (bLabelPaneArray[n2].getEnabled()) {
                this.selectLabelPane(bLabelPaneArray[n2]);
                return;
            }
            n2 = n2 == bLabelPaneArray.length - 1 ? 0 : ++n2;
            ++n3;
        }
    }

    public boolean isAnyTabEnabled() {
        BLabelPane[] bLabelPaneArray = this.getLabelPanes();
        int n = 0;
        while (n < bLabelPaneArray.length) {
            if (bLabelPaneArray[n].getEnabled()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        if (bKeyEvent.getKeyCode() == 37) {
            bKeyEvent.consume();
            this.traverseLeft();
        } else if (bKeyEvent.getKeyCode() == 39) {
            bKeyEvent.consume();
            this.traverseRight();
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        BLabelPane bLabelPane = this.tabAt(bMouseEvent.getX(), bMouseEvent.getY());
        if (bLabelPane != null) {
            if (!bLabelPane.getEnabled()) {
                return;
            }
            if (bMouseEvent.isPopupTrigger()) {
                this.support.tabPopup(bLabelPane, bMouseEvent);
            } else if (bMouseEvent.isButton1Down()) {
                this.setSelected(bLabelPane);
            }
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        BLabelPane bLabelPane = this.tabAt(bMouseEvent.getX(), bMouseEvent.getY());
        if (bLabelPane != null) {
            if (!bLabelPane.getEnabled()) {
                return;
            }
            if (bMouseEvent.isPopupTrigger()) {
                this.support.tabPopup(bLabelPane, bMouseEvent);
            }
        }
    }

    private final BAlign tabPlacement() {
        BAlign bAlign = this.getTabPlacement();
        if (bAlign == BAlign.center) {
            bAlign = BAlign.top;
        }
        return bAlign;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.support = new TabSupport();
    }

    public BTabbedPane(BAlign bAlign) {
        this.this();
        this.setTabPlacement(bAlign);
    }

    public BTabbedPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BTabbedPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BTabbedPane = BTabbedPane.class("[Ljavax.baja.ui.pane.BTabbedPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/tabbedPane.png");
    }

    public static class TabSupport {
        public void tabPopup(BLabelPane bLabelPane, BMouseEvent bMouseEvent) {
        }
    }
}

