/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.SplitPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BSplitPane
extends BPane {
    public static final Property widget1 = BSplitPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property widget2 = BSplitPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property dividerWidth = BSplitPane.newProperty((int)0, (int)6, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property moveableDivider = BSplitPane.newProperty((int)0, (boolean)true, null);
    public static final Property dividerPosition = BSplitPane.newProperty((int)0, (int)50, (BFacets)BFacets.make((String)"min", (BIDataValue)BDouble.make((double)0.0)));
    public static final Property orientation = BSplitPane.newProperty((int)0, (BValue)BOrientation.horizontal, null);
    public static final Property continuousLayout = BSplitPane.newProperty((int)0, (boolean)true, null);
    public static final Topic dividerMoved = BSplitPane.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    private BBrush shadowDivBrush;
    private RectGeom origDivRect;
    private RectGeom divRect;
    private boolean visibleDivider;
    private boolean inDrag;
    private double dragOffset;
    static /* synthetic */ Class class$javax$baja$ui$pane$BSplitPane;

    public BWidget getWidget1() {
        return (BWidget)this.get(widget1);
    }

    public void setWidget1(BWidget bWidget) {
        this.set(widget1, (BValue)bWidget, null);
    }

    public BWidget getWidget2() {
        return (BWidget)this.get(widget2);
    }

    public void setWidget2(BWidget bWidget) {
        this.set(widget2, (BValue)bWidget, null);
    }

    public double getDividerWidth() {
        return this.getDouble(dividerWidth);
    }

    public void setDividerWidth(double d) {
        this.setDouble(dividerWidth, d, null);
    }

    public boolean getMoveableDivider() {
        return this.getBoolean(moveableDivider);
    }

    public void setMoveableDivider(boolean bl) {
        this.setBoolean(moveableDivider, bl, null);
    }

    public double getDividerPosition() {
        return this.getDouble(dividerPosition);
    }

    public void setDividerPosition(double d) {
        this.setDouble(dividerPosition, d, null);
    }

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation bOrientation) {
        this.set(orientation, (BValue)bOrientation, null);
    }

    public boolean getContinuousLayout() {
        return this.getBoolean(continuousLayout);
    }

    public void setContinuousLayout(boolean bl) {
        this.setBoolean(continuousLayout, bl, null);
    }

    public void fireDividerMoved(BWidgetEvent bWidgetEvent) {
        this.fire(dividerMoved, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public double getAbsoluteDividerLocation() {
        double d = this.getDividerPosition();
        if (this.getOrientation() == BOrientation.horizontal) {
            double d2 = this.getWidth() - this.getDividerWidth();
            return d2 * (d / 100.0);
        }
        double d3 = this.getHeight() - this.getDividerWidth();
        return d3 * (d / 100.0);
    }

    public void setAbsoluteDividerLocation(double d) {
        if (this.getOrientation() == BOrientation.horizontal) {
            double d2 = this.getWidth() - this.getDividerWidth();
            d = Math.max(d, 0.0);
            d = Math.min(d, d2);
            this.setDividerPosition(d / d2 * 100.0);
        } else {
            double d3 = this.getHeight() - this.getDividerWidth();
            d = Math.max(d, 0.0);
            d = Math.min(d, d3);
            this.setDividerPosition(d / d3 * 100.0);
        }
    }

    public void childCalledRelayout(BWidget bWidget) {
    }

    public void computePreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        BWidget bWidget = this.getWidget1();
        BWidget bWidget2 = this.getWidget2();
        int n = 0;
        if (bWidget.isVisible()) {
            ++n;
        }
        if (bWidget2.isVisible()) {
            ++n;
        }
        if (bWidget.isVisible()) {
            bWidget.computePreferredSize();
        }
        if (bWidget2.isVisible()) {
            bWidget2.computePreferredSize();
        }
        if (this.getOrientation() == BOrientation.vertical) {
            double d3 = d2 = n == 2 ? this.getDividerWidth() : 0.0;
            if (bWidget.isVisible()) {
                d2 += bWidget.getPreferredHeight();
                d = bWidget.getPreferredWidth();
            }
            if (bWidget2.isVisible()) {
                d2 += bWidget2.getPreferredHeight();
                d = Math.max(d, bWidget2.getPreferredWidth());
            }
        } else if (this.getOrientation() == BOrientation.horizontal) {
            d2 = n == 2 ? this.getDividerWidth() : 0.0;
            d = d2;
            if (bWidget.isVisible()) {
                d += bWidget.getPreferredWidth();
                d2 = bWidget.getPreferredHeight();
            }
            if (bWidget2.isVisible()) {
                d += bWidget2.getPreferredWidth();
                d2 = Math.max(d2, bWidget2.getPreferredHeight());
            }
        }
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.getWidth() == 0.0 || this.getHeight() == 0.0) {
            return;
        }
        if (this.getOrientation() == BOrientation.horizontal) {
            this.layoutHorizontal();
        } else if (this.getOrientation() == BOrientation.vertical) {
            this.layoutVertical();
        }
    }

    private final void layoutHorizontal() {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        BWidget bWidget = this.getWidget1();
        BWidget bWidget2 = this.getWidget2();
        this.divRect = new RectGeom(0.0, 0.0, this.getDividerWidth(), d3);
        boolean bl = false;
        if (this.getDividerWidth() > 0.0) {
            bl = this.visibleDivider = true;
        }
        if (!bWidget.isVisible()) {
            bWidget.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (bWidget2.isVisible()) {
                bWidget2.setBounds(0.0, 0.0, (int)d2, (int)d3);
            }
            return;
        }
        if (!bWidget2.isVisible()) {
            bWidget2.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (bWidget.isVisible()) {
                bWidget.setBounds(0.0, 0.0, (int)d2, (int)d3);
            }
            return;
        }
        double d4 = this.getDividerPosition();
        if (d4 > 100.0) {
            d4 = 50.0;
        }
        this.divRect.x = d = (d2 - this.divRect.width) * (d4 / 100.0);
        bWidget.setBounds(0.0, 0.0, (int)this.divRect.x, (int)d3);
        double d5 = d2 - this.divRect.x - this.divRect.width;
        bWidget2.setBounds((int)(this.divRect.x + this.divRect.width), 0.0, (int)d5, (int)d3);
    }

    private final void layoutVertical() {
        double d;
        double d2 = this.getWidth();
        double d3 = this.getHeight();
        BWidget bWidget = this.getWidget1();
        BWidget bWidget2 = this.getWidget2();
        this.divRect = new RectGeom(0.0, 0.0, d2, this.getDividerWidth());
        boolean bl = false;
        if (this.getDividerWidth() > 0.0) {
            bl = this.visibleDivider = true;
        }
        if (!bWidget.isVisible()) {
            bWidget.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (bWidget2.isVisible()) {
                bWidget2.setBounds(0.0, 0.0, (int)d2, (int)d3);
            }
            return;
        }
        if (!bWidget2.isVisible()) {
            bWidget2.setBounds(0.0, 0.0, 0.0, 0.0);
            this.visibleDivider = false;
            if (bWidget.isVisible()) {
                bWidget.setBounds(0.0, 0.0, (int)d2, (int)d3);
            }
            return;
        }
        double d4 = this.getDividerPosition();
        this.divRect.y = d = (d3 - this.divRect.height) * (d4 / 100.0);
        bWidget.setBounds(0.0, 0.0, (int)d2, (int)this.divRect.y);
        double d5 = d3 - this.divRect.y - this.divRect.height;
        bWidget2.setBounds(0.0, (int)(this.divRect.y + this.divRect.height), (int)d2, (int)d5);
    }

    private final boolean inDivider(double d, double d2) {
        if (this.visibleDivider) {
            return this.divRect.contains(d, d2);
        }
        return false;
    }

    public void paint(Graphics graphics) {
        SplitPaneTheme splitPaneTheme = Theme.splitPane();
        double d = this.getWidth();
        double d2 = this.getHeight();
        BWidget bWidget = this.getWidget1();
        BWidget bWidget2 = this.getWidget2();
        if (bWidget.isNull()) {
            graphics.setBrush(splitPaneTheme.getWindowBackground());
            if (this.getOrientation() == BOrientation.horizontal) {
                graphics.fillRect(0.0, 0.0, this.divRect.x, d2);
            } else {
                graphics.fillRect(0.0, 0.0, d, this.divRect.y);
            }
            this.paintChild(graphics, bWidget);
        } else if (bWidget.isVisible()) {
            this.paintChild(graphics, bWidget);
        }
        if (bWidget2.isNull()) {
            graphics.setBrush(splitPaneTheme.getWindowBackground());
            if (this.getOrientation() == BOrientation.horizontal) {
                graphics.fillRect(this.divRect.x + this.divRect.width, 0.0, d - this.divRect.x - this.divRect.width, d2);
            } else {
                graphics.fillRect(0.0, this.divRect.y + this.divRect.height, d, d2 - this.divRect.y - this.divRect.height);
            }
            this.paintChild(graphics, bWidget2);
        } else if (bWidget2.isVisible()) {
            this.paintChild(graphics, bWidget2);
        }
        if (this.visibleDivider) {
            boolean bl;
            boolean bl2 = false;
            if (!this.getContinuousLayout() && this.inDrag) {
                bl2 = true;
            }
            if (bl = bl2) {
                splitPaneTheme.paintDivider(graphics, this, this.origDivRect, bl, this.getMoveableDivider());
                graphics.setBrush(this.shadowDivBrush);
                graphics.fill((IGeom)this.divRect);
            } else {
                splitPaneTheme.paintDivider(graphics, this, this.divRect, bl, this.getMoveableDivider());
            }
        }
    }

    public BWidget childAt(Point point) {
        if (this.inDrag) {
            return null;
        }
        return super.childAt(point);
    }

    public String getStyleSelector() {
        return "pane split-pane";
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        MouseCursor mouseCursor = this.checkCursor(bMouseEvent.getX(), bMouseEvent.getY());
        if (mouseCursor != null) {
            this.setMouseCursor(mouseCursor);
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        if (!this.inDrag) {
            this.resetCursor();
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (!this.inDivider(bMouseEvent.getX(), bMouseEvent.getY())) {
            return;
        }
        if (!this.getMoveableDivider()) {
            return;
        }
        if (!this.getContinuousLayout()) {
            this.origDivRect = new RectGeom((IRectGeom)this.divRect);
        }
        this.dragOffset = this.getOrientation() == BOrientation.horizontal ? bMouseEvent.getX() - this.divRect.x : bMouseEvent.getY() - this.divRect.y;
        this.inDrag = true;
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.dragOffset = 0.0;
        this.inDrag = false;
        if (!this.getContinuousLayout()) {
            this.origDivRect = null;
            this.relayout();
        }
        this.fireDividerMoved(new BWidgetEvent(1, this));
        MouseCursor mouseCursor = this.checkCursor(bMouseEvent.getX(), bMouseEvent.getY());
        if (mouseCursor != null) {
            this.setMouseCursor(mouseCursor);
        }
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        MouseCursor mouseCursor = this.checkCursor(bMouseEvent.getX(), bMouseEvent.getY());
        if (mouseCursor != null) {
            this.setMouseCursor(mouseCursor);
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d;
        if (!this.inDrag) {
            return;
        }
        if (this.getOrientation() == BOrientation.horizontal) {
            d = Math.max(0.0, bMouseEvent.getX() - this.dragOffset);
            this.divRect.x = d = Math.min(d, this.getWidth() - this.divRect.width);
        } else {
            d = Math.max(0.0, bMouseEvent.getY() - this.dragOffset);
            this.divRect.y = d = Math.min(d, this.getHeight() - this.divRect.height);
        }
        this.setDividerPosition(this.fromAbsolute(d));
        if (this.getContinuousLayout()) {
            this.relayout();
        } else {
            this.repaint();
        }
    }

    private final double fromAbsolute(double d) {
        if (this.getOrientation() == BOrientation.horizontal) {
            double d2 = this.getWidth() - this.getDividerWidth();
            if (d2 <= 0.0) {
                return 0.0;
            }
            return d / d2 * 100.0;
        }
        double d3 = this.getHeight() - this.getDividerWidth();
        if (d3 <= 0.0) {
            return 0.0;
        }
        return d / d3 * 100.0;
    }

    private final void resetCursor() {
        if (!this.getMoveableDivider()) {
            return;
        }
        this.setMouseCursor(MouseCursor.normal);
    }

    private final MouseCursor checkCursor(double d, double d2) {
        if (!this.getMoveableDivider()) {
            return null;
        }
        if (this.inDivider(d, d2)) {
            if (this.getOrientation() == BOrientation.horizontal) {
                return MouseCursor.eResize;
            }
            return MouseCursor.nResize;
        }
        return MouseCursor.normal;
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n != 304) {
            return super.fw(n, object, object2, object3, object4);
        }
        Point point = (Point)object;
        return this.checkCursor(point.x, point.y);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.shadowDivBrush = BColor.make((int)0, (int)0, (int)0, (int)75).toBrush();
        this.inDrag = false;
        this.dragOffset = 0.0;
    }

    public BSplitPane(BOrientation bOrientation, double d) {
        this.this();
        this.setOrientation(bOrientation);
        this.setDividerPosition(d);
    }

    public BSplitPane(BWidget bWidget, BWidget bWidget2) {
        this.this();
        this.setWidget1(bWidget);
        this.setWidget2(bWidget2);
    }

    public BSplitPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BSplitPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BSplitPane = BSplitPane.class("[Ljavax.baja.ui.pane.BSplitPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/splitPane.png");
    }
}

