/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.ui.theme.ScrollPaneTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.pane.BPane;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BScrollPane
extends BPane {
    public static final Property content = BScrollPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Property hscrollBar = BScrollPane.newProperty((int)7, (BValue)new BScrollBar(BOrientation.horizontal, 15, 150, false), null);
    public static final Property vscrollBar = BScrollPane.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical, 15, 150, false), null);
    public static final Property hpolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.asNeeded, null);
    public static final Property vpolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.asNeeded, null);
    public static final Property viewportBackground = BScrollPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property borderPolicy = BScrollPane.newProperty((int)0, (BValue)BScrollBarPolicy.always, null);
    public static final Action hscroll = BScrollPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Action vscroll = BScrollPane.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Type TYPE;
    private static final BIcon icon;
    protected RectGeom viewport;
    private RectGeom scrollTo;
    private boolean vsbShow;
    private boolean hsbShow;
    static /* synthetic */ Class class$javax$baja$ui$pane$BScrollPane;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget bWidget) {
        this.set(content, (BValue)bWidget, null);
    }

    public BScrollBar getHscrollBar() {
        return (BScrollBar)this.get(hscrollBar);
    }

    public void setHscrollBar(BScrollBar bScrollBar) {
        this.set(hscrollBar, (BValue)bScrollBar, null);
    }

    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    public void setVscrollBar(BScrollBar bScrollBar) {
        this.set(vscrollBar, (BValue)bScrollBar, null);
    }

    public BScrollBarPolicy getHpolicy() {
        return (BScrollBarPolicy)this.get(hpolicy);
    }

    public void setHpolicy(BScrollBarPolicy bScrollBarPolicy) {
        this.set(hpolicy, (BValue)bScrollBarPolicy, null);
    }

    public BScrollBarPolicy getVpolicy() {
        return (BScrollBarPolicy)this.get(vpolicy);
    }

    public void setVpolicy(BScrollBarPolicy bScrollBarPolicy) {
        this.set(vpolicy, (BValue)bScrollBarPolicy, null);
    }

    public BBrush getViewportBackground() {
        return (BBrush)this.get(viewportBackground);
    }

    public void setViewportBackground(BBrush bBrush) {
        this.set(viewportBackground, (BValue)bBrush, null);
    }

    public BScrollBarPolicy getBorderPolicy() {
        return (BScrollBarPolicy)this.get(borderPolicy);
    }

    public void setBorderPolicy(BScrollBarPolicy bScrollBarPolicy) {
        this.set(borderPolicy, (BValue)bScrollBarPolicy, null);
    }

    public void hscroll(BScrollEvent bScrollEvent) {
        this.invoke(hscroll, (BValue)bScrollEvent, null);
    }

    public void vscroll(BScrollEvent bScrollEvent) {
        this.invoke(vscroll, (BValue)bScrollEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        this.linkTo(this.getHscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)hscroll);
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public RectGeom getViewport() {
        return new RectGeom((IRectGeom)this.viewport);
    }

    public BWidget childAt(Point point) {
        BInsets bInsets = this.theme().getInsets();
        if (point.x - bInsets.left < this.viewport.width && point.y - bInsets.top < this.viewport.height) {
            return this.getContent();
        }
        BScrollBar bScrollBar = this.getHscrollBar();
        if (bScrollBar.contains(point.x - bScrollBar.getX(), point.y - bScrollBar.getY())) {
            return bScrollBar;
        }
        BScrollBar bScrollBar2 = this.getVscrollBar();
        if (bScrollBar2.contains(point.x - bScrollBar2.getX(), point.y - bScrollBar2.getY())) {
            return bScrollBar2;
        }
        return null;
    }

    public Point translateToChild(BWidget bWidget, Point point) {
        if (bWidget == this.getContent()) {
            BInsets bInsets = this.theme().getInsets();
            point.translate(this.viewport.x - bInsets.left, this.viewport.y - bInsets.top);
            return point;
        }
        return super.translateToChild(bWidget, point);
    }

    public void computePreferredSize() {
        BInsets bInsets = this.theme().getInsets();
        BWidget bWidget = this.getContent();
        bWidget.computePreferredSize();
        double d = bWidget.getPreferredWidth() + bInsets.left + bInsets.right;
        double d2 = bWidget.getPreferredHeight() + bInsets.top + bInsets.bottom;
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d;
        double d2;
        BWidget bWidget = this.getContent();
        if (bWidget == null) {
            return;
        }
        BInsets bInsets = this.theme().getInsets();
        double d3 = this.getWidth() - bInsets.left - bInsets.right;
        double d4 = this.getHeight() - bInsets.top - bInsets.bottom;
        bWidget.computePreferredSize();
        double d5 = bWidget.getPreferredWidth();
        double d6 = bWidget.getPreferredHeight();
        BScrollBar bScrollBar = this.getHscrollBar();
        BScrollBar bScrollBar2 = this.getVscrollBar();
        BScrollBarPolicy bScrollBarPolicy = this.getHpolicy();
        BScrollBarPolicy bScrollBarPolicy2 = this.getVpolicy();
        bScrollBar.computePreferredSize();
        bScrollBar2.computePreferredSize();
        this.hsbShow = false;
        switch (bScrollBarPolicy.getOrdinal()) {
            case 0: {
                boolean bl = false;
                if (d5 > d3) {
                    bl = true;
                }
                this.hsbShow = bl;
                break;
            }
            case 1: {
                this.hsbShow = true;
                break;
            }
            case 2: {
                this.hsbShow = false;
                break;
            }
        }
        this.vsbShow = false;
        switch (bScrollBarPolicy2.getOrdinal()) {
            case 0: {
                boolean bl = false;
                if (d6 > d4) {
                    bl = true;
                }
                this.vsbShow = bl;
                break;
            }
            case 1: {
                this.vsbShow = true;
                break;
            }
            case 2: {
                this.vsbShow = false;
                break;
            }
        }
        if (bScrollBarPolicy == BScrollBarPolicy.asNeeded && this.vsbShow) {
            boolean bl = false;
            if (d5 > d3 - bScrollBar2.getPreferredWidth()) {
                bl = this.hsbShow = true;
            }
        }
        if (bScrollBarPolicy2 == BScrollBarPolicy.asNeeded && this.hsbShow) {
            boolean bl = false;
            if (d6 > d4 - bScrollBar.getPreferredHeight()) {
                bl = this.vsbShow = true;
            }
        }
        if (bScrollBarPolicy == BScrollBarPolicy.asNeeded && this.vsbShow) {
            boolean bl = false;
            if (d5 > d3 - bScrollBar2.getPreferredWidth()) {
                bl = this.hsbShow = true;
            }
        }
        if (!this.hsbShow) {
            bScrollBar.setBounds(0.0, 0.0, 0.0, 0.0);
        } else {
            d2 = this.vsbShow ? d3 - bScrollBar2.getPreferredWidth() : d3;
            d = bScrollBar.getPreferredHeight();
            bScrollBar.setBounds(bInsets.left, d4 - d + bInsets.bottom, d2, d);
            bScrollBar.setMin(0);
            bScrollBar.setMax((int)d5);
            bScrollBar.setExtent((int)Math.min(d5, d3 - (this.vsbShow ? bScrollBar2.getPreferredWidth() : 0.0)));
            if ((double)bScrollBar.getPosition() > d5 - (double)bScrollBar.getExtent()) {
                this.viewport.x = d5 - (double)bScrollBar.getExtent();
                bScrollBar.setPosition((int)this.viewport.x);
            } else {
                this.viewport.x = bScrollBar.getPosition();
            }
        }
        if (!this.vsbShow) {
            bScrollBar2.setBounds(0.0, 0.0, 0.0, 0.0);
        } else {
            d2 = bScrollBar2.getPreferredWidth();
            d = this.hsbShow ? d4 - bScrollBar.getPreferredHeight() : d4;
            bScrollBar2.setBounds(d3 - d2 + bInsets.right, bInsets.top, d2, d);
            bScrollBar2.setMin(0);
            bScrollBar2.setMax((int)d6);
            bScrollBar2.setExtent((int)Math.min(d6, d4 - bScrollBar.getHeight()));
            if ((double)bScrollBar2.getPosition() > d6 - (double)bScrollBar2.getExtent()) {
                this.viewport.y = d6 - (double)bScrollBar2.getExtent();
                bScrollBar2.setPosition((int)this.viewport.y);
            } else {
                this.viewport.y = bScrollBar2.getPosition();
            }
        }
        this.viewport.width = this.vsbShow ? d3 - bScrollBar2.getWidth() : d3;
        double d7 = this.viewport.height = this.hsbShow ? d4 - bScrollBar.getHeight() : d4;
        if (this.viewport.width < 0.0) {
            this.viewport.x = 0.0;
            bScrollBar.setPosition(0);
        } else if (this.viewport.width > d5) {
            this.viewport.x = 0.0;
            d5 = this.viewport.width;
        }
        if (this.viewport.height < 0.0) {
            this.viewport.y = 0.0;
            bScrollBar2.setPosition(0);
        } else if (this.viewport.height > d6) {
            this.viewport.y = 0.0;
            d6 = this.viewport.height;
        }
        bWidget.setBounds(0.0, 0.0, d5, d6);
        if (this.scrollTo != null) {
            this.scrollToVisible(this.scrollTo);
            this.scrollTo = null;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        BInsets bInsets = this.theme().getInsets();
        BWidget bWidget = this.getContent();
        BScrollBar bScrollBar = this.getHscrollBar();
        BScrollBar bScrollBar2 = this.getVscrollBar();
        double d = bInsets.left;
        double d2 = bInsets.top;
        graphics.translate(d, d2);
        IRectGeom iRectGeom = graphics.getClipBounds();
        BBrush bBrush = this.getViewportBackground();
        if (bBrush.isNull()) {
            graphics.setBrush(this.theme().getWindowBackground(this));
        } else {
            graphics.setBrush(bBrush);
        }
        graphics.fill((IGeom)iRectGeom);
        if (iRectGeom.intersects(0.0, 0.0, this.viewport.width, this.viewport.height)) {
            graphics.push();
            try {
                double d3 = this.viewport.x;
                double d4 = this.viewport.y;
                graphics.clip(0.0, 0.0, this.viewport.width, this.viewport.height);
                graphics.translate(-d3, -d4);
                bWidget.paint(graphics);
            }
            catch (Throwable throwable) {
                Object var13_13 = null;
                graphics.pop();
                throw throwable;
            }
            {
                Object var13_14 = null;
            }
            graphics.pop();
        }
        if (bScrollBar.getHeight() > 0.0 && bScrollBar2.getWidth() > 0.0) {
            graphics.setBrush(this.theme().getControlBackground());
            graphics.fillRect(bScrollBar.getWidth(), bScrollBar2.getHeight(), bScrollBar2.getWidth(), bScrollBar.getHeight());
        }
        graphics.translate(-d, -d2);
        if (this.getBorderPolicy() == BScrollBarPolicy.always || this.getBorderPolicy() == BScrollBarPolicy.asNeeded && (this.vsbShow || this.hsbShow)) {
            this.theme().paintBorder(graphics, this);
        }
        if (this.hsbShow) {
            this.paintChild(graphics, bScrollBar);
        }
        if (this.vsbShow) {
            this.paintChild(graphics, bScrollBar2);
        }
    }

    public void doHscroll(BScrollEvent bScrollEvent) {
        this.viewport.x = bScrollEvent.getPosition();
        this.repaint();
    }

    public void doVscroll(BScrollEvent bScrollEvent) {
        this.viewport.y = bScrollEvent.getPosition();
        this.repaint();
    }

    public void scrollToVisible(RectGeom rectGeom) {
        BScrollBar bScrollBar = this.getHscrollBar();
        BScrollBar bScrollBar2 = this.getVscrollBar();
        BWidget bWidget = this.getContent();
        if (this.viewport.width == 0.0) {
            this.scrollTo = rectGeom;
            return;
        }
        if (this.viewport.contains((IGeom)rectGeom)) {
            return;
        }
        double d = this.viewport.x;
        double d2 = d + this.viewport.width;
        double d3 = this.viewport.y;
        double d4 = d3 + this.viewport.height;
        double d5 = rectGeom.x;
        double d6 = d5 + rectGeom.width;
        double d7 = rectGeom.y;
        double d8 = d7 + rectGeom.height;
        if (d2 < d6) {
            d += d6 - d2;
        }
        if (d4 < d8) {
            d3 += d8 - d4;
        }
        if (d > d5) {
            d = d5;
        }
        if (d3 > d7) {
            d3 = d7;
        }
        if (d + this.viewport.width > bWidget.getWidth()) {
            d = bWidget.getWidth() - this.viewport.width;
        }
        if (d3 + this.viewport.height > bWidget.getHeight()) {
            d3 = bWidget.getHeight() - this.viewport.height;
        }
        if (d < 0.0) {
            d = 0.0;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        this.viewport.x = d;
        this.viewport.y = d3;
        bScrollBar.resetPosition((int)d, 602);
        bScrollBar2.resetPosition((int)d3, 602);
    }

    public boolean pulseViewport(Point point, double d) {
        double d2;
        Point point2 = this.translateFromChild(this.getContent(), new Point((IPoint)point));
        double d3 = point2.x;
        double d4 = point2.y;
        if (!this.contains(d3, d4)) {
            return false;
        }
        double d5 = d2 = 16.0;
        double d6 = this.getWidth() - d2 - this.getVscrollBar().getWidth();
        double d7 = d2;
        double d8 = this.getHeight() - d2 - this.getHscrollBar().getHeight();
        double d9 = 0.0;
        double d10 = 0.0;
        if (d3 < d5) {
            d9 = -d;
        } else if (d3 > d6) {
            d9 = d;
        }
        if (d4 < d7) {
            d10 = -d;
        } else if (d4 > d8) {
            d10 = d;
        }
        if (d9 != 0.0 || d10 != 0.0) {
            RectGeom rectGeom = this.getViewport();
            rectGeom.x += d9;
            rectGeom.y += d10;
            this.scrollToVisible(rectGeom);
            return true;
        }
        return false;
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        BScrollBar bScrollBar = this.getVscrollBar();
        if (!bScrollBar.isVisible() || bScrollBar.getWidth() == 0.0) {
            return;
        }
        int n = this.getWheelUnits();
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            int n2 = 0;
            while (n2 < n) {
                bScrollBar.incrementByUnit();
                ++n2;
            }
        } else {
            int n3 = 0;
            while (n3 < n) {
                bScrollBar.decrementByUnit();
                ++n3;
            }
        }
        bMouseWheelEvent.consume();
    }

    protected int getWheelUnits() {
        return 3;
    }

    ScrollPaneTheme theme() {
        return Theme.scrollPane();
    }

    public String getStyleSelector() {
        return "pane scroll-pane";
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.viewport = new RectGeom();
        this.vsbShow = false;
        this.hsbShow = false;
    }

    public BScrollPane(BWidget bWidget) {
        this();
        this.setContent(bWidget);
    }

    public BScrollPane() {
        this.this();
        this.linkTo(this.getHscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)hscroll);
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BScrollPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BScrollPane = BScrollPane.class("[Ljavax.baja.ui.pane.BScrollPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/scrollPane.png");
    }
}

