/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import com.tridium.gx.GraphPaper;
import com.tridium.gx.GxEnv;
import com.tridium.gx.Hatching;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BSize;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.nre.util.Array;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BLabelPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.ui.shape.BShape;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCanvasPane
extends BPane {
    public static final Property viewSize = BCanvasPane.newProperty((int)0, (BValue)BSize.make((double)100.0, (double)100.0), null);
    public static final Property scale = BCanvasPane.newProperty((int)0, (BValue)BScaleMode.none, null);
    public static final Property halign = BCanvasPane.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BCanvasPane.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property background = BCanvasPane.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Type TYPE;
    private static final BIcon icon;
    public boolean overrideClip;
    private BTransform scaleTransform;
    private double dx;
    private double dy;
    private double sx;
    private double sy;
    private boolean paintGraphPaper;
    private boolean paintHatching;
    private GraphPaper graphPaper;
    private Hatching hatching;
    static /* synthetic */ Class class$javax$baja$ui$pane$BCanvasPane;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public BSize getViewSize() {
        return (BSize)this.get(viewSize);
    }

    public void setViewSize(BSize bSize) {
        this.set(viewSize, (BValue)bSize, null);
    }

    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    public void setScale(BScaleMode bScaleMode) {
        this.set(scale, (BValue)bScaleMode, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign bHalign) {
        this.set(halign, (BValue)bHalign, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign bValign) {
        this.set(valign, (BValue)bValign, null);
    }

    public BBrush getBackground() {
        return (BBrush)this.get(background);
    }

    public void setBackground(BBrush bBrush) {
        this.set(background, (BValue)bBrush, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.getViewSize().width, this.getViewSize().height);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.getViewSize().width;
        double d4 = this.getViewSize().height;
        switch (this.getScale().getOrdinal()) {
            case 1: {
                this.sx = d / d3;
                this.sy = d2 / d4;
                this.dy = 0.0;
                this.dx = 0.0;
                break;
            }
            case 2: {
                this.sx = this.sy = Math.min(d / d3, d2 / d4);
                if (this.sx == d / d3) {
                    this.dx = 0.0;
                    this.dy = this.doValign(d2, d4 * this.sx);
                    break;
                }
                this.dx = this.doHalign(d, d3 * this.sx);
                this.dy = 0.0;
                break;
            }
            case 3: {
                this.sx = d / d3;
                this.sy = 1.0;
                this.dx = 0.0;
                this.dy = this.doValign(d2, d4);
                break;
            }
            case 4: {
                this.sx = 1.0;
                this.sy = d2 / d4;
                this.dx = this.doHalign(d, d3);
                this.dy = 0.0;
                break;
            }
            default: {
                this.sy = 1.0;
                this.sx = 1.0;
                this.dx = this.doHalign(d, d3);
                this.dy = this.doValign(d2, d4);
            }
        }
        this.dx = Math.floor(this.dx);
        this.dy = Math.floor(this.dy);
        this.scaleTransform = BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Translate(this.dx, this.dy), new BTransform.Scale(this.sx, this.sy)});
        int n = 0;
        while (n < bWidgetArray.length) {
            BLayout bLayout = bWidgetArray[n].getLayout();
            if (!bLayout.isNull()) {
                bWidgetArray[n].computePreferredSize();
                double d5 = bLayout.getX();
                double d6 = bLayout.getY();
                double d7 = bLayout.getWidth();
                double d8 = bLayout.getHeight();
                if (bLayout.getXUnit() == 1) {
                    d5 = d5 / 100.0 * d3;
                }
                if (bLayout.getYUnit() == 1) {
                    d6 = d6 / 100.0 * d4;
                }
                if (bLayout.getWidthUnit() == 1) {
                    d7 = d7 / 100.0 * d3;
                } else if (bLayout.getWidthUnit() == 2) {
                    d7 = bWidgetArray[n].getPreferredWidth();
                }
                if (bLayout.getHeightUnit() == 1) {
                    d8 = d8 / 100.0 * d4;
                } else if (bLayout.getHeightUnit() == 2) {
                    d8 = bWidgetArray[n].getPreferredHeight();
                }
                bWidgetArray[n].setBounds(d5, d6, d7, d8);
            }
            ++n;
        }
    }

    private final double doHalign(double d, double d2) {
        BHalign bHalign = this.getHalign();
        if (bHalign == BHalign.left) {
            return 0.0;
        }
        if (bHalign == BHalign.center) {
            return (d - d2) / (double)2;
        }
        return d - d2 - 1.0;
    }

    private final double doValign(double d, double d2) {
        BValign bValign = this.getValign();
        if (bValign == BValign.top) {
            return 0.0;
        }
        if (bValign == BValign.center) {
            return (d - d2) / (double)2;
        }
        return d - d2 - 1.0;
    }

    public BWidget childAt(Point point) {
        return super.childAt(this.scaleTransform.getInverse().transform((IPoint)point, null));
    }

    public BWidget[] childrenAt(Point point) {
        point = this.scaleTransform.getInverse().transform((IPoint)point, null);
        Class clazz = class$javax$baja$ui$BWidget;
        if (clazz == null) {
            clazz = class$javax$baja$ui$BWidget = BCanvasPane.class("[Ljavax.baja.ui.BWidget;", false);
        }
        Array array = new Array(clazz);
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n = bWidgetArray.length - 1;
        while (n >= 0) {
            BWidget bWidget = bWidgetArray[n];
            if (bWidget.isVisible() && bWidget.contains(point.x - bWidget.getX(), point.y - bWidget.getY())) {
                array.add((Object)bWidget);
            }
            --n;
        }
        if (array.size() == 0) {
            return null;
        }
        return (BWidget[])array.trim();
    }

    public Point translateToChild(BWidget bWidget, Point point) {
        point = this.scaleTransform.getInverse().transform((IPoint)point, point);
        return super.translateToChild(bWidget, point);
    }

    public Point translateFromChild(BWidget bWidget, Point point) {
        point.x += bWidget.getX();
        point.y += bWidget.getY();
        point = this.scaleTransform.transform((IPoint)point, point);
        return point;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        BBrush bBrush = this.getBackground();
        if (!bBrush.isNull()) {
            graphics.setBrush(bBrush);
            graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
        graphics.push();
        try {
            graphics.transform(this.scaleTransform);
            graphics.clip(0.0, 0.0, this.getViewSize().width + 1.0, this.getViewSize().height + 1.0);
            if (this.paintGraphPaper) {
                this.graphPaper.fillRect(graphics, this.dx < 0.0 ? -this.dx * this.sx : 0.0, this.dy < 0.0 ? -this.dy * this.sy : 0.0, this.getWidth() / this.sx, this.getHeight() / this.sy);
            }
            boolean bl = false;
            if (this.paintHatching && this.hatchable()) {
                bl = true;
            }
            this.paintKids(graphics, bl);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            graphics.pop();
            throw throwable;
        }
        {
            Object var4_5 = null;
        }
        graphics.pop();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void paintKids(Graphics graphics, boolean bl) {
        IGeom iGeom = graphics.getClip();
        BWidget[] bWidgetArray = this.getChildWidgets();
        int n = 0;
        while (true) {
            block8: {
                Object var16_11;
                if (n >= bWidgetArray.length) {
                    return;
                }
                BWidget bWidget = bWidgetArray[n];
                if (!bWidget.isVisible()) break block8;
                double d = bWidget.getX();
                double d2 = bWidget.getY();
                double d3 = bWidget.getWidth();
                double d4 = bWidget.getHeight();
                if (!this.overrideClip && !iGeom.intersects(d, d2, d3, d4)) break block8;
                graphics.push();
                try {
                    try {
                        graphics.clip(d, d2, d3, d4);
                        graphics.translate(d, d2);
                        bWidget.paint(graphics);
                        if (bl && !(bWidget instanceof BShape)) {
                            graphics.transform(BTransform.makeScale((double)this.sx, (double)this.sy));
                            this.hatching.fillRect(graphics, this.dx + d < 0.0 ? -(this.dx + d) * this.sx : 0.0, this.dy + d2 < 0.0 ? -(this.dy + d2) * this.sy : 0.0, d3 / this.sx, d4 / this.sy);
                        }
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                catch (Throwable throwable) {
                    var16_11 = null;
                    graphics.pop();
                    throw throwable;
                }
                {
                    var16_11 = null;
                }
                graphics.pop();
            }
            ++n;
        }
    }

    private final boolean hatchable() {
        BWidget bWidget = this.getParentWidget();
        while (bWidget != null) {
            BLabelPane bLabelPane;
            BTabbedPane bTabbedPane;
            if (bWidget instanceof BCanvasPane) {
                return false;
            }
            if (bWidget instanceof BLabelPane && bWidget.getParentWidget() instanceof BTabbedPane && (bTabbedPane = (BTabbedPane)(bLabelPane = (BLabelPane)bWidget).getParentWidget()).getSelectedLabelPane() != bLabelPane) {
                return false;
            }
            bWidget = bWidget.getParentWidget();
        }
        return true;
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        if (n == 304) {
            Object[] objectArray = (Object[])object;
            this.paintGraphPaper = (Boolean)objectArray[0];
            if (this.paintGraphPaper) {
                if (this.graphPaper == null) {
                    this.graphPaper = GxEnv.get().makeGraphPaper();
                }
                this.graphPaper.setSize(((Integer)objectArray[1]).intValue());
                this.graphPaper.setColor((BColor)objectArray[2]);
            }
            Object[] objectArray2 = (Object[])object2;
            this.paintHatching = (Boolean)objectArray2[0];
            if (this.paintHatching) {
                if (this.hatching == null) {
                    this.hatching = GxEnv.get().makeHatching();
                }
                this.hatching.setColor((BColor)objectArray2[1]);
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    public BIcon getIcon() {
        return icon;
    }

    public BTransform getScaleTransform() {
        return this.scaleTransform;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.overrideClip = false;
        this.scaleTransform = BTransform.DEFAULT;
    }

    public BCanvasPane() {
        this.this();
    }

    static {
        Class clazz = class$javax$baja$ui$pane$BCanvasPane;
        if (clazz == null) {
            clazz = class$javax$baja$ui$pane$BCanvasPane = BCanvasPane.class("[Ljavax.baja.ui.pane.BCanvasPane;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/canvasPane.png");
    }
}

