/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.ui.BWidget;
import javax.baja.ui.list.BList;

public class ListRenderer
extends BList.ListSupport {
    public BBrush getForeground(Item item) {
        BList bList = this.getList();
        BWidget bWidget = bList.getParentWidget();
        if (this.getList().isEnabled() && (bWidget == null || bWidget.isEnabled())) {
            return Theme.dropDown().getTextBrush(bList);
        }
        return Theme.textEditor().getDisabledTextBrush(bList);
    }

    public BBrush getBackground(Item item) {
        return null;
    }

    public BBrush getSelectionForeground(Item item) {
        return Theme.dropDown().getSelectionForeground(this.getList());
    }

    public BBrush getSelectionBackground(Item item) {
        return Theme.dropDown().getSelectionBackground(this.getList());
    }

    public double getItemHeight() {
        return Math.max(Theme.table().getCellHeight(), 18.0);
    }

    public double getPreferredItemWidth(Item item) {
        String string = this.getItemText(item);
        double d = Theme.table().getCellFont().width(string) + 12.0;
        if (item.icon != null) {
            d += 18.0;
        }
        return d;
    }

    public void paintItem(Graphics graphics, Item item) {
        this.paintItemBackground(graphics, item);
        double d = 4;
        if (item.icon != null) {
            graphics.drawImage(item.icon, d, (item.height - item.icon.getHeight()) / (double)2);
            d += 20.0;
        }
        String string = this.getItemText(item);
        BFont bFont = Theme.table().getCellFont(this.list);
        double d2 = bFont.getHeight();
        double d3 = bFont.getAscent();
        double d4 = (item.height - d2) / (double)2;
        graphics.setFont(bFont);
        graphics.drawString(string, d, d4 + d3);
    }

    public String getItemText(Item item) {
        return String.valueOf(item.value);
    }

    protected void paintItemBackground(Graphics graphics, Item item) {
        if (item.selected) {
            BBrush bBrush = this.getSelectionBackground(item);
            if (bBrush != null) {
                graphics.setBrush(bBrush);
                graphics.fillRect(0.0, 0.0, item.width, item.height);
            }
            graphics.setBrush(this.getSelectionForeground(item));
        } else {
            BBrush bBrush = this.getBackground(item);
            if (bBrush != null) {
                graphics.setBrush(bBrush);
                graphics.fillRect(0.0, 0.0, item.width, item.height);
            }
            graphics.setBrush(this.getForeground(item));
        }
        graphics.setFont(Theme.table().getCellFont());
    }

    public static class Item {
        public int index;
        public BImage icon;
        public Object value;
        public double width;
        public double height;
        public boolean selected;
    }
}

