/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import javax.baja.sys.Clock;
import javax.baja.ui.BMenu;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.list.ListSubject;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class ListController
extends BList.ListSupport {
    private String searchText;
    private long lastSearchTime;
    private int overItem;
    private boolean overBackground;
    private boolean checkSelectionOnRelease;
    private double lastx;
    private double lasty;

    public void focusGained(BFocusEvent bFocusEvent) {
        BList bList = this.getList();
        ListSelection listSelection = bList.getSelection();
        if (listSelection.getItemCount() > 0) {
            if (listSelection.getItem() == -1) {
                listSelection.select(0);
            }
            this.getList().ensureItemIsVisible(listSelection.getItem());
        }
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.getList().repaint();
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0 && bKeyEvent.getModifiers() != 1) {
            return;
        }
        int n = bKeyEvent.getKeyCode();
        BList bList = this.getList();
        ListSelection listSelection = bList.getSelection();
        int n2 = listSelection.getLead();
        int n3 = bList.getVisibleRowCount();
        int n4 = bList.getVscrollBar().getPosition();
        switch (n) {
            case 36: {
                bKeyEvent.consume();
                listSelection.select(0, true);
                bList.ensureItemIsVisible(0);
                this.searchText = "";
                break;
            }
            case 35: {
                bKeyEvent.consume();
                int n5 = bList.getModel().getItemCount() - 1;
                listSelection.select(n5, true);
                bList.ensureItemIsVisible(n5);
                this.searchText = "";
                break;
            }
            case 38: {
                bKeyEvent.consume();
                n2 = Math.max(n2 - 1, 0);
                listSelection.select(n2, true);
                bList.ensureItemIsVisible(n2);
                this.searchText = "";
                break;
            }
            case 40: {
                bKeyEvent.consume();
                n2 = Math.min(n2 + 1, bList.getModel().getItemCount() - 1);
                listSelection.select(n2, true);
                bList.ensureItemIsVisible(n2);
                this.searchText = "";
                break;
            }
            case 33: {
                bKeyEvent.consume();
                n2 = n2 > n4 && n2 <= n4 + n3 ? Math.max(n4, 0) : Math.max(n2 - n3 + 1, 0);
                listSelection.select(n2, true);
                bList.ensureItemIsVisible(n2);
                this.searchText = "";
                break;
            }
            case 34: {
                bKeyEvent.consume();
                n2 = n2 > n4 && n2 < n4 + n3 - 1 ? Math.min(n4 + n3 - 1, bList.getModel().getItemCount() - 1) : Math.min(n2 + n3 - 1, bList.getModel().getItemCount() - 1);
                listSelection.select(n2, true);
                bList.ensureItemIsVisible(n2);
                this.searchText = "";
                break;
            }
            default: {
                char c = bKeyEvent.getKeyChar();
                if ((32 > n || n > 57) && (65 > n || n > 90)) break;
                this.searchText = Clock.ticks() - 750L < this.lastSearchTime ? this.searchText + c : "" + c;
                this.search(this.searchText);
                this.lastSearchTime = Clock.ticks();
                bKeyEvent.consume();
            }
        }
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        if (bKeyEvent.getKeyCode() == 10 || bKeyEvent.getKeyCode() == 9) {
            this.handleEnter(bKeyEvent);
        } else if (bKeyEvent.getKeyCode() == 27) {
            this.handleEscape(bKeyEvent);
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    protected void handleEnter(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getList().fireActionPerformed(new BWidgetEvent(2, this.getList()));
    }

    protected void handleEscape(BKeyEvent bKeyEvent) {
        bKeyEvent.consume();
        this.getList().fireCancelled(new BWidgetEvent(2, this.getList()));
    }

    private final boolean search(String string) {
        ListModel listModel = this.getModel();
        ListSelection listSelection = this.getSelection();
        ListRenderer listRenderer = this.getRenderer();
        ListRenderer.Item item = new ListRenderer.Item();
        int n = -1;
        int n2 = 0;
        while (n2 < listModel.getItemCount()) {
            item.value = listModel.getItem(n2);
            String string2 = listRenderer.getItemText(item);
            if (string2 != null && string2.length() > 0 && string2.toLowerCase().startsWith(string.toLowerCase())) {
                n = n2;
                break;
            }
            ++n2;
        }
        if (n >= 0) {
            listSelection.select(n, true);
            this.list.ensureItemIsVisible(n);
            return true;
        }
        return false;
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.overItem != -1) {
            this.itemPressed(bMouseEvent, this.overItem);
        } else if (this.overBackground) {
            this.backgroundPressed(bMouseEvent);
        }
        this.getList().requestFocus();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.overItem != -1) {
            this.itemReleased(bMouseEvent, this.overItem);
        } else if (this.overBackground) {
            this.backgroundReleased(bMouseEvent);
        }
        this.checkMouseOver(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.lastx = -1.0;
        this.lasty = -1.0;
        this.mouseMoved(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.fireExit(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getX() == this.lastx && bMouseEvent.getY() == this.lasty) {
            return;
        }
        if (this.lastx == -1.0 && this.lasty == -1.0) {
            this.lastx = bMouseEvent.getX();
            this.lasty = bMouseEvent.getY();
            return;
        }
        this.lastx = bMouseEvent.getX();
        this.lasty = bMouseEvent.getY();
        if (this.checkMouseOver(bMouseEvent)) {
            return;
        }
        if (this.overItem != -1) {
            this.itemMoved(bMouseEvent, this.overItem);
        } else if (this.overBackground) {
            this.backgroundMoved(bMouseEvent);
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (this.overItem != -1) {
            this.itemDragged(bMouseEvent, this.overItem);
        } else if (this.overBackground) {
            this.backgroundDragged(bMouseEvent);
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        if (this.overItem != -1) {
            this.itemPulsed(bMouseEvent, this.overItem);
        } else if (this.overBackground) {
            this.backgroundPulsed(bMouseEvent);
        }
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        BScrollBar bScrollBar = this.getList().getVscrollBar();
        if (bMouseWheelEvent.getWheelRotation() > 0) {
            bScrollBar.incrementByUnit();
        } else {
            bScrollBar.decrementByUnit();
        }
    }

    private final boolean checkMouseOver(BMouseEvent bMouseEvent) {
        double d;
        double d2;
        BList bList = this.getList();
        int n = bList.getItemIndexAt(d2 = bMouseEvent.getX(), d = bMouseEvent.getY());
        if (n == -1) {
            if (!this.overBackground) {
                this.fireExit(bMouseEvent);
                this.overBackground = true;
                this.backgroundEntered(bMouseEvent);
                return true;
            }
        } else if (this.overItem != n) {
            this.fireExit(bMouseEvent);
            this.overItem = n;
            this.itemEntered(bMouseEvent, this.overItem);
            return true;
        }
        return false;
    }

    private final void fireExit(BMouseEvent bMouseEvent) {
        if (this.overItem != -1) {
            this.itemExited(bMouseEvent, this.overItem);
            this.overItem = -1;
        } else if (this.overBackground) {
            this.backgroundExited(bMouseEvent);
            this.overBackground = false;
        }
    }

    public int getMouseOverItem() {
        return this.overItem;
    }

    protected void itemEntered(BMouseEvent bMouseEvent, int n) {
    }

    protected void itemExited(BMouseEvent bMouseEvent, int n) {
    }

    protected void itemPressed(BMouseEvent bMouseEvent, int n) {
        if (this.getSelection().isSelected(n)) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(bMouseEvent, n);
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.itemPopup(bMouseEvent, n);
        }
        if (bMouseEvent.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.itemDoubleClicked(bMouseEvent, n);
        }
    }

    protected void itemReleased(BMouseEvent bMouseEvent, int n) {
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!bMouseEvent.isPopupTrigger()) {
                this.checkSelection(bMouseEvent, n);
            }
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.itemPopup(bMouseEvent, n);
        }
    }

    protected void itemMoved(BMouseEvent bMouseEvent, int n) {
    }

    protected void itemDragged(BMouseEvent bMouseEvent, int n) {
    }

    protected void itemPulsed(BMouseEvent bMouseEvent, int n) {
    }

    protected void itemDoubleClicked(BMouseEvent bMouseEvent, int n) {
    }

    protected void backgroundEntered(BMouseEvent bMouseEvent) {
    }

    protected void backgroundExited(BMouseEvent bMouseEvent) {
    }

    protected void backgroundPressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.backgroundPopup(bMouseEvent);
        } else if (!bMouseEvent.isButton3Down()) {
            this.getSelection().deselectAll();
        }
    }

    protected void backgroundReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.backgroundPopup(bMouseEvent);
        }
    }

    protected void backgroundMoved(BMouseEvent bMouseEvent) {
    }

    protected void backgroundDragged(BMouseEvent bMouseEvent) {
    }

    protected void backgroundPulsed(BMouseEvent bMouseEvent) {
    }

    protected void itemPopup(BMouseEvent bMouseEvent, int n) {
        this.popup(bMouseEvent, n);
    }

    protected void backgroundPopup(BMouseEvent bMouseEvent) {
        this.popup(bMouseEvent, -1);
    }

    protected void popup(BMouseEvent bMouseEvent, int n) {
        ListSubject listSubject = this.getSelection().getSubject(n);
        BMenu bMenu = this.makePopup(listSubject);
        if (bMenu != null) {
            bMenu.removeConsecutiveSeparators();
            bMenu.open(bMouseEvent);
        }
    }

    protected BMenu makePopup(ListSubject listSubject) {
        return null;
    }

    protected void checkSelection(BMouseEvent bMouseEvent, int n) {
        BList bList = this.getList();
        ListSelection listSelection = bList.getSelection();
        if (bList.getMultipleSelection()) {
            if (bMouseEvent.isShiftDown()) {
                listSelection.select(listSelection.getAnchor(), n, bMouseEvent.isControlDown() ^ true);
            } else if (bMouseEvent.isControlDown()) {
                if (listSelection.isSelected(n)) {
                    listSelection.deselect(n);
                } else {
                    listSelection.select(n);
                }
            } else {
                listSelection.select(n, true);
                bList.fireActionPerformed(new BWidgetEvent(2, this.getList()));
            }
        } else {
            listSelection.select(n, true);
            bList.fireActionPerformed(new BWidgetEvent(2, this.getList()));
        }
    }

    private final /* synthetic */ void this() {
        this.searchText = "";
        this.lastSearchTime = 0L;
        this.overItem = -1;
    }

    public ListController() {
        this.this();
    }
}

