/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BScrollBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.event.BScrollEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.DefaultListModel;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BList
extends BTransferWidget {
    public static final Property multipleSelection = BList.newProperty((int)0, (boolean)true, null);
    public static final Property vscrollBar = BList.newProperty((int)7, (BValue)new BScrollBar(BOrientation.vertical), null);
    public static final Action vscroll = BList.newAction((int)0, (BValue)new BScrollEvent(), null);
    public static final Topic actionPerformed = BList.newTopic((int)0, null);
    public static final Topic cancelled = BList.newTopic((int)0, null);
    public static final Topic listModified = BList.newTopic((int)0, null);
    public static final Topic selectionModified = BList.newTopic((int)0, null);
    public static final Type TYPE;
    private static final BIcon icon;
    BScrollBar scrollBar;
    ListModel model;
    ListController controller;
    ListRenderer renderer;
    ListSelection selection;
    double itemHeight;
    ListRenderer.Item item;
    static /* synthetic */ Class class$javax$baja$ui$list$BList;

    public boolean getMultipleSelection() {
        return this.getBoolean(multipleSelection);
    }

    public void setMultipleSelection(boolean bl) {
        this.setBoolean(multipleSelection, bl, null);
    }

    public BScrollBar getVscrollBar() {
        return (BScrollBar)this.get(vscrollBar);
    }

    public void setVscrollBar(BScrollBar bScrollBar) {
        this.set(vscrollBar, (BValue)bScrollBar, null);
    }

    public void vscroll(BScrollEvent bScrollEvent) {
        this.invoke(vscroll, (BValue)bScrollEvent, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public void fireCancelled(BWidgetEvent bWidgetEvent) {
        this.fire(cancelled, (BValue)bWidgetEvent, null);
    }

    public void fireListModified(BWidgetEvent bWidgetEvent) {
        this.fire(listModified, (BValue)bWidgetEvent, null);
    }

    public void fireSelectionModified(BWidgetEvent bWidgetEvent) {
        this.fire(selectionModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void started() {
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel listModel) {
        this.installSupport(this.model, listModel);
        this.model = listModel;
    }

    public ListController getController() {
        return this.controller;
    }

    public void setController(ListController listController) {
        this.installSupport(this.controller, listController);
        this.controller = listController;
    }

    public ListSelection getSelection() {
        return this.selection;
    }

    public void setSelection(ListSelection listSelection) {
        this.installSupport(this.selection, listSelection);
        this.selection = listSelection;
    }

    public ListRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(ListRenderer listRenderer) {
        this.installSupport(this.renderer, listRenderer);
        this.renderer = listRenderer;
        this.itemHeight = listRenderer.getItemHeight();
    }

    private final void installSupport(ListSupport listSupport, ListSupport listSupport2) {
        if (listSupport2 == null) {
            throw new NullPointerException();
        }
        if (listSupport == listSupport2) {
            return;
        }
        if (listSupport2.list != null) {
            throw new IllegalArgumentException("Already installed on another list");
        }
        if (listSupport != null) {
            listSupport.list = null;
        }
        listSupport2.list = this;
    }

    public void changed(Property property, Context context) {
        this.relayout();
    }

    public void computePreferredSize() {
        double d = 0.0;
        double d2 = 0.0;
        int n = this.model.getItemCount();
        int n2 = 0;
        while (n2 < n) {
            this.item.index = n2;
            this.item.icon = this.model.getItemIcon(n2);
            this.item.value = this.model.getItem(n2);
            d = Math.max(d, this.renderer.getPreferredItemWidth(this.item));
            ++n2;
        }
        d2 += (double)this.model.getItemCount() * this.itemHeight;
        d = Math.max(d, 10.0);
        d2 = Math.max(d2, 10.0);
        this.setPreferredSize(d, d2);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = this.model.getItemCount();
        double d3 = Theme.scrollBar().getFixedWidth();
        int n2 = this.getVisibleRowCount();
        BScrollBar bScrollBar = this.getVscrollBar();
        if (n2 < n) {
            bScrollBar.setVisible(true);
            bScrollBar.setMin(0);
            bScrollBar.setMax(n);
            bScrollBar.setExtent(n2);
            bScrollBar.setBlockIncrement(Math.max(3, n2 - 1));
            bScrollBar.setBounds(d - d3, 0.0, d3, d2);
        } else {
            bScrollBar.setVisible(false);
            bScrollBar.setBounds(0.0, 0.0, 0.0, 0.0);
            bScrollBar.setPosition(0);
            bScrollBar.setMin(0);
            bScrollBar.setMax(n2);
            bScrollBar.setExtent(n2);
        }
    }

    public int getVisibleRowCount() {
        return (int)(this.getHeight() / this.itemHeight);
    }

    public int getItemIndexAt(double d, double d2) {
        if (d < 0.0 || d > this.getWidth() - this.getVscrollBar().getWidth()) {
            return -1;
        }
        int n = (int)(d2 / this.itemHeight) + this.getVscrollBar().getPosition();
        if (n < this.model.getItemCount()) {
            return n;
        }
        return -1;
    }

    public RectGeom getItemBounds(int n) {
        double d = 0.0;
        double d2 = (double)n * this.itemHeight;
        double d3 = this.getWidth() - this.getVscrollBar().getWidth();
        double d4 = this.itemHeight;
        return new RectGeom(d, d2, d3, d4);
    }

    public void ensureItemIsVisible(int n) {
        int n2 = this.getVisibleRowCount();
        if (n2 <= 0) {
            if (this.getParent() instanceof BDropDown) {
                n2 = (int)(308.0 / this.itemHeight);
            } else {
                return;
            }
        }
        int n3 = this.getVscrollBar().getPosition();
        int n4 = n3 + n2;
        int n5 = this.model.getItemCount();
        BScrollBar bScrollBar = this.getVscrollBar();
        bScrollBar.setMax(Math.max(n2, n5));
        if (n < n3) {
            bScrollBar.setPosition(n);
        } else if (n >= n4) {
            int n6 = n - n2 + 1;
            if (n6 >= n5) {
                n6 = n5 - 1;
            }
            if (n6 < 0) {
                n6 = 0;
            }
            bScrollBar.setPosition(n6);
        }
    }

    public void doVscroll(BScrollEvent bScrollEvent) {
        this.repaint();
    }

    public int getItemCount() {
        return this.model.getItemCount();
    }

    public Object getItem(int n) {
        return this.model.getItem(n);
    }

    public int indexOfItem(Object object) {
        return this.model.indexOfItem(object);
    }

    public void addItem(Object object) {
        this.model.addItem(null, object);
    }

    public void addItem(BImage bImage, Object object) {
        this.model.addItem(bImage, object);
    }

    public void insertItem(int n, Object object) {
        this.model.insertItem(n, object);
    }

    public void insertItem(int n, BImage bImage, Object object) {
        this.model.insertItem(n, bImage, object);
    }

    public void setItem(int n, Object object) {
        this.model.setItem(n, object);
    }

    public void setItem(int n, BImage bImage, Object object) {
        this.model.setItem(n, bImage, object);
    }

    public void removeItem(Object object) {
        this.model.removeItem(object);
    }

    public void removeItem(int n) {
        this.model.removeItem(n);
    }

    public void removeAllItems() {
        this.model.removeAllItems();
    }

    public void removeSelectedItems() {
        int[] nArray = this.getSelection().getItems();
        this.getSelection().deselectAll();
        int n = nArray.length - 1;
        while (n >= 0) {
            this.removeItem(nArray[n]);
            --n;
        }
    }

    public boolean isSelected(int n) {
        return this.getSelection().isSelected(n);
    }

    public boolean isSelected(Object object) {
        return this.getSelection().isSelected(this.indexOfItem(object));
    }

    public int getSelectedIndex() {
        return this.getSelection().getItem();
    }

    public int[] getSelectedIndices() {
        return this.getSelection().getItems();
    }

    public Object getSelectedItem() {
        int n = this.getSelectedIndex();
        if (n < 0 || n >= this.getModel().getItemCount()) {
            return null;
        }
        return this.getModel().getItem(n);
    }

    public Object[] getSelectedItems() {
        int[] nArray = this.getSelectedIndices();
        Object[] objectArray = new Object[nArray.length];
        int n = 0;
        while (n < objectArray.length) {
            objectArray[n] = this.getModel().getItem(nArray[n]);
            ++n;
        }
        return objectArray;
    }

    public void setSelectedIndex(int n) {
        this.getSelection().deselectAll();
        this.getSelection().select(n);
    }

    public void setSelectedItem(Object object) {
        this.getSelection().deselectAll();
        int n = this.indexOfItem(object);
        if (n != -1) {
            this.setSelectedIndex(n);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void paint(Graphics graphics) {
        IGeom iGeom = graphics.getClip();
        BScrollBar bScrollBar = this.getVscrollBar();
        int n = this.model.getItemCount();
        int n2 = this.getVisibleRowCount();
        double d = this.getWidth();
        double d2 = this.getHeight();
        double d3 = this.itemHeight;
        double d4 = d - bScrollBar.getWidth();
        Theme.dropDown().paintBackground(graphics, this);
        int n3 = bScrollBar.getPosition();
        int n4 = Math.min(n3 + n2 + 1, n);
        double d5 = 0.0;
        int n5 = n3;
        while (true) {
            Object var20_14;
            if (n5 >= n4) {
                graphics.setBrush(BColor.black);
                graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
                this.paintChildren(graphics);
                return;
            }
            graphics.push();
            try {
                this.paintItem(graphics, n5, d5, d4);
            }
            catch (Throwable throwable) {
                var20_14 = null;
                graphics.pop();
                throw throwable;
            }
            {
                var20_14 = null;
            }
            graphics.pop();
            d5 += d3;
            ++n5;
        }
    }

    private final void paintItem(Graphics graphics, int n, double d, double d2) {
        BImage bImage = null;
        Object object = "?";
        try {
            bImage = this.model.getItemIcon(n);
            object = this.model.getItem(n);
        }
        catch (Exception exception) {
            System.out.println("ERROR:  BList.paintItem: " + n);
            System.out.println("  " + exception);
        }
        ListRenderer.Item item = this.item;
        item.icon = bImage;
        item.index = n;
        item.value = object;
        item.width = d2;
        item.height = this.itemHeight;
        item.selected = this.selection.isSelected(n);
        double d3 = 0.0;
        double d4 = Math.min(item.width, this.getWidth() - d3);
        double d5 = Math.min(item.height, this.getHeight() - d);
        graphics.clip(d3, d, d4, d5);
        graphics.translate(d3, d);
        this.renderer.paintItem(graphics, item);
        graphics.translate(-d3, -d);
    }

    public String getStyleSelector() {
        return "list";
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.controller.focusGained(bFocusEvent);
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.controller.focusLost(bFocusEvent);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        this.controller.keyPressed(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        this.controller.keyReleased(bKeyEvent);
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        this.controller.keyTyped(bKeyEvent);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.controller.mousePressed(bMouseEvent);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.controller.mouseReleased(bMouseEvent);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.controller.mouseEntered(bMouseEvent);
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.controller.mouseExited(bMouseEvent);
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        this.controller.mouseMoved(bMouseEvent);
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        this.controller.mouseDragged(bMouseEvent);
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        this.controller.mousePulsed(bMouseEvent);
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
        this.controller.mouseWheel(bMouseWheelEvent);
    }

    public TransferEnvelope getTransferData() throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        throw new UnsupportedOperationException();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.item = new ListRenderer.Item();
    }

    public BList() {
        this(new DefaultListModel(), new ListController());
    }

    public BList(ListModel listModel) {
        this(listModel, new ListController());
    }

    public BList(ListController listController) {
        this(new DefaultListModel(), listController);
    }

    public BList(ListModel listModel, ListController listController) {
        this.this();
        this.setModel(listModel);
        this.setController(listController);
        this.setSelection(new ListSelection());
        this.setRenderer(new ListRenderer());
        this.linkTo(this.getVscrollBar(), (Slot)BScrollBar.positionChanged, (Slot)vscroll);
    }

    static {
        Class clazz = class$javax$baja$ui$list$BList;
        if (clazz == null) {
            clazz = class$javax$baja$ui$list$BList = BList.class("[Ljavax.baja.ui.list.BList;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
        icon = BIcon.std((String)"widgets/list.png");
    }

    public static abstract class ListSupport {
        BList list;

        public final BList getList() {
            return this.list;
        }

        public ListModel getModel() {
            return this.list.model;
        }

        public ListController getController() {
            return this.list.controller;
        }

        public ListRenderer getRenderer() {
            return this.list.renderer;
        }

        public ListSelection getSelection() {
            return this.list.selection;
        }

        public BWidgetShell getShell() {
            return this.list.getShell();
        }
    }
}

