/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.list;

import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListRenderer;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.list.ListSubject;
import javax.baja.ui.util.UiLexicon;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BCheckList
extends BList {
    static final BImage DEFAULT_SELECTED_ICON = BImage.make((String)"module://icons/x16/check.png");
    public static final Property selectedIcon = BCheckList.newProperty((int)0, (BValue)DEFAULT_SELECTED_ICON, null);
    public static final Property unselectedIcon = BCheckList.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Type TYPE;
    private double hgap;
    static /* synthetic */ Class class$javax$baja$ui$list$BCheckList;

    public BImage getSelectedIcon() {
        return (BImage)this.get(selectedIcon);
    }

    public void setSelectedIcon(BImage bImage) {
        this.set(selectedIcon, (BValue)bImage, null);
    }

    public BImage getUnselectedIcon() {
        return (BImage)this.get(unselectedIcon);
    }

    public void setUnselectedIcon(BImage bImage) {
        this.set(unselectedIcon, (BValue)bImage, null);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.hgap = 4;
    }

    public BCheckList() {
        this.this();
        this.setController(new CheckListController());
        this.setRenderer(new CheckListRenderer());
    }

    static {
        Class clazz = class$javax$baja$ui$list$BCheckList;
        if (clazz == null) {
            clazz = class$javax$baja$ui$list$BCheckList = BCheckList.class("[Ljavax.baja.ui.list.BCheckList;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    public static class CheckListController
    extends ListController {
        public void focusGained(BFocusEvent bFocusEvent) {
        }

        protected void itemPressed(BMouseEvent bMouseEvent, int n) {
            if (bMouseEvent.isPopupTrigger()) {
                this.itemPopup(bMouseEvent, n);
            }
        }

        protected void itemReleased(BMouseEvent bMouseEvent, int n) {
            if (bMouseEvent.isPopupTrigger()) {
                this.itemPopup(bMouseEvent, n);
            } else {
                ListSelection listSelection = this.list.getSelection();
                if (listSelection.isSelected(n)) {
                    listSelection.deselect(n);
                } else {
                    listSelection.select(n);
                }
            }
        }

        protected void backgroundPressed(BMouseEvent bMouseEvent) {
            if (bMouseEvent.isPopupTrigger()) {
                this.backgroundPopup(bMouseEvent);
            }
        }

        protected BMenu makePopup(ListSubject listSubject) {
            BMenu bMenu = new BMenu();
            bMenu.add(null, new SelectAllCommand(this.getList()));
            bMenu.add(null, new DeselectAllCommand(this.getList()));
            return bMenu;
        }
    }

    public static class CheckListRenderer
    extends ListRenderer {
        public BBrush getSelectionForeground(ListRenderer.Item item) {
            return this.getForeground(item);
        }

        public BBrush getSelectionBackground(ListRenderer.Item item) {
            return this.getBackground(item);
        }

        public double getPreferredItemWidth(ListRenderer.Item item) {
            BCheckList bCheckList = (BCheckList)this.getList();
            double d = super.getPreferredItemWidth(item) + Math.max(bCheckList.getSelectedIcon().getWidth(), bCheckList.getUnselectedIcon().getHeight()) + bCheckList.hgap;
            return d;
        }

        public void paintItem(Graphics graphics, ListRenderer.Item item) {
            BImage bImage;
            this.paintItemBackground(graphics, item);
            BCheckList bCheckList = (BCheckList)this.getList();
            double d = Math.max(bCheckList.getSelectedIcon().getWidth(), bCheckList.getUnselectedIcon().getWidth()) + bCheckList.hgap;
            graphics.translate(d, 0.0);
            super.paintItem(graphics, item);
            graphics.translate(-d, 0.0);
            BImage bImage2 = bImage = item.selected ? bCheckList.getSelectedIcon() : bCheckList.getUnselectedIcon();
            if (!bImage.isNull()) {
                graphics.drawImage(bImage, (double)2, 0.0);
            }
        }
    }

    public static class DeselectAllCommand
    extends Command {
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().deselectAll();
            return null;
        }

        DeselectAllCommand(BList bList) {
            super((BWidget)bList, UiLexicon.bajaui().module, "commands.deselectAll");
        }
    }

    public static class SelectAllCommand
    extends Command {
        public CommandArtifact doInvoke() {
            ((BList)this.getOwner()).getSelection().selectAll();
            return null;
        }

        SelectAllCommand(BList bList) {
            super((BWidget)bList, UiLexicon.bajaui().module, "commands.selectAll");
        }
    }
}

