/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.event;

import javax.baja.sys.BDouble;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BInputEvent;

public class BMouseEvent
extends BInputEvent {
    public static final int MOUSE_PRESSED = 501;
    public static final int MOUSE_RELEASED = 502;
    public static final int MOUSE_MOVED = 503;
    public static final int MOUSE_ENTERED = 504;
    public static final int MOUSE_EXITED = 505;
    public static final int MOUSE_DRAGGED = 506;
    public static final int MOUSE_WHEEL = 507;
    public static final int MOUSE_PULSED = 510;
    public static final int MOUSE_DRAG_STARTED = 511;
    public static final int MOUSE_HOVER = 512;
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$event$BMouseEvent == null ? (class$javax$baja$ui$event$BMouseEvent = BMouseEvent.class$("javax.baja.ui.event.BMouseEvent")) : class$javax$baja$ui$event$BMouseEvent));
    private double x;
    private double y;
    private int clickCount;
    private boolean isPopupTrigger;
    static /* synthetic */ Class class$javax$baja$ui$event$BMouseEvent;

    public Type getType() {
        return TYPE;
    }

    public BMouseEvent(int n, BWidget bWidget, int n2, double d, double d2, int n3, boolean bl) {
        super(n, bWidget, n2);
        this.x = d;
        this.y = d2;
        this.clickCount = n3;
        this.isPopupTrigger = bl;
    }

    public BMouseEvent(int n, BWidget bWidget, long l, int n2, double d, double d2, int n3, boolean bl) {
        super(n, bWidget, l, n2);
        this.x = d;
        this.y = d2;
        this.clickCount = n3;
        this.isPopupTrigger = bl;
    }

    public BMouseEvent() {
    }

    public boolean isButton1Down() {
        return (this.getModifiers() & 0x10) != 0;
    }

    public boolean isButton2Down() {
        return (this.getModifiers() & 8) != 0;
    }

    public boolean isButton3Down() {
        return (this.getModifiers() & 4) != 0;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public int getClickCount() {
        return this.clickCount;
    }

    public boolean isPopupTrigger() {
        return this.isPopupTrigger;
    }

    public String toString(Context context) {
        if (this.getWidget() == null) {
            return "null";
        }
        String string = "?";
        switch (this.getId()) {
            case 501: {
                string = "MousePressed";
                break;
            }
            case 502: {
                string = "MouseReleased";
                break;
            }
            case 503: {
                string = "MouseMoved";
                break;
            }
            case 504: {
                string = "MouseEntered";
                break;
            }
            case 505: {
                string = "MouseExited";
                break;
            }
            case 506: {
                string = "MouseDragged";
                break;
            }
            case 507: {
                string = "MouseWheel";
                break;
            }
            case 510: {
                string = "MousePulsed";
                break;
            }
            case 511: {
                string = "MouseDragStarted";
                break;
            }
            case 512: {
                string = "MouseHover";
            }
        }
        return string + " src=" + this.getWidget().getType() + " pt=" + BDouble.toString((double)this.x, null) + "," + BDouble.toString((double)this.y, null) + " mods=" + this.modifiersToString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

