/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.event;

import javax.baja.sys.Clock;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;

public abstract class BInputEvent
extends BWidgetEvent {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$event$BInputEvent == null ? (class$javax$baja$ui$event$BInputEvent = BInputEvent.class$("javax.baja.ui.event.BInputEvent")) : class$javax$baja$ui$event$BInputEvent));
    public static final int ALT_MASK = 8;
    public static final int ALT_GRAPH_MASK = 32;
    public static final int BUTTON1_MASK = 16;
    public static final int BUTTON2_MASK = 8;
    public static final int BUTTON3_MASK = 4;
    public static final int CTRL_MASK = 2;
    public static final int META_MASK = 4;
    public static final int SHIFT_MASK = 1;
    private int modifiers;
    private boolean consumed;
    private long when;
    static /* synthetic */ Class class$javax$baja$ui$event$BInputEvent;

    public Type getType() {
        return TYPE;
    }

    public BInputEvent(int n, BWidget bWidget, int n2) {
        super(n, bWidget);
        this.modifiers = n2;
        this.when = Clock.millis();
    }

    public BInputEvent(int n, BWidget bWidget, long l, int n2) {
        super(n, bWidget);
        this.modifiers = n2;
        this.when = l;
    }

    public BInputEvent() {
    }

    public int getModifiers() {
        return this.modifiers;
    }

    public long getWhen() {
        return this.when;
    }

    public boolean isAltDown() {
        return (this.modifiers & 8) != 0;
    }

    public boolean isAltGraphDown() {
        return (this.modifiers & 0x20) != 0;
    }

    public boolean isControlDown() {
        return (this.modifiers & 2) != 0;
    }

    public boolean isMetaDown() {
        return (this.modifiers & 4) != 0;
    }

    public boolean isShiftDown() {
        return (this.modifiers & 1) != 0;
    }

    public String modifiersToString() {
        String string = "";
        if (this.isAltDown()) {
            string = string + "Alt ";
        }
        if (this.isAltGraphDown()) {
            string = string + "AltGraph ";
        }
        if (this.isControlDown()) {
            string = string + "Ctrl ";
        }
        if (this.isMetaDown()) {
            string = string + "Meta ";
        }
        if (this.isShiftDown()) {
            string = string + "Shift ";
        }
        return string.trim();
    }

    public boolean isConsumed() {
        return this.consumed;
    }

    public void consume() {
        this.consumed = true;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

