/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.commands;

import java.util.HashMap;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFormat;
import javax.baja.util.BNameMap;

public class SetDisplayNameCommand
extends Command {
    private static final UiLexicon lex = UiLexicon.bajaui();
    private BComponent myComponent;

    public CommandArtifact doInvoke() throws Exception {
        String string;
        BComponent bComponent = (BComponent)this.myComponent.getParent();
        String string2 = "";
        BFormat bFormat = bComponent.getDisplayNameFormat(this.myComponent.getPropertyInParent());
        if (bFormat != null) {
            string2 = bFormat.getFormat();
        }
        if ((string = SetDisplayNameCommand.promptForNewDisplayName(this.getOwner(), (BIPropertyContainer)bComponent, string2)) == null) {
            return null;
        }
        DisplayNameArtifact displayNameArtifact = new DisplayNameArtifact(bComponent, this.myComponent.getPropertyInParent(), BFormat.make((String)string2), BFormat.make((String)string));
        displayNameArtifact.redo();
        return displayNameArtifact;
    }

    public static String promptForNewDisplayName(BWidget bWidget, BIPropertyContainer bIPropertyContainer, String string) {
        boolean bl = false;
        String string2 = string;
        String string3 = null;
        while (!bl) {
            string3 = BDialog.prompt(bWidget, lex.getText("commands.setDisplayName.prompt"), string2, 20);
            if (string3 == null) {
                return null;
            }
            if ((string3 = string3.trim()).equals(string)) {
                return null;
            }
            if (SetDisplayNameCommand.isDuplicateDisplayName(string3, bIPropertyContainer)) {
                int n = BDialog.confirm(bWidget, lex.getText("commands.setDisplayName.duplicate.title"), lex.getText("commands.setDisplayName.duplicate.confirm"), 3);
                if (n != 1) continue;
                bl = true;
                continue;
            }
            bl = true;
        }
        return string3;
    }

    private static final boolean isDuplicateDisplayName(String string, BIPropertyContainer bIPropertyContainer) {
        boolean bl = false;
        HashMap hashMap = new HashMap();
        BNameMap bNameMap = BNameMap.make(hashMap);
        BValue bValue = bIPropertyContainer.get("displayNames");
        if (bValue instanceof BNameMap) {
            bNameMap = (BNameMap)bValue;
        }
        Slot[] slotArray = bIPropertyContainer.getSlotsArray();
        int n = 0;
        while (n < slotArray.length) {
            Slot slot = slotArray[n];
            String string2 = slot.getName();
            BFormat bFormat = bNameMap.get(string2);
            if (bFormat != null) {
                if (string.equals(bFormat.getFormat())) {
                    bl = true;
                }
            } else if (string.equals(slot.getDefaultDisplayName(null))) {
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    protected Command doMerge(Command command) {
        return this;
    }

    public SetDisplayNameCommand(BWidget bWidget, BComponent bComponent) {
        super(bWidget, UiLexicon.bajaui().module, "commands.setDisplayName");
        this.myComponent = bComponent;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DisplayNameArtifact
    implements CommandArtifact {
        private BComponent parent;
        private Property property;
        private BFormat oldValue;
        private BFormat newValue;

        public void redo() {
            this.parent.setDisplayName(this.property, this.newValue, null);
        }

        public void undo() {
            this.parent.setDisplayName(this.property, this.oldValue, null);
        }

        public DisplayNameArtifact(BComponent bComponent, Property property, BFormat bFormat, BFormat bFormat2) {
            this.parent = bComponent;
            this.property = property;
            this.oldValue = bFormat;
            this.newValue = bFormat2;
        }
    }
}

