/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.commands;

import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;

public class CompoundCommand
extends Command {
    private Command[] commands;

    public CommandArtifact doInvoke() throws Exception {
        CommandArtifact[] commandArtifactArray = new CommandArtifact[this.commands.length];
        int n = 0;
        while (n < this.commands.length) {
            commandArtifactArray[n] = this.commands[n].doInvoke();
            ++n;
        }
        return new Artifact(commandArtifactArray);
    }

    public CompoundCommand(BWidget bWidget, String string, Command[] commandArray) {
        super(bWidget, string);
        this.commands = commandArray;
    }

    public static class Artifact
    implements CommandArtifact {
        private CommandArtifact[] artifacts;

        public void undo() throws Exception {
            int n = this.artifacts.length - 1;
            while (n >= 0) {
                if (this.artifacts[n] != null) {
                    this.artifacts[n].undo();
                }
                --n;
            }
        }

        public void redo() throws Exception {
            int n = 0;
            while (n < this.artifacts.length) {
                if (this.artifacts[n] != null) {
                    this.artifacts[n].redo();
                }
                ++n;
            }
        }

        public Artifact(CommandArtifact[] commandArtifactArray) {
            this.artifacts = commandArtifactArray;
        }
    }
}

