/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import java.util.Stack;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class UndoManager {
    protected final BWidget owner;
    private UndoCommand undoCommand;
    private RedoCommand redoCommand;
    private Stack undos = new Stack();
    private Stack redos = new Stack();
    private int maxArtifacts = 10;

    public UndoManager(BWidget bWidget) {
        if (bWidget == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = bWidget;
        this.undoCommand = new UndoCommand(bWidget);
        this.redoCommand = new RedoCommand(bWidget);
    }

    public int getMaxArtifacts() {
        return this.maxArtifacts;
    }

    public synchronized void setMaxArtifacts(int n) {
        if (this.undos.size() > n) {
            while (this.undos.size() > n) {
                this.undos.remove(0);
            }
            this.redos.clear();
        }
        this.maxArtifacts = n;
    }

    public Command getUndoCommand() {
        return this.undoCommand;
    }

    public Command getRedoCommand() {
        return this.redoCommand;
    }

    public synchronized void undo() {
        if (this.undos.size() == 0) {
            return;
        }
        CommandArtifact commandArtifact = (CommandArtifact)this.undos.pop();
        this.redos.push(commandArtifact);
        try {
            commandArtifact.undo();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = UiLexicon.bajaui().getText("dialog.error");
            String string2 = UiLexicon.bajaui().getText("undo.error");
            BDialog.error(this.owner, string, (Object)string2, throwable);
        }
        this.checkCommandEnables();
    }

    public synchronized void redo() {
        if (this.redos.size() == 0) {
            return;
        }
        CommandArtifact commandArtifact = (CommandArtifact)this.redos.pop();
        this.undos.push(commandArtifact);
        try {
            commandArtifact.redo();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            String string = UiLexicon.bajaui().getText("dialog.error");
            String string2 = UiLexicon.bajaui().getText("redo.error");
            BDialog.error(this.owner, string, (Object)string2, throwable);
        }
        this.checkCommandEnables();
    }

    public synchronized void addArtifact(CommandArtifact commandArtifact) {
        if (this.undos.size() > this.maxArtifacts) {
            this.undos.remove(0);
        }
        this.undos.add(commandArtifact);
        this.redos.clear();
        this.checkCommandEnables();
    }

    public synchronized void discardAllArtifacts() {
        this.undos.clear();
        this.redos.clear();
        this.checkCommandEnables();
    }

    private void checkCommandEnables() {
        this.undoCommand.setEnabled(this.undos.size() > 0);
        this.redoCommand.setEnabled(this.redos.size() > 0);
    }

    public static interface Scope {
        public UndoManager getInstalledUndoManager();

        public void setInstalledUndoManager(UndoManager var1);
    }

    class RedoCommand
    extends Command {
        RedoCommand(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "commands.redo");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            UndoManager.this.redo();
            return null;
        }
    }

    class UndoCommand
    extends Command {
        UndoCommand(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().module, "commands.undo");
            this.setEnabled(false);
        }

        public CommandArtifact doInvoke() {
            UndoManager.this.undo();
            return null;
        }
    }
}

