/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.util.ThrowableUtil;
import java.util.Properties;
import java.util.Vector;
import javax.baja.gx.BImage;
import javax.baja.sys.BModule;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.UndoManager;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;

public class Command {
    private String keyBase;
    protected String label;
    protected BImage icon;
    protected BAccelerator accelerator;
    protected String description;
    private final BWidget owner;
    private Vector registry = new Vector();
    private boolean enabled = true;

    public Command(BWidget bWidget, BModule bModule, String string) {
        this(bWidget, bModule.getLexicon(), string);
    }

    public Command(BWidget bWidget, Lexicon lexicon, String string) {
        if (bWidget == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = bWidget;
        this.keyBase = string;
        String string2 = lexicon.get(string + ".label");
        String string3 = lexicon.get(string + ".icon");
        String string4 = lexicon.get(string + ".accelerator");
        String string5 = lexicon.get(string + ".description");
        this.label = string2;
        if (string4 != null) {
            try {
                this.accelerator = BAccelerator.make(string4);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("Invalid accelerator for Command " + string);
                runtimeException.printStackTrace();
            }
        }
        this.description = string5;
        if (string3 != null) {
            this.icon = BImage.make((String)string3);
        }
    }

    public Command(BWidget bWidget, Properties properties, String string) {
        if (bWidget == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = bWidget;
        this.keyBase = string;
        String string2 = properties.getProperty(string + ".label");
        String string3 = properties.getProperty(string + ".icon");
        String string4 = properties.getProperty(string + ".accelerator");
        String string5 = properties.getProperty(string + ".description");
        this.label = string2;
        if (string4 != null) {
            try {
                this.accelerator = BAccelerator.make(string4);
            }
            catch (RuntimeException runtimeException) {
                System.out.println("Invalid accelerator for Command " + string);
                runtimeException.printStackTrace();
            }
        }
        this.description = string5;
        if (string3 != null) {
            this.icon = BImage.make((String)string3);
        }
    }

    public Command(BWidget bWidget, String string, BImage bImage, BAccelerator bAccelerator, String string2) {
        if (bWidget == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = bWidget;
        this.label = string;
        this.icon = bImage;
        this.accelerator = bAccelerator;
        this.description = string2;
    }

    public Command(BWidget bWidget, String string) {
        if (bWidget == null) {
            throw new NullPointerException("Null owner");
        }
        this.owner = bWidget;
        this.label = string;
    }

    public final BWidget getOwner() {
        return this.owner;
    }

    public final BWidgetShell getShell() {
        return this.owner.getShell();
    }

    public String getLabel() {
        return this.label;
    }

    public String getKeyBase() {
        return this.keyBase;
    }

    public BAccelerator getAccelerator() {
        return this.accelerator;
    }

    public BImage getIcon() {
        return this.icon;
    }

    public String getDescription() {
        return this.description;
    }

    public synchronized boolean isEnabled() {
        return this.enabled;
    }

    public synchronized void setEnabled(boolean bl) {
        if (this.enabled == bl) {
            return;
        }
        this.enabled = bl;
        for (int i = 0; i < this.registry.size(); ++i) {
            ((BWidget)this.registry.elementAt(i)).setEnabled(bl);
        }
    }

    public synchronized BWidget[] getRegistry() {
        Object[] objectArray = new BWidget[this.registry.size()];
        this.registry.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void register(BWidget bWidget) {
        this.registry.addElement(bWidget);
        bWidget.setEnabled(this.enabled);
    }

    public synchronized void unregister(BWidget bWidget) {
        this.registry.removeElement(bWidget);
    }

    public final void invoke() {
        this.invoke(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void invoke(CommandEvent commandEvent) {
        BWidgetShell bWidgetShell;
        boolean bl;
        if (commandEvent == null) {
            commandEvent = CommandEvent.NULL;
        }
        boolean bl2 = bl = (bWidgetShell = this.owner.getShell()) != null && this.isBusyForInvoke();
        if (bl) {
            bWidgetShell.enterBusy();
        }
        try {
            UndoManager undoManager;
            CommandArtifact commandArtifact = this.doInvoke(commandEvent);
            if (commandArtifact != null && this.owner != null && (undoManager = this.owner.getUndoManager()) != null) {
                undoManager.addArtifact(commandArtifact);
            }
        }
        catch (Throwable throwable) {
            ThrowableUtil.dump((Throwable)throwable);
            String string = UiLexicon.bajaui().getText("dialog.error");
            String string2 = UiLexicon.bajaui().getText("command.error", new Object[]{this.getLabel()});
            BDialog.error(this.owner, string, (Object)string2, throwable);
        }
        finally {
            if (bl) {
                bWidgetShell.exitBusy();
            }
        }
    }

    public CommandArtifact doInvoke(CommandEvent commandEvent) throws Exception {
        return this.doInvoke();
    }

    public CommandArtifact doInvoke() throws Exception {
        return null;
    }

    protected boolean isBusyForInvoke() {
        return true;
    }

    public Command merge(Command command) {
        if (this.getClass() == command.getClass() && this.owner == command.owner) {
            return this.doMerge(command);
        }
        return null;
    }

    protected Command doMerge(Command command) {
        return null;
    }

    public String toString() {
        return "Command: " + this.label;
    }
}

