/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.ShellManager;
import com.tridium.ui.UiEnv;
import javax.baja.agent.AgentList;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.Array;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BLayout;
import javax.baja.ui.BWidgetApplication;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BMouseWheelEvent;
import javax.baja.ui.style.IStylable;
import javax.baja.util.BTypeSpec;

public class BWidget
extends BComponent
implements IStylable {
    public static final Property visible = BWidget.newProperty((int)0, (boolean)true);
    public static final Property enabled = BWidget.newProperty((int)0, (boolean)true);
    public static final Property layout = BWidget.newProperty((int)0, (BValue)BLayout.DEFAULT);
    public static final Property styleClasses = BWidget.newProperty((int)4, (String)"");
    public static final Property styleId = BWidget.newProperty((int)4, (String)"");
    public static final Topic keyEvent = BWidget.newTopic((int)0);
    public static final Topic mouseEvent = BWidget.newTopic((int)0);
    public static final Topic focusEvent = BWidget.newTopic((int)0);
    private static final BIcon icon = BIcon.std((String)"widgets/widget.png");
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = BWidget.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget));
    static final BBinding[] noBindings;
    ShellManager shellManager;
    private double x;
    private double y;
    private double width;
    private double height;
    private double prefWidth;
    private double prefHeight;
    private boolean needsLayout = true;
    private boolean busy = false;
    private MouseCursor mouseCursor = MouseCursor.normal;
    private BBinding[] bindings = noBindings;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;

    public final boolean getVisible() {
        return this.getBoolean(visible);
    }

    public final void setVisible(boolean bl) {
        this.setBoolean(visible, bl, null);
    }

    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    public void setEnabled(boolean bl) {
        this.setBoolean(enabled, bl, null);
    }

    public final BLayout getLayout() {
        return (BLayout)this.get(layout);
    }

    public final void setLayout(BLayout bLayout) {
        this.set(layout, (BValue)bLayout, null);
    }

    public String getStyleClasses() {
        return this.getString(styleClasses);
    }

    public void setStyleClasses(String string) {
        this.setString(styleClasses, string);
    }

    public String getStyleId() {
        return this.getString(styleId);
    }

    public void setStyleId(String string) {
        this.setString(styleId, string);
    }

    public final boolean isWidget() {
        return true;
    }

    public boolean isNull() {
        return false;
    }

    public final BWidgetShell getShell() {
        if (this.shellManager == null) {
            return null;
        }
        return (BWidgetShell)this.shellManager.getShell();
    }

    public final ShellManager getShellManager() {
        if (this.shellManager == null) {
            return null;
        }
        return this.shellManager;
    }

    public final boolean isDesignTime() {
        if (this.shellManager == null) {
            return false;
        }
        return this.shellManager.isDesignTime();
    }

    public static BWidgetApplication getApplication() {
        return UiEnv.app;
    }

    public final BWidget getParentWidget() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BWidget) {
            return (BWidget)bComplex;
        }
        return null;
    }

    public final BWidget[] getChildWidgets() {
        return (BWidget[])this.getChildren(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = BWidget.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
    }

    public String getStyleSelector() {
        return "";
    }

    public MouseCursor getMouseCursor() {
        return this.mouseCursor;
    }

    public MouseCursor setMouseCursor(MouseCursor mouseCursor) {
        if (mouseCursor == null) {
            mouseCursor = MouseCursor.normal;
        }
        MouseCursor mouseCursor2 = this.mouseCursor;
        this.mouseCursor = mouseCursor;
        if (this.shellManager != null) {
            this.shellManager.updateMouseCursor();
        }
        return mouseCursor2;
    }

    public void enterBusy() {
        if (this.shellManager != null) {
            this.busy = true;
            this.shellManager.enterBusy(this);
        }
    }

    public void exitBusy() {
        this.busy = false;
        if (this.shellManager != null) {
            this.shellManager.exitBusy(this);
        }
    }

    public void changed(Property property, Context context) {
        this.repaint();
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 2: {
                this.fwChanged((Property)object, (Context)object2);
                break;
            }
            case 6: {
                this.relayout();
                break;
            }
            case 7: {
                this.fwParented((Property)object, (BValue)object2);
                break;
            }
            case 8: {
                this.fwUnparented((Property)object, (BValue)object2);
                break;
            }
            case 9: {
                this.fireInvokedOnBindings((Action)object, (BValue)object2, (Context)object3);
                break;
            }
            case 10: {
                this.fireFiredOnBindings((Topic)object, (BValue)object2, (Context)object3);
                break;
            }
            case 19: {
                return this.getOverride((Property)object);
            }
            case 301: {
                return this;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    void fwChanged(Property property, Context context) {
        if (property == enabled && this.shellManager != null) {
            this.shellManager.checkMouseOver();
        }
        this.fireChangedOnBindings(property, context);
    }

    void fwParented(Property property, BValue bValue) {
        if (this.shellManager != null && bValue instanceof BWidget) {
            BWidget bWidget = (BWidget)bValue;
            bWidget.initShell(this.shellManager);
        }
        if (bValue instanceof BBinding) {
            this.bindingAdd((BBinding)bValue);
        }
    }

    void fwUnparented(Property property, BValue bValue) {
        if (bValue instanceof BWidget) {
            BWidget bWidget = (BWidget)bValue;
            bWidget.cleanupShell();
            bWidget.needsLayout = false;
            this.relayout();
        }
        if (bValue instanceof BBinding) {
            this.bindingRemove((BBinding)bValue);
        }
    }

    void initShell(ShellManager shellManager) {
        if (this.shellManager == shellManager) {
            throw new IllegalStateException("Shell already initialized");
        }
        this.shellManager = shellManager;
        this.needsLayout = false;
        this.relayout();
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            bWidgetArray[i].initShell(shellManager);
        }
    }

    void cleanupShell() {
        if (this.shellManager != null && this.busy) {
            this.exitBusy();
        }
        this.busy = false;
        this.shellManager = null;
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            bWidgetArray[i].cleanupShell();
        }
    }

    public final BBinding[] getBindings() {
        if (this.bindings.length == 0) {
            return noBindings;
        }
        return (BBinding[])this.bindings.clone();
    }

    public final boolean hasBindings() {
        return this.bindings.length > 0;
    }

    public void bindingsChanged() {
    }

    private void bindingAdd(BBinding bBinding) {
        BBinding[] bBindingArray = new BBinding[this.bindings.length + 1];
        System.arraycopy(this.bindings, 0, bBindingArray, 0, this.bindings.length);
        bBindingArray[this.bindings.length] = bBinding;
        this.bindings = bBindingArray;
        try {
            this.bindingsChanged();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private void bindingRemove(BBinding bBinding) {
        if (this.bindings.length == 1 && this.bindings[0] == bBinding) {
            this.bindings = noBindings;
        } else {
            for (int i = 0; i < this.bindings.length; ++i) {
                if (this.bindings[i] != bBinding) continue;
                BBinding[] bBindingArray = new BBinding[this.bindings.length - 1];
                System.arraycopy(this.bindings, 0, bBindingArray, 0, i);
                if (i < this.bindings.length) {
                    System.arraycopy(this.bindings, i + 1, bBindingArray, i, this.bindings.length - i - 1);
                }
                this.bindings = bBindingArray;
                break;
            }
        }
        try {
            this.bindingsChanged();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public boolean isOverriddenByBinding(Property property) {
        return this.getOverride(property) != null;
    }

    private BValue getOverride(Property property) {
        BBinding[] bBindingArray = this.bindings;
        for (int i = 0; i < bBindingArray.length; ++i) {
            BValue bValue;
            if (!bBindingArray[i].isBound() || (bValue = bBindingArray[i].getOnWidget(property)) == null) continue;
            return bValue;
        }
        return null;
    }

    private void fireChangedOnBindings(Property property, Context context) {
        BBinding[] bBindingArray = this.bindings;
        for (int i = 0; i < bBindingArray.length; ++i) {
            try {
                bBindingArray[i].changedOnWidget(property, context);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void fireInvokedOnBindings(Action action, BValue bValue, Context context) {
        BBinding[] bBindingArray = this.bindings;
        for (int i = 0; i < bBindingArray.length; ++i) {
            try {
                boolean bl = bBindingArray[i].invokedOnWidget(action, bValue, context);
                if (!bl) continue;
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void fireFiredOnBindings(Topic topic, BValue bValue, Context context) {
        BBinding[] bBindingArray = this.bindings;
        for (int i = 0; i < bBindingArray.length; ++i) {
            try {
                boolean bl = bBindingArray[i].firedOnWidget(topic, bValue, context);
                if (!bl) continue;
                return;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    public BWidget childAt(Point point) {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = bWidgetArray.length - 1; i >= 0; --i) {
            BWidget bWidget = bWidgetArray[i];
            if (!bWidget.isVisible() || !bWidget.contains(point.x - bWidget.x, point.y - bWidget.y)) continue;
            return bWidget;
        }
        return null;
    }

    public final BWidget descendentAt(Point point) {
        BWidget bWidget = this.childAt(point);
        if (bWidget != null) {
            this.translateToChild(bWidget, point);
            BWidget bWidget2 = bWidget.descendentAt(point);
            return bWidget2 != null ? bWidget2 : bWidget;
        }
        return null;
    }

    public Point translateToChild(BWidget bWidget, Point point) {
        point.translate(-bWidget.x, -bWidget.y);
        return point;
    }

    public Point translateFromChild(BWidget bWidget, Point point) {
        double d = point.x;
        double d2 = point.y;
        this.translateToChild(bWidget, point);
        point.x = d - (point.x - d);
        point.y = d2 - (point.y - d2);
        return point;
    }

    public final Point translateFromAncestor(BWidget bWidget, Point point) {
        BWidget bWidget2;
        Array array = new Array(class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = BWidget.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget);
        if (bWidget != this) {
            for (bWidget2 = this; bWidget2 != null; bWidget2 = bWidget2.getParentWidget()) {
                array.add((Object)bWidget2);
                if (bWidget2 == bWidget) break;
            }
        }
        bWidget2 = null;
        BWidget bWidget3 = null;
        for (int i = array.size() - 1; i >= 0; --i) {
            bWidget2 = (BWidget)array.get(i);
            if (bWidget2 != null && bWidget3 != null) {
                bWidget3.translateToChild(bWidget2, point);
            }
            bWidget3 = bWidget2;
        }
        return point;
    }

    public final Point translateToAncestor(BWidget bWidget, Point point) {
        BWidget bWidget2 = this.getParentWidget();
        BWidget bWidget3 = this;
        while (bWidget3 != bWidget) {
            bWidget2.translateFromChild(bWidget3, point);
            bWidget3 = bWidget2;
            bWidget2 = bWidget2.getParentWidget();
        }
        return point;
    }

    public final Point translateToScreen(Point point) {
        return this.shellManager.translateToScreen(this, point);
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public final double getPreferredWidth() {
        return this.prefWidth;
    }

    public final double getPreferredHeight() {
        return this.prefHeight;
    }

    public boolean contains(double d, double d2) {
        return d >= 0.0 && d < this.width && d2 >= 0.0 && d2 < this.height;
    }

    public void setLocation(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public void setSize(double d, double d2) {
        if (this.width != d || this.height != d2) {
            this.width = d;
            this.height = d2;
            this.relayout();
        }
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        this.setLocation(d, d2);
        this.setSize(d3, d4);
    }

    public final void setPreferredSize(double d, double d2) {
        this.prefWidth = d;
        this.prefHeight = d2;
    }

    public final boolean needsLayout() {
        return this.needsLayout;
    }

    public final void relayout() {
        this.relayout(false);
    }

    public final void relayoutSync() {
        this.relayout(true);
    }

    private void relayout(boolean bl) {
        if (!this.needsLayout || bl) {
            this.needsLayout = true;
            BWidget bWidget = this.getParentWidget();
            if (bWidget != null) {
                bWidget.childCalledRelayout(this);
            }
            if (this.shellManager != null) {
                this.shellManager.relayout(this, bl);
            }
        } else if (this.needsLayout && this.shellManager != null && this.shellManager.enqueueRelayout(this)) {
            BWidget bWidget = this.getParentWidget();
            if (bWidget != null) {
                bWidget.childCalledRelayout(this);
            }
            this.shellManager.relayout(this, bl);
        }
    }

    public void childCalledRelayout(BWidget bWidget) {
        this.relayout();
    }

    public final void layout() {
        if (this.needsLayout) {
            if (this.width > 0.0 && this.height > 0.0) {
                BWidget[] bWidgetArray = this.getChildWidgets();
                try {
                    this.doLayout(bWidgetArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                for (int i = 0; i < bWidgetArray.length; ++i) {
                    bWidgetArray[i].layout();
                }
            }
            this.needsLayout = false;
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
    }

    public void computePreferredSize() {
        this.setPreferredSize(10.0, 10.0);
    }

    public void scrollToVisible(RectGeom rectGeom) {
        BWidget bWidget = this.getParentWidget();
        if (bWidget != null) {
            rectGeom.x += this.x;
            rectGeom.y += this.y;
            bWidget.scrollToVisible(rectGeom);
        }
    }

    public final boolean isVisible() {
        return this.getBoolean(visible);
    }

    public final boolean isEnabled() {
        return this.getBoolean(enabled);
    }

    public void repaint() {
        if (this.shellManager != null) {
            this.shellManager.repaint(this, 0, 0, (int)this.width, (int)this.height);
        }
    }

    public void repaint(double d, double d2, double d3, double d4) {
        if (this.shellManager != null) {
            this.shellManager.repaint(this, (int)d, (int)d2, (int)d3, (int)d4);
        }
    }

    public void paint(Graphics graphics) {
        this.paintChildren(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChildren(Graphics graphics) {
        IGeom iGeom = graphics.getClip();
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BWidget bWidget = bWidgetArray[i];
            if (!bWidget.isVisible() || !iGeom.intersects(bWidget.x, bWidget.y, bWidget.width, bWidget.height)) continue;
            graphics.push();
            try {
                graphics.clip(bWidget.x, bWidget.y, bWidget.width, bWidget.height);
                graphics.translate(bWidget.x, bWidget.y);
                bWidget.paint(graphics);
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                continue;
            }
            finally {
                graphics.pop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintChild(Graphics graphics, BWidget bWidget) {
        if (!bWidget.isVisible()) {
            return;
        }
        if (graphics.getClip().intersects(bWidget.x, bWidget.y, bWidget.width, bWidget.height)) {
            graphics.push();
            try {
                graphics.clip(bWidget.x, bWidget.y, bWidget.width, bWidget.height);
                graphics.translate(bWidget.x, bWidget.y);
                bWidget.paint(graphics);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                graphics.pop();
            }
        }
    }

    public void animate() {
        this.animateChildren();
    }

    public void animateChildren() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (!bWidgetArray[i].isVisible()) continue;
            bWidgetArray[i].animate();
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public final boolean hasFocus() {
        if (this.shellManager == null) {
            return false;
        }
        return this.shellManager.hasFocus(this);
    }

    public void requestFocus() {
        if (this.shellManager != null) {
            this.shellManager.requestFocus(this);
        }
    }

    public boolean receiveInputEvents() {
        return true;
    }

    public final void fireFocusEvent(BFocusEvent bFocusEvent) {
        switch (bFocusEvent.getId()) {
            case 1005: {
                this.focusLost(bFocusEvent);
                break;
            }
            case 1004: {
                this.focusGained(bFocusEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(focusEvent, (BValue)bFocusEvent, null);
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.scrollToVisible(new RectGeom(0.0, 0.0, this.width, this.height));
        this.repaint();
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.repaint();
    }

    public void fireMouseEvent(BMouseEvent bMouseEvent) {
        switch (bMouseEvent.getId()) {
            case 501: {
                this.mousePressed(bMouseEvent);
                break;
            }
            case 502: {
                this.mouseReleased(bMouseEvent);
                break;
            }
            case 504: {
                this.mouseEntered(bMouseEvent);
                break;
            }
            case 505: {
                this.mouseExited(bMouseEvent);
                break;
            }
            case 503: {
                this.mouseMoved(bMouseEvent);
                break;
            }
            case 506: {
                this.mouseDragged(bMouseEvent);
                break;
            }
            case 507: {
                this.mouseWheel((BMouseWheelEvent)bMouseEvent);
                break;
            }
            case 510: {
                this.mousePulsed(bMouseEvent);
                break;
            }
            case 511: {
                this.mouseDragStarted(bMouseEvent);
                break;
            }
            case 512: {
                this.mouseHover(bMouseEvent);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(mouseEvent, (BValue)bMouseEvent, null);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
    }

    public void mouseWheel(BMouseWheelEvent bMouseWheelEvent) {
    }

    public void mouseHover(BMouseEvent bMouseEvent) {
    }

    public void resetHover() {
        if (this.shellManager != null) {
            this.shellManager.resetHover(this);
        }
    }

    public void fireKeyEvent(BKeyEvent bKeyEvent) {
        switch (bKeyEvent.getId()) {
            case 401: {
                this.keyPressed(bKeyEvent);
                break;
            }
            case 402: {
                this.keyReleased(bKeyEvent);
                break;
            }
            case 400: {
                this.keyTyped(bKeyEvent);
            }
        }
        this.fire(keyEvent, (BValue)bKeyEvent, null);
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
    }

    public AgentList getAgents(Context context) {
        AgentList agentList = super.getAgents(context);
        agentList.toTop("bajaui:ValueBinding");
        return agentList;
    }

    public BIcon getIcon() {
        return icon;
    }

    public Object widgetSupport(Object object) {
        if (object != null) {
            this.initShell((ShellManager)object);
        }
        return this.shellManager;
    }

    public UndoManager getUndoManager() {
        BWidget bWidget = this;
        do {
            UndoManager undoManager;
            if (!(bWidget instanceof UndoManager.Scope) || (undoManager = ((UndoManager.Scope)((Object)bWidget)).getInstalledUndoManager()) == null) continue;
            return undoManager;
        } while ((bWidget = bWidget.getParentWidget()) != null);
        return null;
    }

    public static final void invokeLater(Runnable runnable) {
        UiEnv.get().invokeLater(runnable);
    }

    public String toDebugString() {
        return super.toDebugString() + "[" + this.getDebugString() + this.boundsToString() + "]";
    }

    public String getDebugString() {
        return "";
    }

    public String boundsToString() {
        return "" + this.x + ',' + this.y + ',' + this.width + ',' + this.height;
    }

    public String preferredSizeToString() {
        return "" + this.prefWidth + ',' + this.prefHeight;
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        try {
            Object object = UiEnv.appLock;
            synchronized (object) {
                if (Sys.getStation() == null && UiEnv.app == null) {
                    UiEnv.app = (BWidgetApplication)BTypeSpec.make((String)"workbench", (String)"WbApplication").getInstance();
                    UiEnv.app.start();
                }
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        noBindings = new BBinding[0];
    }
}

