/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import java.lang.reflect.Method;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BBinding;
import javax.baja.ui.BIHyperlinkShell;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BConverter;
import javax.baja.util.BFormat;

public class BValueBinding
extends BBinding {
    public static final Property hyperlink = BValueBinding.newProperty((int)0, (BValue)BOrd.NULL, null);
    public static final Property summary = BValueBinding.newProperty((int)0, (BValue)BFormat.make((String)"%displayName?typeDisplayName% = %.%"), null);
    public static final Property popupEnabled = BValueBinding.newProperty((int)0, (boolean)true, null);
    public static final Action updateStatus = BValueBinding.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BValueBinding == null ? (class$javax$baja$ui$BValueBinding = BValueBinding.class$("javax.baja.ui.BValueBinding")) : class$javax$baja$ui$BValueBinding));
    Clock.Ticket shellUpdateTicket;
    boolean isOver;
    MouseCursor restoreCursor;
    String toSummary = null;
    Exception lastGetOnWidgetException;
    static /* synthetic */ Class class$javax$baja$ui$BValueBinding;
    static /* synthetic */ Class class$javax$baja$ui$BWidget;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public BOrd getHyperlink() {
        return (BOrd)this.get(hyperlink);
    }

    public void setHyperlink(BOrd bOrd) {
        this.set(hyperlink, (BValue)bOrd, null);
    }

    public BFormat getSummary() {
        return (BFormat)this.get(summary);
    }

    public void setSummary(BFormat bFormat) {
        this.set(summary, (BValue)bFormat, null);
    }

    public boolean getPopupEnabled() {
        return this.getBoolean(popupEnabled);
    }

    public void setPopupEnabled(boolean bl) {
        this.setBoolean(popupEnabled, bl, null);
    }

    public void updateStatus() {
        this.invoke(updateStatus, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public void targetChanged() {
        super.targetChanged();
        this.toSummary = null;
    }

    public BValue getOnWidget(Property property) {
        block5: {
            BValue bValue = this.get(property.getName());
            if (bValue instanceof BConverter) {
                BConverter bConverter = (BConverter)bValue;
                try {
                    BComponent bComponent;
                    BObject bObject = this.get();
                    BValue bValue2 = property.getDefaultValue().newCopy();
                    OrdTarget ordTarget = this.getTarget();
                    if (null != ordTarget && null != (bComponent = ordTarget.getComponent())) {
                        BOrd bOrd = bComponent.getNavOrd();
                        bObject.fw(205, (Object)bOrd, null, null, null);
                    }
                    if ((bValue2 = bConverter.convert(bObject, (BObject)bValue2, (Context)this.getTarget())) instanceof BString) {
                        bValue2 = BString.make((String)TextUtil.replace((String)bValue2.toString(), (String)"\\n", (String)"\n"));
                    }
                    return bValue2;
                }
                catch (Exception exception) {
                    if (this.lastGetOnWidgetException != null && this.lastGetOnWidgetException.getClass() == exception.getClass()) break block5;
                    System.out.println("WARNING: " + bConverter.getType().getTypeName() + " cannot convert " + this.getWidget().getName() + "." + property.getName());
                    System.out.println("  " + exception);
                    this.lastGetOnWidgetException = exception;
                }
            }
        }
        return null;
    }

    public void changedOnWidget(Property property, Context context) {
    }

    public boolean invokedOnWidget(Action action, BValue bValue, Context context) {
        return super.invokedOnWidget(action, bValue, context);
    }

    public boolean firedOnWidget(Topic topic, BValue bValue, Context context) {
        if (bValue instanceof BMouseEvent) {
            return this.handleMouseEvent((BMouseEvent)bValue);
        }
        return super.firedOnWidget(topic, bValue, context);
    }

    public void doUpdateStatus() {
        if (!this.isOver) {
            if (this.shellUpdateTicket != null && !this.shellUpdateTicket.isExpired()) {
                this.shellUpdateTicket.cancel();
            }
            return;
        }
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            bWidgetShell.showStatus(this.toShowStatus());
        }
    }

    boolean handleMouseEvent(BMouseEvent bMouseEvent) {
        switch (bMouseEvent.getId()) {
            case 504: {
                return this.entered(bMouseEvent);
            }
            case 505: {
                return this.exited(bMouseEvent);
            }
            case 501: {
                return this.pressed(bMouseEvent);
            }
            case 502: {
                return this.released(bMouseEvent);
            }
        }
        return false;
    }

    boolean entered(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        this.isOver = true;
        if (this.shellUpdateTicket == null || this.shellUpdateTicket.isExpired()) {
            this.shellUpdateTicket = Clock.schedulePeriodically((BComponent)this, (BRelTime)BRelTime.makeSeconds((int)1), (Action)updateStatus, null);
        }
        if (bWidgetShell != null) {
            bWidgetShell.showStatus(this.toShowStatus());
            this.restoreCursor = !this.getHyperlink().isNull() && UiEnv.get().hasMouse() ? this.getWidget().setMouseCursor(MouseCursor.hand) : null;
        }
        return true;
    }

    boolean exited(BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        this.isOver = false;
        if (this.shellUpdateTicket != null && !this.shellUpdateTicket.isExpired()) {
            this.shellUpdateTicket.cancel();
        }
        if (bWidgetShell != null) {
            bWidgetShell.showStatus("");
        }
        if (this.restoreCursor != null) {
            this.getWidget().setMouseCursor(this.restoreCursor);
        }
        return true;
    }

    boolean pressed(BMouseEvent bMouseEvent) {
        BMenu bMenu;
        if (this.isPopupTrigger(bMouseEvent) && (bMenu = this.getMenu()) != null) {
            return this.popup(bMouseEvent, bMenu);
        }
        return false;
    }

    boolean released(BMouseEvent bMouseEvent) {
        BMenu bMenu;
        if (this.isPopupTrigger(bMouseEvent)) {
            bMenu = this.getMenu();
            if (bMenu != null) {
                return this.popup(bMouseEvent, bMenu);
            }
            if (UiEnv.get().hasMouse()) {
                return false;
            }
        }
        if (this.isOver && !this.getHyperlink().isNull()) {
            bMenu = this.getHyperlink();
            BWidgetShell bWidgetShell = this.getShell();
            if (bWidgetShell instanceof BIHyperlinkShell) {
                ((BIHyperlinkShell)((Object)bWidgetShell)).hyperlink(new HyperlinkInfo((BOrd)bMenu, bMouseEvent));
            }
            return true;
        }
        return false;
    }

    BMenu getMenu() {
        if (!this.getPopupEnabled()) {
            return null;
        }
        if (!this.isBound()) {
            return null;
        }
        OrdTarget ordTarget = this.getTarget();
        BComponent bComponent = ordTarget.getComponent();
        if (bComponent == null) {
            return null;
        }
        try {
            Class clazz = Sys.loadClass((String)"workbench", (String)"javax.baja.workbench.nav.menu.NavMenuUtil");
            Method method = clazz.getMethod("makeActionsMenu", class$javax$baja$ui$BWidget == null ? (class$javax$baja$ui$BWidget = BValueBinding.class$("javax.baja.ui.BWidget")) : class$javax$baja$ui$BWidget, class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BValueBinding.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
            BMenu bMenu = (BMenu)method.invoke(null, this.getWidget(), bComponent);
            return bMenu.isEnabled() ? bMenu : null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    boolean popup(BMouseEvent bMouseEvent, BMenu bMenu) {
        if (this.addLinkCommand()) {
            bMenu.add("hyperlink", new HyperlinkCommand(this.getWidget(), UiLexicon.bajaui.getText("hyperlinkTo"), this.getHyperlink()));
            bMenu.add("hyperlinkSep", (BValue)new BSeparator());
            bMenu.reorderToTop(bMenu.getProperty("hyperlinkSep"));
            bMenu.reorderToTop(bMenu.getProperty("hyperlink"));
        }
        bMenu.open(this.getWidget(), bMouseEvent.getX(), bMouseEvent.getY());
        return true;
    }

    boolean isPopupTrigger(BMouseEvent bMouseEvent) {
        BWidget bWidget = this.getWidget();
        boolean bl = bMouseEvent.isPopupTrigger();
        if (bWidget instanceof BAbstractButton) {
            return bl;
        }
        return bl || !UiEnv.get().hasMouse();
    }

    boolean addLinkCommand() {
        boolean bl = true;
        bl &= !UiEnv.get().hasMouse();
        bl &= !this.getHyperlink().isNull();
        return bl &= !(this.getWidget() instanceof BAbstractButton);
    }

    String toShowStatus() {
        String string = this.toSummary();
        BOrd bOrd = this.getHyperlink();
        if (bOrd.isNull()) {
            return string;
        }
        return "Link to " + bOrd + " | " + string;
    }

    String toSummary() {
        if (this.toSummary == null) {
            try {
                this.toSummary = this.isBound() ? this.getSummary().format((Object)this.get()) : "";
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.toSummary = "";
            }
        }
        return this.toSummary;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

