/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.Theme;
import javax.baja.data.BIDataValue;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BDropDown;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.SingleLineParser;

public class BTextField
extends BTextEditor {
    public static final Property visibleColumns = BTextField.newProperty((int)0, (int)20, (BFacets)BFacets.make((String)"min", (BIDataValue)BInteger.make((int)0)));
    public static final Property expandHeight = BTextField.newProperty((int)0, (boolean)false, null);
    public static final Topic actionPerformed = BTextField.newTopic((int)0, null);
    public static final Topic cancelled = BTextField.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BTextField == null ? (class$javax$baja$ui$BTextField = BTextField.class$("javax.baja.ui.BTextField")) : class$javax$baja$ui$BTextField));
    private static final BIcon icon = BIcon.std((String)"widgets/textField.png");
    private static BInsets dropDownInsets = BInsets.make((double)1.0, (double)1.0, (double)1.0, (double)1.0);
    private double scrollOffset;
    private boolean consumeActionKeyEvent;
    static /* synthetic */ Class class$javax$baja$ui$BTextField;

    public int getVisibleColumns() {
        return this.getInt(visibleColumns);
    }

    public void setVisibleColumns(int n) {
        this.setInt(visibleColumns, n, null);
    }

    public boolean getExpandHeight() {
        return this.getBoolean(expandHeight);
    }

    public void setExpandHeight(boolean bl) {
        this.setBoolean(expandHeight, bl, null);
    }

    public void fireActionPerformed(BWidgetEvent bWidgetEvent) {
        this.fire(actionPerformed, (BValue)bWidgetEvent, null);
    }

    public void fireCancelled(BWidgetEvent bWidgetEvent) {
        this.fire(cancelled, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BTextField(String string, int n, boolean bl) {
        super(string, bl);
        this.setVisibleColumns(n);
        this.initTextField();
    }

    public BTextField(String string, int n) {
        super(string, true);
        this.setVisibleColumns(n);
        this.initTextField();
    }

    public BTextField(String string) {
        super(string, true);
        this.initTextField();
    }

    public BTextField() {
        this.initTextField();
    }

    private void initTextField() {
        this.setParser(new SingleLineParser());
    }

    public boolean isSingleLine() {
        return true;
    }

    public void scrollToVisible(Position position) {
        BInsets bInsets = Theme.textField().getInsets();
        Line line = this.getRenderer().getModel().getLine(position.line);
        double d = this.getRenderer().getLineWidth(line, 0, position.column);
        double d2 = d - bInsets.left;
        int n = position.column > 0 ? 1 : 0;
        double d3 = this.getRenderer().getColumnWidth(line, position.column - n);
        double d4 = d2 + d3;
        double d5 = this.scrollOffset;
        double d6 = this.getWidth() - bInsets.left - bInsets.right;
        double d7 = d5 + d6;
        if (d7 < d4) {
            d5 += d4 - d7;
        }
        if (d5 > d2) {
            d5 = d2;
        }
        if (d5 < 0.0) {
            d5 = 0.0;
        }
        this.scrollOffset = d5;
        this.repaint();
    }

    public Position getPositionAt(double d, double d2) {
        return super.getPositionAt(d + this.scrollOffset, d2);
    }

    public void computePreferredSize() {
        double d = this.getRenderer().getLineHeight();
        double d2 = this.getRenderer().getColumnWidth(null, 0);
        BInsets bInsets = this.getInsets();
        double d3 = d2 * (double)this.getVisibleColumns() + bInsets.left + bInsets.right;
        double d4 = d + bInsets.top + bInsets.bottom;
        this.setPreferredSize(d3, d4);
    }

    protected BInsets getInsets() {
        if (this.getParent() instanceof BDropDown) {
            return dropDownInsets;
        }
        return Theme.textField().getInsets();
    }

    public void paint(Graphics graphics) {
        BInsets bInsets = this.getInsets();
        double d = this.getRenderer().getLineHeight() + bInsets.top + bInsets.bottom;
        double d2 = 0.0;
        if (this.getExpandHeight()) {
            graphics.setBrush(Theme.textField().getTextBackground(this));
            graphics.fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
            d2 = (this.getHeight() - d) / 2.0;
        }
        graphics.translate(-this.scrollOffset, d2);
        super.paint(graphics);
        graphics.translate(this.scrollOffset, -d2);
        if (!(this.getParent() instanceof BDropDown)) {
            this.paintBorder(graphics);
        }
    }

    protected void paintBorder(Graphics graphics) {
        double d = this.getHeight();
        if (!this.getExpandHeight()) {
            BInsets bInsets = this.getInsets();
            d = this.getRenderer().getLineHeight() + bInsets.top + bInsets.bottom;
        }
        Theme.textField().paintBorder(graphics, this, this.getWidth(), d);
    }

    public void setConsumeActionKeyEvent(boolean bl) {
        this.consumeActionKeyEvent = bl;
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() != 10 && bKeyEvent.getKeyCode() != 27) {
            if (bKeyEvent.getKeyCode() == 40) {
                BComplex bComplex = this.getParent();
                if (bComplex instanceof BTextDropDown) {
                    ((BTextDropDown)bComplex).openDropDown();
                }
            } else {
                super.keyPressed(bKeyEvent);
            }
        }
    }

    public void keyTyped(BKeyEvent bKeyEvent) {
        char c = bKeyEvent.getKeyChar();
        if (c == '\n' || c == '\r') {
            return;
        }
        if (bKeyEvent.getKeyCode() == 27) {
            return;
        }
        super.keyTyped(bKeyEvent);
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getKeyCode() == 10) {
            this.fireActionPerformed(new BWidgetEvent(2, this));
            if (this.consumeActionKeyEvent) {
                bKeyEvent.consume();
            }
        } else if (bKeyEvent.getKeyCode() == 27) {
            this.fireCancelled(new BWidgetEvent(2, this));
            if (this.consumeActionKeyEvent) {
                bKeyEvent.consume();
            }
        }
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

