/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.SpinnerButtonTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;

public class BSpinnerButton
extends BWidget {
    public static final Action handleUpMouseEvent = BSpinnerButton.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Action handleDownMouseEvent = BSpinnerButton.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Topic increment = BSpinnerButton.newTopic((int)0, null);
    public static final Topic decrement = BSpinnerButton.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BSpinnerButton == null ? (class$javax$baja$ui$BSpinnerButton = BSpinnerButton.class$("javax.baja.ui.BSpinnerButton")) : class$javax$baja$ui$BSpinnerButton));
    BButton up = new BButton();
    BButton down;
    boolean mUpInside = false;
    boolean mUpPressed = false;
    boolean mDownInside = false;
    boolean mDownPressed = false;
    long lastDownPulse = 0L;
    long lastUpPulse = 0L;
    static final long MIN_PULSE_ELAPSED = 250L;
    static /* synthetic */ Class class$javax$baja$ui$BSpinnerButton;

    public void handleUpMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(handleUpMouseEvent, (BValue)bMouseEvent, null);
    }

    public void handleDownMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(handleDownMouseEvent, (BValue)bMouseEvent, null);
    }

    public void fireIncrement(BWidgetEvent bWidgetEvent) {
        this.fire(increment, (BValue)bWidgetEvent, null);
    }

    public void fireDecrement(BWidgetEvent bWidgetEvent) {
        this.fire(decrement, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSpinnerButton() {
        this.up.setFocusTraversable(false);
        this.add("up", (BValue)this.up);
        this.down = new BButton();
        this.down.setFocusTraversable(false);
        this.add("down", (BValue)this.down);
        this.linkTo(this.up, (Slot)BButton.mouseEvent, (Slot)handleUpMouseEvent);
        this.linkTo(this.down, (Slot)BButton.mouseEvent, (Slot)handleDownMouseEvent);
    }

    public void doHandleUpMouseEvent(BMouseEvent bMouseEvent) {
        switch (bMouseEvent.getId()) {
            case 504: {
                this.mUpInside = true;
                break;
            }
            case 505: {
                this.mUpInside = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 501: {
                this.mUpPressed = true;
                break;
            }
            case 502: {
                this.mUpPressed = false;
                this.lastUpPulse = 0L;
                break;
            }
            case 510: {
                long l;
                if (!this.mUpInside || (l = Clock.ticks()) - this.lastUpPulse <= 250L) break;
                this.fireIncrement(bMouseEvent);
                this.lastUpPulse = l;
            }
        }
    }

    public void doHandleDownMouseEvent(BMouseEvent bMouseEvent) {
        switch (bMouseEvent.getId()) {
            case 504: {
                this.mDownInside = true;
                break;
            }
            case 505: {
                this.mDownInside = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 501: {
                this.mDownPressed = true;
                break;
            }
            case 502: {
                this.mDownPressed = false;
                this.lastDownPulse = 0L;
                break;
            }
            case 510: {
                long l;
                if (!this.mDownInside || (l = Clock.ticks()) - this.lastDownPulse <= 250L) break;
                this.fireDecrement(bMouseEvent);
                this.lastDownPulse = l;
            }
        }
    }

    public void paint(Graphics graphics) {
        SpinnerButtonTheme spinnerButtonTheme = Theme.spinner();
        double d = this.getWidth();
        double d2 = this.getHeight();
        graphics.setBrush(spinnerButtonTheme.getControlShadow(this));
        graphics.strokeLine(0.0, 0.0, d - 1.0, 0.0);
        graphics.strokeLine(0.0, 0.0, 0.0, d2 - 1.0);
        graphics.setBrush(spinnerButtonTheme.getControlHighlight(this));
        graphics.strokeLine(d - 1.0, 1.0, d - 1.0, d2 - 1.0);
        graphics.strokeLine(1.0, d2 - 1.0, d - 1.0, d2 - 1.0);
        this.paintChild(graphics, this.up);
        this.paintChild(graphics, this.down);
        BBrush bBrush = spinnerButtonTheme.getControlForeground(this);
        graphics.setBrush(bBrush);
        spinnerButtonTheme.paintArrows(graphics, this.up, this.down, this.mUpInside && this.mUpPressed, this.mDownInside && this.mDownPressed);
    }

    public String getStyleSelector() {
        return "button spinner";
    }

    public void computePreferredSize() {
        this.setPreferredSize(this.getWidth(), this.getHeight());
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (Theme.spinner().isStacked()) {
            double d3 = d2 / 2.0;
            double d4 = d - 2.0;
            this.up.setBounds(1.0, 1.0, d4, d3);
            this.down.setBounds(1.0, d3, d4, d3);
        } else {
            double d5 = d2 - 2.0;
            double d6 = d / 2.0;
            this.up.setBounds(1.0, 1.0, d6, d5);
            this.down.setBounds(d6, 1.0, d6, d5);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

