/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.SliderTheme;
import com.tridium.ui.theme.Theme;
import java.text.NumberFormat;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BSliderEvent;

public class BSlider
extends BWidget {
    public static final Property min = BSlider.newProperty((int)0, (int)0, null);
    public static final Property max = BSlider.newProperty((int)0, (int)100, null);
    public static final Property increment = BSlider.newProperty((int)0, (int)1, null);
    public static final Property value = BSlider.newProperty((int)0, (int)50, null);
    public static final Property orientation = BSlider.newProperty((int)0, (BValue)BOrientation.horizontal, null);
    public static final Property trackBrush = BSlider.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Property thumbBrush = BSlider.newProperty((int)0, (BValue)BBrush.NULL, null);
    public static final Topic valueModified = BSlider.newTopic((int)0, null);
    public static final Topic actionPerformed = BSlider.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BSlider == null ? (class$javax$baja$ui$BSlider = BSlider.class$("javax.baja.ui.BSlider")) : class$javax$baja$ui$BSlider));
    private static final BIcon icon = BIcon.std((String)"widgets/slider.png");
    private double thumbPoint;
    private double viewSize;
    private double realSize;
    private RectGeom thumb = new RectGeom();
    private RectGeom track = new RectGeom();
    static /* synthetic */ Class class$javax$baja$ui$BSlider;

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double d) {
        this.setDouble(min, d, null);
    }

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double d) {
        this.setDouble(max, d, null);
    }

    public double getIncrement() {
        return this.getDouble(increment);
    }

    public void setIncrement(double d) {
        this.setDouble(increment, d, null);
    }

    public double getValue() {
        return this.getDouble(value);
    }

    public void setValue(double d) {
        this.setDouble(value, d, null);
    }

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation bOrientation) {
        this.set(orientation, (BValue)bOrientation, null);
    }

    public BBrush getTrackBrush() {
        return (BBrush)this.get(trackBrush);
    }

    public void setTrackBrush(BBrush bBrush) {
        this.set(trackBrush, (BValue)bBrush, null);
    }

    public BBrush getThumbBrush() {
        return (BBrush)this.get(thumbBrush);
    }

    public void setThumbBrush(BBrush bBrush) {
        this.set(thumbBrush, (BValue)bBrush, null);
    }

    public void fireValueModified(BSliderEvent bSliderEvent) {
        this.fire(valueModified, (BValue)bSliderEvent, null);
    }

    public void fireActionPerformed(BSliderEvent bSliderEvent) {
        this.fire(actionPerformed, (BValue)bSliderEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BSlider() {
    }

    public BSlider(double d, double d2) {
        this.setMin(d);
        this.setMax(d2);
        if (this.getValue() < d || this.getValue() > d2) {
            this.setValue((d2 + d) / 2.0);
        }
    }

    public BSlider(double d, double d2, double d3, double d4) {
        this.setMin(d);
        this.setMax(d2);
        this.setIncrement(d3);
        this.setValue(d4);
        if (this.getValue() < d || this.getValue() > d2) {
            this.setValue((d2 + d) / 2.0);
        }
    }

    public BSlider(BOrientation bOrientation, double d, double d2, double d3, double d4) {
        this.setOrientation(bOrientation);
        this.setMin(d);
        this.setMax(d2);
        this.setIncrement(d3);
        this.setValue(d4);
        if (this.getValue() < d || this.getValue() > d2) {
            this.setValue((d2 + d) / 2.0);
        }
    }

    public void computePreferredSize() {
        double d = Theme.slider().getFixedWidth(this);
        if (this.isHorizontal()) {
            this.setPreferredSize(100.0, d);
        } else {
            this.setPreferredSize(d, 100.0);
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.isHorizontal()) {
            this.layoutHorizontally();
        } else {
            this.layoutVertically();
        }
    }

    public void layoutHorizontally() {
        this.thumb.set(0.0, 0.0, Theme.slider().getThumbWidth(this), this.getHeight() - 1.0);
        this.track.set(this.thumb.width / 2.0, 4.0, this.getWidth() - this.thumb.width, 6.0);
        this.thumbPoint = (int)(this.thumb.width / 2.0 + 0.5);
        this.viewSize = this.getWidth() - this.thumb.width;
        this.realSize = this.getMax() - this.getMin();
    }

    public void layoutVertically() {
        this.thumb.set(0.0, 0.0, this.getWidth() - 1.0, Theme.slider().getThumbWidth(this));
        this.track.set(4.0, this.thumb.height / 2.0, 6.0, this.getHeight() - this.thumb.height);
        this.thumbPoint = (int)(this.thumb.height / 2.0 + 0.5);
        this.viewSize = this.getHeight() - this.thumb.height;
        this.realSize = this.getMax() - this.getMin();
    }

    public boolean isHorizontal() {
        return this.getOrientation() == BOrientation.horizontal;
    }

    public void paint(Graphics graphics) {
        double d = this.getValue();
        if (d < this.getMin()) {
            d = this.getMin();
        }
        if (d > this.getMax()) {
            d = this.getMax();
        }
        int n = (int)((d - this.getMin()) / this.realSize * this.viewSize);
        if (!this.isHorizontal()) {
            n = (int)(this.viewSize - (double)n);
        }
        if (this.isHorizontal()) {
            this.thumb.set((double)n, 0.0, this.thumb.width, this.thumb.height);
        } else {
            this.thumb.set(0.0, (double)n, this.thumb.width, this.thumb.height);
        }
        SliderTheme sliderTheme = Theme.slider();
        sliderTheme.paintTrack(graphics, this, this.track);
        sliderTheme.paintThumb(graphics, this, this.thumb);
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        double d = this.getValue();
        if (d < this.getMin()) {
            d = this.getMin();
        }
        if (d > this.getMax()) {
            d = this.getMax();
        }
        String string = this.valueToString(d);
        UiEnv.get().openBubbleHelp(this, bMouseEvent.getX(), bMouseEvent.getY() + 24.0, string);
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        UiEnv.get().closeBubbleHelp();
        this.fireActionPerformed(new BSliderEvent(602, this, this.getValue()));
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5 = d4 = this.isHorizontal() ? bMouseEvent.getX() - this.thumbPoint : this.getHeight() - bMouseEvent.getY() - this.thumbPoint;
        if (d4 < 0.0) {
            d4 = 0.0;
        }
        if (d4 > this.viewSize) {
            d4 = this.viewSize;
        }
        d2 = (d3 = (d2 = d4 / this.viewSize * this.realSize + this.getMin()) % (d = this.getIncrement())) > d / 2.0 ? d2 - d3 + d : (d2 -= d3);
        this.setValue(d2);
        this.fireValueModified(new BSliderEvent(602, this, this.getValue()));
        this.repaint();
        String string = this.valueToString(d2);
        UiEnv.get().updateBubbleHelp(this, bMouseEvent.getX(), bMouseEvent.getY() + 24.0, string);
    }

    private String valueToString(double d) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(3);
        return numberFormat.format(d);
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

