/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.ScrollBarTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BScrollEvent;

public class BScrollBar
extends BWidget {
    public static final Property orientation = BScrollBar.newProperty((int)0, (BValue)BOrientation.vertical, null);
    public static final Property min = BScrollBar.newProperty((int)0, (int)0, null);
    public static final Property max = BScrollBar.newProperty((int)0, (int)100, null);
    public static final Property position = BScrollBar.newProperty((int)0, (int)0, null);
    public static final Property extent = BScrollBar.newProperty((int)0, (int)10, null);
    public static final Property unitIncrement = BScrollBar.newProperty((int)0, (int)1, null);
    public static final Property blockIncrement = BScrollBar.newProperty((int)0, (int)10, null);
    public static final Property snapToUnitIncrement = BScrollBar.newProperty((int)0, (boolean)true, null);
    public static final Topic positionChanged = BScrollBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BScrollBar == null ? (class$javax$baja$ui$BScrollBar = BScrollBar.class$("javax.baja.ui.BScrollBar")) : class$javax$baja$ui$BScrollBar));
    private static final BIcon icon = BIcon.std((String)"widgets/scrollBar.png");
    private static final int SIZE = 13;
    private static final int UP = 0;
    private static final int DOWN = 1;
    private static final int LEFT = 2;
    private static final int RIGHT = 3;
    private static Context resetContext = new BasicContext();
    private static final int minThumbSize = 7;
    private RectGeom up = new RectGeom();
    private RectGeom down = new RectGeom();
    private RectGeom thumb = new RectGeom();
    private RectGeom track = new RectGeom();
    private double thumbGrab;
    private RectGeom inside;
    private RectGeom armed;
    private double thumbPosition;
    private double thumbPadding;
    static /* synthetic */ Class class$javax$baja$ui$BScrollBar;

    public BOrientation getOrientation() {
        return (BOrientation)this.get(orientation);
    }

    public void setOrientation(BOrientation bOrientation) {
        this.set(orientation, (BValue)bOrientation, null);
    }

    public int getMin() {
        return this.getInt(min);
    }

    public void setMin(int n) {
        this.setInt(min, n, null);
    }

    public int getMax() {
        return this.getInt(max);
    }

    public void setMax(int n) {
        this.setInt(max, n, null);
    }

    public int getPosition() {
        return this.getInt(position);
    }

    public void setPosition(int n) {
        this.setInt(position, n, null);
    }

    public int getExtent() {
        return this.getInt(extent);
    }

    public void setExtent(int n) {
        this.setInt(extent, n, null);
    }

    public int getUnitIncrement() {
        return this.getInt(unitIncrement);
    }

    public void setUnitIncrement(int n) {
        this.setInt(unitIncrement, n, null);
    }

    public int getBlockIncrement() {
        return this.getInt(blockIncrement);
    }

    public void setBlockIncrement(int n) {
        this.setInt(blockIncrement, n, null);
    }

    public boolean getSnapToUnitIncrement() {
        return this.getBoolean(snapToUnitIncrement);
    }

    public void setSnapToUnitIncrement(boolean bl) {
        this.setBoolean(snapToUnitIncrement, bl, null);
    }

    public void firePositionChanged(BScrollEvent bScrollEvent) {
        this.fire(positionChanged, (BValue)bScrollEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BScrollBar(BOrientation bOrientation, int n, int n2, boolean bl) {
        this.setOrientation(bOrientation);
        this.setUnitIncrement(n);
        this.setBlockIncrement(n2);
        this.setSnapToUnitIncrement(bl);
    }

    public BScrollBar(BOrientation bOrientation) {
        this.setOrientation(bOrientation);
    }

    public BScrollBar() {
    }

    public void changed(Property property, Context context) {
        super.changed(property, context);
        if (context == resetContext) {
            return;
        }
        if (property == orientation) {
            this.relayout();
        } else {
            this.resetPosition(this.getPosition(), 602);
        }
    }

    public double getThumbPosition() {
        return this.thumbPosition;
    }

    public void resetPosition(double d, int n) {
        double d2;
        double d3 = this.getMin();
        double d4 = this.getMax();
        double d5 = Math.max(d4, d3);
        double d6 = this.getExtent();
        if (d6 > d5) {
            d6 = d5;
        }
        if (d > (d2 = d4 - d6)) {
            d = d2;
        }
        if (d < d3) {
            d = d3;
        }
        this.thumbPosition = d;
        double d7 = d;
        if (this.getSnapToUnitIncrement()) {
            double d8 = this.getUnitIncrement();
            double d9 = Math.IEEEremainder(d7, d8);
            double d10 = d7 - d9;
            double d11 = d10 + d8;
            if (d9 != 0.0) {
                double d12 = d8 / 2.0;
                d7 = d9 > d12 ? d11 : d10;
            }
            if (d7 > d2) {
                d7 = d2;
            }
            if (d7 < d3) {
                d7 = d3;
            }
        }
        this.layoutThumb();
        if ((double)this.getPosition() != d7) {
            this.setInt(position, (int)d7, resetContext);
            this.firePositionChanged(new BScrollEvent(601, this, (int)d7, n));
        }
        this.repaint();
    }

    public void decrementByUnit() {
        int n = this.getPosition() - this.getUnitIncrement();
        if (n < this.getMin()) {
            n = this.getMin();
        }
        this.resetPosition(n, 2);
    }

    public void incrementByUnit() {
        int n = this.getPosition() + this.getUnitIncrement();
        if (n > this.getMax() - this.getExtent()) {
            n = this.getMax() - this.getExtent();
        }
        this.resetPosition(n, 1);
    }

    public void decrementByBlock() {
        int n = this.getPosition() - this.getBlockIncrement();
        if (n < this.getMin()) {
            n = this.getMin();
        }
        this.resetPosition(n, 3);
    }

    public void incrementByBlock() {
        int n = this.getPosition() + this.getBlockIncrement();
        if (n > this.getMax() - this.getExtent()) {
            n = this.getMax() - this.getExtent();
        }
        this.resetPosition(n, 4);
    }

    public void computePreferredSize() {
        double d = Theme.scrollBar().getFixedWidth();
        if (this.getOrientation() == BOrientation.horizontal) {
            this.setPreferredSize(100.0, d);
        } else {
            this.setPreferredSize(d, 100.0);
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.getOrientation() == BOrientation.horizontal) {
            this.layoutHorizontal();
        } else {
            this.layoutVertical();
        }
    }

    private void layoutHorizontal() {
        double d = Theme.scrollBar().getFixedWidth();
        double d2 = this.getWidth();
        double d3 = d;
        if (d2 < d * 2.0) {
            d3 = d2 / 2.0;
        }
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.width = d3;
        this.up.height = d;
        this.down.x = d2 - d3;
        this.down.y = 0.0;
        this.down.width = d3;
        this.down.height = d;
        this.track.x = d3;
        this.track.y = 0.0;
        this.track.width = d2 - d3 * 2.0;
        this.track.height = d;
        this.layoutThumb();
    }

    private void layoutVertical() {
        double d = Theme.scrollBar().getFixedWidth();
        double d2 = this.getHeight();
        double d3 = d;
        if (d2 < d * 2.0) {
            d3 = d2 / 2.0;
        }
        this.up.x = 0.0;
        this.up.y = 0.0;
        this.up.width = d;
        this.up.height = d3;
        this.down.x = 0.0;
        this.down.y = d2 - d3;
        this.down.width = d;
        this.down.height = d3;
        this.track.x = 0.0;
        this.track.y = d3;
        this.track.width = d;
        this.track.height = d2 - d3 * 2.0;
        this.layoutThumb();
    }

    private void layoutThumb() {
        double d = this.thumbPosition;
        double d2 = Theme.scrollBar().getFixedWidth();
        double d3 = this.getOrientation() == BOrientation.horizontal ? (double)((int)this.track.width) : (double)((int)this.track.height);
        double d4 = this.getMin();
        double d5 = this.getMax();
        double d6 = Math.abs(d5 - d4);
        double d7 = this.getExtent();
        if (d7 > d6) {
            d7 = d6;
        }
        if (d3 < d2) {
            this.thumb.width = 0.0;
            this.thumb.height = 0.0;
            return;
        }
        double d8 = (int)(d3 * d7 / d6) + 1;
        this.thumbPadding = 0.0;
        if (d8 < 7.0) {
            this.thumbPadding = 7.0 - d8;
            d8 = 7.0;
        }
        double d9 = (int)((d3 - this.thumbPadding) * (d - d4) / d6);
        if (this.getOrientation() == BOrientation.horizontal) {
            this.thumb.x = this.track.x + d9;
            this.thumb.y = 0.0;
            this.thumb.width = d8;
            this.thumb.height = d2;
        } else {
            this.thumb.x = 0.0;
            this.thumb.y = this.track.y + d9;
            this.thumb.width = d2;
            this.thumb.height = d8;
        }
    }

    private void dragThumb(double d, double d2) {
        double d3;
        double d4;
        boolean bl = false;
        if (this.getOrientation() == BOrientation.horizontal) {
            d4 = this.track.width;
            d3 = d - this.track.x - this.thumbGrab;
            if (d4 <= d3 + this.thumb.width) {
                d3 = d4 - this.thumb.width;
                bl = true;
            }
        } else {
            d4 = this.track.height;
            d3 = d2 - this.track.y - this.thumbGrab;
            if (d4 <= d3 + this.thumb.height) {
                d3 = d4 - this.thumb.height;
                bl = true;
            }
        }
        if (bl) {
            this.resetPosition(this.getMax() - this.getExtent(), 5);
        } else {
            double d5 = this.getMin();
            double d6 = this.getMax();
            double d7 = Math.abs(d6 - d5);
            double d8 = this.getExtent();
            double d9 = d5 + d7 / (d4 - this.thumbPadding) * d3;
            if (d9 < d5) {
                d9 = d5;
            }
            if (d9 > d6 - d8) {
                d9 = d6 - d8;
            }
            this.resetPosition(d9, 5);
        }
    }

    public void paint(Graphics graphics) {
        ScrollBarTheme scrollBarTheme = Theme.scrollBar();
        if (this.getOrientation() == BOrientation.horizontal) {
            scrollBarTheme.paintButton(graphics, this, this.up, 2, this.up == this.inside && this.up == this.armed);
            scrollBarTheme.paintButton(graphics, this, this.down, 3, this.down == this.inside && this.down == this.armed);
        } else {
            scrollBarTheme.paintButton(graphics, this, this.up, 0, this.up == this.inside && this.up == this.armed);
            scrollBarTheme.paintButton(graphics, this, this.down, 1, this.down == this.inside && this.down == this.armed);
        }
        scrollBarTheme.paintTrack(graphics, this, this.track);
        scrollBarTheme.paintThumb(graphics, this, this.thumb);
    }

    public String getStyleSelector() {
        return "scroll-bar";
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        this.armed = null;
        this.thumbGrab = -1.0;
        this.layoutThumb();
        this.repaint();
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        this.armed = this.buttonAt(bMouseEvent);
        if (this.armed == this.thumb) {
            this.thumbGrab = this.getOrientation() == BOrientation.horizontal ? (double)((int)(bMouseEvent.getX() - this.thumb.x)) : (double)((int)(bMouseEvent.getY() - this.thumb.y));
            this.repaint();
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.inside = this.buttonAt(bMouseEvent);
        this.repaint();
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.inside = this.buttonAt(bMouseEvent);
        this.repaint();
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        RectGeom rectGeom = this.inside;
        this.inside = this.buttonAt(bMouseEvent);
        if (rectGeom != this.inside) {
            this.repaint();
        }
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        RectGeom rectGeom = this.inside;
        this.inside = this.buttonAt(bMouseEvent);
        if (this.armed == this.thumb) {
            this.dragThumb(bMouseEvent.getX(), bMouseEvent.getY());
        } else if (rectGeom != this.inside) {
            this.repaint();
        }
    }

    public void mousePulsed(BMouseEvent bMouseEvent) {
        double d;
        if (this.armed == this.up && this.inside == this.up) {
            this.decrementByUnit();
            return;
        }
        if (this.armed == this.down && this.inside == this.down) {
            this.incrementByUnit();
            return;
        }
        double d2 = bMouseEvent.getX();
        if (this.track.contains(d2, d = bMouseEvent.getY()) && !this.thumb.contains(d2, d) && this.thumb.width > 0.0) {
            if (this.getOrientation() == BOrientation.horizontal) {
                if (d2 < this.thumb.x) {
                    this.decrementByBlock();
                } else if (d2 > this.thumb.x + this.thumb.width) {
                    this.incrementByBlock();
                }
            } else if (d < this.thumb.y) {
                this.decrementByBlock();
            } else if (d > this.thumb.y + this.thumb.height) {
                this.incrementByBlock();
            }
        }
    }

    private RectGeom buttonAt(BMouseEvent bMouseEvent) {
        double d;
        double d2 = bMouseEvent.getX();
        if (this.up.contains(d2, d = bMouseEvent.getY())) {
            return this.up;
        }
        if (this.down.contains(d2, d)) {
            return this.down;
        }
        if (this.thumb.contains(d2, d)) {
            return this.thumb;
        }
        return null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

