/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.ShellPeer;
import com.tridium.ui.UiEnv;
import com.tridium.ui.WindowPeer;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.Insets;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWindow;
import javax.baja.ui.MouseCursor;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWindowEvent;

public class BRoundedWindow
extends BWindow {
    public static final Action handleMouseEvent = BRoundedWindow.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BRoundedWindow == null ? (class$javax$baja$ui$BRoundedWindow = BRoundedWindow.class$("javax.baja.ui.BRoundedWindow")) : class$javax$baja$ui$BRoundedWindow));
    protected static final float DEFAULT_ARC_WIDTH = 10.0f;
    protected static final float DEFAULT_ARC_HEIGHT = 10.0f;
    private BWidget owner;
    protected float arcWidth = 10.0f;
    protected float arcHeight = 10.0f;
    private Point pressed;
    private BInsets dragInsets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
    static /* synthetic */ Class class$javax$baja$ui$BRoundedWindow;

    public void handleMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(handleMouseEvent, (BValue)bMouseEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BRoundedWindow(BWidget bWidget, BWidget bWidget2) {
        this(bWidget, bWidget2, 10.0f, 10.0f);
    }

    public BRoundedWindow(BWidget bWidget, BWidget bWidget2, float f, float f2) {
        super(UiEnv.get().makeRoundedWindowPeer(bWidget, f, f2));
        this.setContent(bWidget2);
        this.arcWidth = f;
        this.arcHeight = f2;
    }

    public BRoundedWindow(BWidget bWidget) {
        super(UiEnv.get().makeRoundedWindowPeer(bWidget, 10.0f, 10.0f));
    }

    public BRoundedWindow(BWidget bWidget, float f, float f2) {
        super(UiEnv.get().makeRoundedWindowPeer(bWidget, f, f2));
        this.arcWidth = f;
        this.arcHeight = f2;
    }

    public BRoundedWindow() {
        super(UiEnv.get().makeRoundedWindowPeer(null, 10.0f, 10.0f));
    }

    BRoundedWindow(WindowPeer windowPeer) {
        super(windowPeer);
    }

    public BWidget getOwner() {
        return this.owner;
    }

    public float getArcWidth() {
        return this.arcWidth;
    }

    public float getArcHeight() {
        return this.arcHeight;
    }

    public void handleEscape() {
        this.windowClosing(null);
    }

    public void setBoundsCenteredOnOwner() {
        try {
            ShellPeer shellPeer = this.getOwner().getShell().getShellPeer();
            this.setBoundsCenteredOn(shellPeer.getScreenBounds());
        }
        catch (RuntimeException runtimeException) {
            this.setBoundsCenteredOnScreen();
        }
    }

    public void setBoundsCenteredOn(IRectGeom iRectGeom) {
        Insets insets = UiEnv.get().getWindowInsets(this);
        this.computePreferredSize();
        double d = this.getPreferredWidth() + insets.left + insets.right;
        double d2 = this.getPreferredHeight() + insets.top + insets.bottom;
        double d3 = iRectGeom.x() + (iRectGeom.width() - d) / 2.0;
        double d4 = iRectGeom.y() + (iRectGeom.height() - d2) / 2.0;
        IRectGeom iRectGeom2 = UiEnv.get().getScreenBounds(this);
        double d5 = iRectGeom2.x();
        double d6 = iRectGeom2.y();
        double d7 = iRectGeom2.width();
        double d8 = iRectGeom2.height();
        if (d > d7) {
            d = d7;
        }
        if (d2 > d8) {
            d2 = d8;
        }
        if (d3 + d > d5 + d7) {
            d3 = d5 + d7 - d;
        }
        if (d4 + d2 > d6 + d8) {
            d4 = d8 - d2;
        }
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        if (d4 < d6) {
            d4 = d6;
        }
        this.setScreenBounds(d3, d4, d, d2);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.close();
    }

    public void mouseDragged(BMouseEvent bMouseEvent) {
        if (null == this.pressed) {
            return;
        }
        Point point = this.translateToScreen(new Point(bMouseEvent.getX(), bMouseEvent.getY()));
        RectGeom rectGeom = new RectGeom(point.x - this.pressed.x, point.y - this.pressed.y, this.getWidth(), this.getHeight());
        this.setScreenBounds(rectGeom.x(), rectGeom.y(), rectGeom.width(), rectGeom.height());
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        double d;
        double d2 = this.getWidth() - this.dragInsets.left - this.dragInsets.right;
        RectGeom rectGeom = new RectGeom(this.dragInsets.left, this.dragInsets.top, d2, d = this.getHeight() - this.dragInsets.top - this.dragInsets.bottom);
        if (rectGeom.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            this.pressed = new Point(bMouseEvent.getX(), bMouseEvent.getY());
            bMouseEvent.getWidget().setMouseCursor(MouseCursor.grabHand);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        bMouseEvent.getWidget().setMouseCursor(MouseCursor.normal);
    }

    public void doHandleMouseEvent(BMouseEvent bMouseEvent) {
        this.fireMouseEvent(bMouseEvent);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

