/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.commands.ReflectCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.util.UiLexicon;

public class BProgressDialog
extends BDialog {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BProgressDialog == null ? (class$javax$baja$ui$BProgressDialog = BProgressDialog.class$("javax.baja.ui.BProgressDialog")) : class$javax$baja$ui$BProgressDialog));
    final UiLexicon lex = UiLexicon.bajaui();
    Worker worker;
    BLabel icon;
    BLabel message = new BLabel("");
    BProgressBar progress = new BProgressBar();
    BButton button = new BButton(new ReflectCommand((BWidget)this, this.lex.getText("dialog.cancel"), "cancel"));
    static /* synthetic */ Class class$javax$baja$ui$BProgressDialog;

    public Type getType() {
        return TYPE;
    }

    public static void open(BWidget bWidget, String string, Worker worker, BImage bImage, int n, int n2) {
        BProgressDialog bProgressDialog = new BProgressDialog(bWidget, string, worker, bImage, n, n2);
        bProgressDialog.setBoundsCenteredOnOwner();
        worker.dialog = bProgressDialog;
        worker.start();
        bProgressDialog.open();
    }

    public static void open(BWidget bWidget, String string, Worker worker, BImage bImage) {
        BProgressDialog.open(bWidget, string, worker, bImage, 0, 100);
    }

    public static void open(BWidget bWidget, String string, Worker worker) {
        BProgressDialog.open(bWidget, string, worker, BImage.NULL, 0, 100);
    }

    private BProgressDialog(BWidget bWidget, String string, Worker worker, BImage bImage, double d, double d2) {
        super(bWidget, string, true);
        this.worker = worker;
        this.icon = new BLabel(bImage);
        this.message.setHalign(BHalign.left);
        this.progress.setMin(d);
        this.progress.setMax(d2);
        this.add("icon", (BValue)this.icon);
        this.add("message", (BValue)this.message);
        this.add("progress", (BValue)this.progress);
        this.add("button", (BValue)this.button);
    }

    public BProgressDialog() {
    }

    public BLabel getMessageLabel() {
        return this.message;
    }

    public BProgressBar getProgressBar() {
        return this.progress;
    }

    public void computePreferredSize() {
        this.icon.computePreferredSize();
        this.message.computePreferredSize();
        this.progress.computePreferredSize();
        this.button.computePreferredSize();
        double d = this.icon.getPreferredWidth();
        double d2 = this.icon.getPreferredHeight();
        double d3 = this.message.getPreferredWidth();
        double d4 = this.message.getPreferredHeight();
        double d5 = this.progress.getPreferredWidth();
        double d6 = this.progress.getPreferredHeight();
        double d7 = this.button.getPreferredWidth();
        double d8 = this.button.getPreferredHeight();
        if (d2 < 45.0) {
            d2 = 45.0;
        }
        if (d4 < 45.0) {
            d4 = 18.0;
        }
        d5 = 5.0 + d + 5.0 + d5 + 5.0;
        d6 = 5.0 + Math.max(d2, d4 + 5.0 + d6) + 5.0 + d8 + 5.0;
        this.setPreferredSize(d5, d6);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        this.computePreferredSize();
        double d3 = this.icon.getPreferredWidth();
        double d4 = this.icon.getPreferredHeight();
        double d5 = this.message.getPreferredWidth();
        double d6 = this.message.getPreferredHeight();
        double d7 = this.progress.getPreferredWidth();
        double d8 = this.progress.getPreferredHeight();
        double d9 = this.button.getPreferredWidth();
        double d10 = this.button.getPreferredHeight();
        if (d4 < 45.0) {
            d4 = 45.0;
        }
        if (d6 < 45.0) {
            d6 = 18.0;
        }
        double d11 = 5.0 + d3 + 5.0;
        double d12 = 5.0 + (d4 - (d6 + 5.0 + d8)) / 2.0;
        this.message.setBounds(d11, d12, d - d11 - 5.0, d6);
        this.progress.setBounds(d11, d12 + d6 + 5.0, d - d11 - 5.0, d8);
        this.icon.setBounds(5.0, 5.0, d3, d4);
        this.button.setBounds((d - d9) / 2.0, d2 - d10 - 5.0, d9, d10);
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        this.cancel();
    }

    public void cancel() {
        if (!this.worker.done) {
            this.worker.cancel();
        }
        this.close();
    }

    public void paint(Graphics graphics) {
        if (this.worker.done) {
            this.close();
        }
        super.paint(graphics);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class Worker
    extends Thread {
        BProgressDialog dialog;
        boolean done = false;

        public Worker() {
            super("ProgressDialog.Worker");
        }

        public BProgressDialog getDialog() {
            return this.dialog;
        }

        public final void run() {
            try {
                this.doRun();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                BDialog.error(this.dialog, "Worker failed", throwable);
            }
            this.done = true;
            this.dialog.repaint();
        }

        public final void cancel() {
            try {
                this.doCancel();
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            this.done = true;
            this.dialog.repaint();
        }

        public abstract void doRun() throws Exception;

        public abstract void doCancel() throws Exception;

        public void updateProgress(int n, String string) {
            this.updateProgress(string);
            this.updateProgress(n);
        }

        public void updateProgress(String string) {
            this.dialog.message.setText(string);
            this.dialog.message.relayout();
        }

        public void updateProgress(int n) {
            this.dialog.progress.setValue(n);
            this.dialog.repaint();
        }
    }
}

