/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.theme.Theme;
import java.text.DecimalFormat;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BWidgetEvent;

public class BProgressBar
extends BWidget {
    public static final Property min = BProgressBar.newProperty((int)0, (int)0, null);
    public static final Property max = BProgressBar.newProperty((int)0, (int)100, null);
    public static final Property textPattern = BProgressBar.newProperty((int)0, (String)"#%", null);
    public static final Property textFont = BProgressBar.newProperty((int)0, (BValue)BFont.NULL, null);
    public static final Property backgroundBrush = BProgressBar.newProperty((int)0, (BValue)BColor.white.toBrush(), null);
    public static final Property barBrush = BProgressBar.newProperty((int)0, (BValue)BColor.gray.toBrush(), null);
    public static final Property indeterminate = BProgressBar.newProperty((int)0, (boolean)false, null);
    public static final Topic valueChanged = BProgressBar.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BProgressBar == null ? (class$javax$baja$ui$BProgressBar = BProgressBar.class$("javax.baja.ui.BProgressBar")) : class$javax$baja$ui$BProgressBar));
    private double value;
    private int inOff = 0;
    static /* synthetic */ Class class$javax$baja$ui$BProgressBar;

    public double getMin() {
        return this.getDouble(min);
    }

    public void setMin(double d) {
        this.setDouble(min, d, null);
    }

    public double getMax() {
        return this.getDouble(max);
    }

    public void setMax(double d) {
        this.setDouble(max, d, null);
    }

    public String getTextPattern() {
        return this.getString(textPattern);
    }

    public void setTextPattern(String string) {
        this.setString(textPattern, string, null);
    }

    public BFont getTextFont() {
        return (BFont)this.get(textFont);
    }

    public void setTextFont(BFont bFont) {
        this.set(textFont, (BValue)bFont, null);
    }

    public BBrush getBackgroundBrush() {
        return (BBrush)this.get(backgroundBrush);
    }

    public void setBackgroundBrush(BBrush bBrush) {
        this.set(backgroundBrush, (BValue)bBrush, null);
    }

    public BBrush getBarBrush() {
        return (BBrush)this.get(barBrush);
    }

    public void setBarBrush(BBrush bBrush) {
        this.set(barBrush, (BValue)bBrush, null);
    }

    public boolean getIndeterminate() {
        return this.getBoolean(indeterminate);
    }

    public void setIndeterminate(boolean bl) {
        this.setBoolean(indeterminate, bl, null);
    }

    public void fireValueChanged(BWidgetEvent bWidgetEvent) {
        this.fire(valueChanged, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BProgressBar() {
    }

    public BProgressBar(double d, double d2) {
        this();
        this.setMin(d);
        this.setMax(d2);
    }

    public void computePreferredSize() {
        this.setPreferredSize(200.0, 20.0);
    }

    public void animate() {
        if (this.getIndeterminate()) {
            this.inOff += 4;
            if (this.inOff >= 16) {
                this.inOff = 0;
            }
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        int n = 0;
        BBrush bBrush = this.getBackgroundBrush();
        BBrush bBrush2 = this.getBarBrush();
        graphics.setBrush(bBrush);
        graphics.fillRect(0.0, 0.0, d, d2);
        if (this.getIndeterminate()) {
            graphics.setBrush(bBrush2);
            int n2 = -((int)(d2 + 16.0));
            while ((double)n2 < d) {
                int n3 = n2 + this.inOff;
                graphics.strokeLine((double)n3, d2, (double)n3 + d2, 0.0);
                graphics.strokeLine((double)(n3 + 1), d2, (double)n3 + d2 + 1.0, 0.0);
                graphics.strokeLine((double)(n3 + 2), d2, (double)n3 + d2 + 2.0, 0.0);
                graphics.strokeLine((double)(n3 + 3), d2, (double)n3 + d2 + 3.0, 0.0);
                graphics.strokeLine((double)(n3 + 4), d2, (double)n3 + d2 + 4.0, 0.0);
                graphics.strokeLine((double)(n3 + 5), d2, (double)n3 + d2 + 5.0, 0.0);
                graphics.strokeLine((double)(n3 + 6), d2, (double)n3 + d2 + 6.0, 0.0);
                graphics.strokeLine((double)(n3 + 7), d2, (double)n3 + d2 + 7.0, 0.0);
                graphics.strokeLine((double)(n3 + 8), d2, (double)n3 + d2 + 8.0, 0.0);
                n2 += 16;
            }
        } else {
            n = (int)(this.getPercentComplete() * d);
            graphics.setBrush(bBrush2);
            graphics.fillRect(0.0, 0.0, (double)n, d2);
        }
        graphics.setBrush(BColor.black);
        graphics.strokeRect(0.0, 0.0, d - 1.0, d2 - 1.0);
        if (this.getIndeterminate()) {
            return;
        }
        String string = this.getTextPattern();
        if (!string.equals("")) {
            DecimalFormat decimalFormat = new DecimalFormat(string);
            String string2 = decimalFormat.format(this.getPercentComplete());
            BFont bFont = this.getTextFont();
            if (bFont.isNull()) {
                bFont = Theme.label().getTextFont();
            }
            graphics.setFont(bFont);
            double d3 = bFont.getHeight();
            double d4 = bFont.getDescent();
            double d5 = bFont.width(string2);
            double d6 = (d - d5) / 2.0;
            double d7 = (d2 - d3) / 2.0;
            graphics.push();
            try {
                graphics.clip(0.0, 0.0, (double)n, d2);
                graphics.setBrush(bBrush);
                graphics.drawString(string2, d6, d7 + d3 - d4);
            }
            finally {
                graphics.pop();
            }
            graphics.push();
            try {
                graphics.clip((double)n, 0.0, d - (double)n, d2);
                graphics.setBrush(bBrush2);
                graphics.drawString(string2, d6, d7 + d3 - d4);
            }
            finally {
                graphics.pop();
            }
        }
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        if (d < this.getMin()) {
            d = this.getMin();
        } else if (d > this.getMax()) {
            d = this.getMax();
        }
        this.value = d;
        this.fireValueChanged(null);
        this.repaint();
    }

    public double getPercentComplete() {
        return (this.getValue() - this.getMin()) / (this.getMax() - this.getMin());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

