/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.ImagePeer;
import java.lang.reflect.Constructor;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.log.Log;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScaleMode;
import javax.baja.ui.enums.BValign;

public class BPicture
extends BWidget {
    public static final Property image = BPicture.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property scale = BPicture.newProperty((int)0, (BValue)BScaleMode.none, null);
    public static final Property halign = BPicture.newProperty((int)0, (BValue)BHalign.center, null);
    public static final Property valign = BPicture.newProperty((int)0, (BValue)BValign.center, null);
    public static final Property animate = BPicture.newProperty((int)0, (boolean)true, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BPicture == null ? (class$javax$baja$ui$BPicture = BPicture.class$("javax.baja.ui.BPicture")) : class$javax$baja$ui$BPicture));
    private static final BIcon icon = BIcon.std((String)"widgets/image.png");
    private static final Log LOG = Log.getLog((String)"bajaui");
    BTransform.Scale transScale;
    protected double dx;
    protected double dy;
    private boolean imageWasScaled = false;
    private BOrdList lastImageOrdList = null;
    protected IPictureImpl impl;
    static /* synthetic */ Class class$javax$baja$ui$BPicture;

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage bImage) {
        this.set(image, (BValue)bImage, null);
    }

    public BScaleMode getScale() {
        return (BScaleMode)this.get(scale);
    }

    public void setScale(BScaleMode bScaleMode) {
        this.set(scale, (BValue)bScaleMode, null);
    }

    public BHalign getHalign() {
        return (BHalign)this.get(halign);
    }

    public void setHalign(BHalign bHalign) {
        this.set(halign, (BValue)bHalign, null);
    }

    public BValign getValign() {
        return (BValign)this.get(valign);
    }

    public void setValign(BValign bValign) {
        this.set(valign, (BValue)bValign, null);
    }

    public boolean getAnimate() {
        return this.getBoolean(animate);
    }

    public void setAnimate(boolean bl) {
        this.setBoolean(animate, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPicture() {
        IPictureImpl iPictureImpl;
        try {
            Class<?> clazz = Class.forName("java.awt.Component");
            Constructor<?> constructor = Class.forName("javax.baja.ui.AwtPictureImpl").getConstructor(class$javax$baja$ui$BPicture == null ? (class$javax$baja$ui$BPicture = BPicture.class$("javax.baja.ui.BPicture")) : class$javax$baja$ui$BPicture);
            iPictureImpl = (IPictureImpl)constructor.newInstance(this);
        }
        catch (Throwable throwable) {
            iPictureImpl = null;
        }
        this.impl = iPictureImpl;
    }

    public void changed(Property property, Context context) {
        if (this.impl != null) {
            this.impl.resetPeer();
        }
        this.relayout();
        super.changed(property, context);
    }

    public void paint(Graphics graphics) {
        this.wipePreviousPeer();
        BImage bImage = this.getImage();
        if (bImage.isNull() || this.impl == null || !this.impl.ensurePeer().isLoaded() || !this.isImageReadyToScale()) {
            return;
        }
        if (!this.impl.paint(graphics)) {
            LOG.warning("cannot render " + bImage + " to graphics context " + graphics.getClass().getName());
        }
    }

    public void computePreferredSize() {
        BImage bImage = this.getImage();
        if (bImage.isNull() || !bImage.isLoaded()) {
            this.setPreferredSize(0.0, 0.0);
        } else {
            this.setPreferredSize(bImage.getWidth(), bImage.getHeight());
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (!this.wipePreviousPeer()) {
            BPicture.doScaleLayout(this);
        }
        if (this.impl != null) {
            this.impl.ensurePeer();
        }
    }

    public void animate() {
        if (!this.getAnimate()) {
            return;
        }
        BImage bImage = this.getImage();
        if (bImage.isNull() || this.impl == null || !this.impl.ensurePeer().isLoaded()) {
            return;
        }
        if (this.impl.ensurePeer().animate()) {
            this.impl.resetPeer();
            this.repaint();
        }
    }

    private boolean wipePreviousPeer() {
        BImage bImage = this.getImage();
        boolean bl = false;
        if (this.lastImageOrdList != null && !this.lastImageOrdList.equals((Object)bImage.getOrdList())) {
            bl = true;
        }
        this.lastImageOrdList = bImage.getOrdList();
        if (!this.imageWasScaled && this.isImageReadyToScale()) {
            bl = true;
        }
        if (bl && this.impl != null) {
            this.impl.resetPeer();
        }
        return bl;
    }

    public boolean isImageReadyToScale() {
        BImage bImage = this.getImage();
        return !bImage.isNull() && bImage.isLoaded() && this.getWidth() > 0.0 && this.getHeight() > 0.0;
    }

    static void doScaleLayout(BPicture bPicture) {
        BTransform.Scale scale;
        double d;
        double d2;
        BImage bImage = bPicture.getImage();
        bPicture.imageWasScaled = bPicture.isImageReadyToScale();
        if (!bPicture.imageWasScaled) {
            d2 = 0.0;
            d = 0.0;
            scale = null;
        } else {
            double d3 = bPicture.getWidth();
            double d4 = bPicture.getHeight();
            double d5 = bImage.getWidth();
            double d6 = bImage.getHeight();
            double d7 = 0.0;
            double d8 = 0.0;
            BHalign bHalign = bPicture.getHalign();
            BValign bValign = bPicture.getValign();
            BScaleMode bScaleMode = bPicture.getScale();
            switch (bScaleMode.getOrdinal()) {
                case 1: {
                    d7 = d3 / d5;
                    d8 = d4 / d6;
                    d = 0.0;
                    d2 = 0.0;
                    break;
                }
                case 2: {
                    d7 = d8 = Math.min(d3 / d5, d4 / d6);
                    if (d7 == d3 / d5) {
                        d2 = 0.0;
                        d = BPicture.doValign(bValign, d4, d6 * d7);
                        break;
                    }
                    d2 = BPicture.doHalign(bHalign, d3, d5 * d7);
                    d = 0.0;
                    break;
                }
                case 3: {
                    d7 = d3 / d5;
                    d8 = 1.0;
                    d2 = 0.0;
                    d = BPicture.doValign(bValign, d4, d6);
                    break;
                }
                case 4: {
                    d7 = 1.0;
                    d8 = d4 / d6;
                    d2 = BPicture.doHalign(bHalign, d3, d5);
                    d = 0.0;
                    break;
                }
                case 0: {
                    d2 = BPicture.doHalign(bHalign, d3, d5);
                    d = BPicture.doValign(bValign, d4, d6);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            d2 = Math.floor(d2);
            d = Math.floor(d);
            scale = bScaleMode.equals((Object)BScaleMode.none) ? null : new BTransform.Scale(d7, d8);
        }
        bPicture.dx = d2;
        bPicture.dy = d;
        bPicture.transScale = scale;
    }

    private static double doHalign(BHalign bHalign, double d, double d2) {
        if (bHalign == BHalign.left) {
            return 0.0;
        }
        if (bHalign == BHalign.center) {
            return (d - d2) / 2.0;
        }
        return d - d2 - 1.0;
    }

    private static double doValign(BValign bValign, double d, double d2) {
        if (bValign == BValign.top) {
            return 0.0;
        }
        if (bValign == BValign.center) {
            return (d - d2) / 2.0;
        }
        return d - d2 - 1.0;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface IPictureImpl {
        public void resetPeer();

        public ImagePeer ensurePeer();

        public boolean paint(Graphics var1);
    }
}

