/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.MenuItemTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAccelerator;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;

public abstract class BMenuItem
extends BWidget {
    public static final Property text = BMenuItem.newProperty((int)0, (String)"", null);
    public static final Property image = BMenuItem.newProperty((int)0, (BValue)BImage.NULL, null);
    public static final Property accelerator = BMenuItem.newProperty((int)0, (BValue)BAccelerator.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BMenuItem == null ? (class$javax$baja$ui$BMenuItem = BMenuItem.class$("javax.baja.ui.BMenuItem")) : class$javax$baja$ui$BMenuItem));
    private static final BIcon icon = BIcon.std((String)"widgets/menuItem.png");
    static Object timerLock = new Object();
    static Timer timer;
    static BMenuItem timed;
    char shortcut = '\u0000';
    double baseline;
    double textWidth;
    double acceleratorWidth;
    double acceleratorX;
    boolean showAccelerator;
    boolean isSelected;
    Command command;
    boolean isOver;
    static /* synthetic */ Class class$javax$baja$ui$BMenuItem;

    public String getText() {
        return this.getString(text);
    }

    public void setText(String string) {
        this.setString(text, string, null);
    }

    public BImage getImage() {
        return (BImage)this.get(image);
    }

    public void setImage(BImage bImage) {
        this.set(image, (BValue)bImage, null);
    }

    public BAccelerator getAccelerator() {
        return (BAccelerator)this.get(accelerator);
    }

    public void setAccelerator(BAccelerator bAccelerator) {
        this.set(accelerator, (BValue)bAccelerator, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMenuItem(String string, BAccelerator bAccelerator) {
        this.setText(string);
        this.setAccelerator(bAccelerator);
    }

    public BMenuItem(String string) {
        this.setText(string);
    }

    public BMenuItem(Command command) {
        this.setCommand(command);
    }

    public BMenuItem() {
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.setCommand(command, true, true, true);
    }

    public void setCommand(Command command, boolean bl, boolean bl2, boolean bl3) {
        Object object;
        if (this.command != null) {
            this.command.unregister(this);
        }
        if (command == null) {
            return;
        }
        if (bl) {
            object = command.getLabel();
            if (object == null) {
                object = "No label";
            }
            this.setText((String)object);
        }
        if (bl2 && (object = command.getIcon()) != null) {
            this.setImage((BImage)object);
        }
        if (bl3 && (object = command.getAccelerator()) != null && !((BAccelerator)((Object)object)).isNull()) {
            this.setAccelerator((BAccelerator)((Object)object));
        }
        this.command = command;
        command.register(this);
    }

    public void computePreferredSize() {
        BAccelerator bAccelerator = this.getAccelerator();
        BInsets bInsets = Theme.menuItem().getInsets();
        BFont bFont = Theme.menuItem().getTextFont();
        BFont bFont2 = Theme.menuItem().getAcceleratorFont();
        double d = Math.max(bFont.getHeight(), bFont2.getHeight());
        this.textWidth = bFont.width(this.getText());
        this.acceleratorWidth = 0.0;
        if (!bAccelerator.isNull()) {
            this.acceleratorWidth = bFont2.width(this.getAccelerator().toString());
        }
        double d2 = 0.0;
        double d3 = d + bInsets.top + bInsets.bottom;
        this.baseline = d3 - bFont.getDescent() - bInsets.bottom;
        this.setPreferredSize(d2, d3);
    }

    public void paint(Graphics graphics) {
        MenuItemTheme menuItemTheme = Theme.menuItem();
        BAccelerator bAccelerator = this.getAccelerator();
        BInsets bInsets = Theme.menuItem().getInsets();
        this.paintBackground(graphics, menuItemTheme);
        graphics.setFont(menuItemTheme.getTextFont());
        if (this.getEnabled()) {
            if (this.isSelected) {
                graphics.setBrush(menuItemTheme.getSelectionForeground(this));
            } else {
                graphics.setBrush(menuItemTheme.getTextBrush());
            }
            if (this.shortcut != '\u0000') {
                String string;
                double d = bInsets.left;
                int n = this.getText().toLowerCase().indexOf(Character.toLowerCase(this.shortcut));
                if (n > 0) {
                    string = this.getText().substring(0, n);
                    graphics.drawString(string, d, this.baseline);
                    d += graphics.getFont().width(string);
                }
                if (n > -1) {
                    string = this.getText().substring(n, n + 1);
                    BFont bFont = BFont.make((BFont)menuItemTheme.getTextFont(), (int)(menuItemTheme.getTextFont().getStyle() | 4));
                    graphics.setFont(bFont);
                    graphics.drawString(string, d, this.baseline);
                    d += bFont.width(string);
                }
                if (n < this.getText().length()) {
                    string = this.getText().substring(n + 1, this.getText().length());
                    graphics.setFont(menuItemTheme.getTextFont());
                    graphics.drawString(string, d, this.baseline);
                }
            } else {
                graphics.drawString(this.getText(), bInsets.left, this.baseline);
            }
        } else {
            menuItemTheme.paintDisabledText(graphics, this, this.getText(), bInsets.left, this.baseline);
        }
        if (this.showAccelerator && !bAccelerator.isNull()) {
            graphics.setFont(menuItemTheme.getAcceleratorFont());
            if (this.getEnabled()) {
                if (this.isSelected) {
                    graphics.setBrush(menuItemTheme.getSelectionForeground());
                } else {
                    graphics.setBrush(menuItemTheme.getAcceleratorBrush());
                }
                graphics.drawString(bAccelerator.toString(), this.acceleratorX, this.baseline);
            } else {
                menuItemTheme.paintDisabledText(graphics, this, bAccelerator.toString(), this.acceleratorX, this.baseline);
            }
        }
        this.paintImage(graphics);
    }

    void paintImage(Graphics graphics) {
        BImage bImage = this.getImage();
        if (!bImage.isNull()) {
            if (!this.isEnabled()) {
                bImage = bImage.getDisabledImage();
            }
            BInsets bInsets = Theme.menuItem().getInsets();
            graphics.drawImage(bImage, Theme.menuItem().getIconIndent(), bInsets.top);
        }
    }

    public String getStyleSelector() {
        return "menu-item";
    }

    public BWidget childAt(Point point) {
        return null;
    }

    void opening(BMenu bMenu, boolean bl) {
        this.isSelected = false;
        this.showAccelerator = bl;
    }

    void select() {
        this.isSelected = true;
        this.repaint();
    }

    void unselect() {
        this.isSelected = false;
        this.repaint();
    }

    void doClick(BInputEvent bInputEvent) {
    }

    void timerExpired() {
        if (this.isOver) {
            this.closeSiblings();
        }
    }

    void closeSiblings() {
        BMenuItem.stopTimer();
        SlotCursor slotCursor = ((BMenu)this.getParent()).getProperties();
        while (slotCursor.nextComponent()) {
            BObject bObject = slotCursor.get();
            if (bObject == this || !(bObject instanceof BSubMenuItem)) continue;
            ((BSubMenuItem)bObject).closeMenu();
        }
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        ((BMenu)this.getParent()).select(this);
        this.isOver = true;
        this.startTimer();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        ((BMenu)this.getParent()).unselect(this);
        this.isOver = false;
        this.startTimer();
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        UiEnv.get().closePopup(null);
        if (this.contains(bMouseEvent.getX(), bMouseEvent.getY())) {
            this.doClick(bMouseEvent);
        }
    }

    void paintBackground(Graphics graphics, MenuItemTheme menuItemTheme) {
        menuItemTheme.paintBackground(graphics, this, this.isSelected);
    }

    public BIcon getIcon() {
        return icon;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startTimer() {
        Object object = timerLock;
        synchronized (object) {
            BMenuItem.stopTimer();
            timed = this;
            timer = new Timer();
            timer.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void stopTimer() {
        Object object = timerLock;
        synchronized (object) {
            timed = null;
            if (timer != null) {
                timer.kill();
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class TimerInvoker
    implements Runnable {
        BMenuItem item;

        TimerInvoker(BMenuItem bMenuItem) {
            this.item = bMenuItem;
        }

        public void run() {
            this.item.timerExpired();
        }
    }

    static class Timer
    extends Thread {
        boolean dead;

        public Timer() {
            super("Ui:MenuItemTimer");
        }

        public void kill() {
            this.dead = true;
            this.interrupt();
        }

        public void run() {
            try {
                BMenuItem bMenuItem;
                Timer.sleep(200L);
                if (!this.dead && (bMenuItem = timed) != null) {
                    UiEnv.get().invokeLater(new TimerInvoker(bMenuItem));
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

