/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.ShellManager;
import com.tridium.ui.theme.MenuBarTheme;
import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractBar;
import javax.baja.ui.BMenu;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public class BMenuBar
extends BAbstractBar
implements BMenu.MenuCloseListener {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BMenuBar == null ? (class$javax$baja$ui$BMenuBar = BMenuBar.class$("javax.baja.ui.BMenuBar")) : class$javax$baja$ui$BMenuBar));
    private static final BIcon icon = BIcon.std((String)"widgets/menuBar.png");
    static double itemGap = 4.0;
    private boolean mouseOver = false;
    private double ty;
    private BMenu over;
    private BMenu open;
    static /* synthetic */ Class class$javax$baja$ui$BMenuBar;
    static /* synthetic */ Class class$javax$baja$ui$BMenu;
    static /* synthetic */ Class class$javax$baja$ui$BMenuItem;

    public Type getType() {
        return TYPE;
    }

    public BMenu[] getMenus() {
        return (BMenu[])this.getChildren(class$javax$baja$ui$BMenu == null ? (class$javax$baja$ui$BMenu = BMenuBar.class$("javax.baja.ui.BMenu")) : class$javax$baja$ui$BMenu);
    }

    public void computePreferredSize() {
        MenuBarTheme menuBarTheme = Theme.menuBar();
        BInsets bInsets = menuBarTheme.getBarInsets();
        BInsets bInsets2 = menuBarTheme.getItemInsets();
        BFont bFont = menuBarTheme.getItemFont(this);
        double d = bInsets.left + itemGap;
        double d2 = bInsets.top;
        double d3 = 0.0;
        double d4 = bFont.getHeight() + bInsets2.top + bInsets2.bottom;
        this.ty = bInsets.top + bInsets2.top + bFont.getHeight() - bFont.getDescent();
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BMenu bMenu = (BMenu)bWidgetArray[i];
            d3 = bFont.width(bMenu.getText()) + bInsets2.left + bInsets2.right;
            bMenu.menuBarRect = new RectGeom(d, d2, d3, d4);
            d += d3 + itemGap;
        }
        this.setPreferredSize(d + d3 + bInsets.right, d2 + d4 + bInsets.top);
    }

    public void doLayout(BWidget[] bWidgetArray) {
        this.computePreferredSize();
    }

    public BWidget childAt(Point point) {
        return null;
    }

    public void paint(Graphics graphics) {
        MenuBarTheme menuBarTheme = Theme.menuBar();
        BInsets bInsets = menuBarTheme.getItemInsets();
        menuBarTheme.paintBackground(graphics, this);
        this.computeShortcutKeys();
        BMenu[] bMenuArray = (BMenu[])this.getChildren(class$javax$baja$ui$BMenu == null ? (class$javax$baja$ui$BMenu = BMenuBar.class$("javax.baja.ui.BMenu")) : class$javax$baja$ui$BMenu);
        graphics.setFont(menuBarTheme.getTextFont(this));
        for (int i = 0; i < bMenuArray.length; ++i) {
            String string;
            BMenu bMenu = bMenuArray[i];
            String string2 = bMenu.getText();
            double d = bMenu.menuBarRect.x + bInsets.right;
            int n = 0;
            if (bMenu == this.open) {
                n = 2;
            } else if (!(this.open != null && this.open.isOpen() || !this.hasFocus() && !this.mouseOver || bMenu != this.over)) {
                n = 1;
            }
            menuBarTheme.paintItemBackground(graphics, this, bMenu.menuBarRect, n);
            graphics.setBrush(menuBarTheme.getItemTextBrush(n, this));
            Point point = menuBarTheme.getItemTextOffset(n);
            if (!this.hasFocus()) {
                graphics.drawString(string2, d + point.x, this.ty + point.y);
                continue;
            }
            double d2 = d + point.x;
            int n2 = string2.toLowerCase().indexOf(Character.toLowerCase(bMenuArray[i].shortcut));
            if (n2 > 0) {
                string = string2.substring(0, n2);
                graphics.drawString(string, d2, this.ty + point.y);
                d2 += graphics.getFont().width(string);
            }
            if (n2 > -1) {
                string = string2.substring(n2, n2 + 1);
                BFont bFont = BFont.make((BFont)menuBarTheme.getTextFont(), (int)(menuBarTheme.getTextFont().getStyle() | 4));
                graphics.setFont(bFont);
                graphics.drawString(string, d2, this.ty + point.y);
                d2 += bFont.width(string);
            }
            if (n2 >= string2.length()) continue;
            string = string2.substring(n2 + 1, string2.length());
            graphics.setFont(menuBarTheme.getTextFont());
            graphics.drawString(string, d2, this.ty + point.y);
        }
    }

    public String getStyleSelector() {
        return "menu-bar";
    }

    private void computeShortcutKeys() {
        if (this.hasFocus()) {
            int n;
            int n2;
            Object object;
            int n3;
            BMenu[] bMenuArray = (BMenu[])this.getChildren(class$javax$baja$ui$BMenu == null ? (class$javax$baja$ui$BMenu = BMenuBar.class$("javax.baja.ui.BMenu")) : class$javax$baja$ui$BMenu);
            boolean[] blArray = new boolean[26];
            for (n3 = 0; n3 < bMenuArray.length; ++n3) {
                if (bMenuArray[n3].shortcut <= '\u0000') continue;
                blArray[bMenuArray[n3].shortcut - 97] = true;
            }
            block1: for (n3 = 0; n3 < bMenuArray.length; ++n3) {
                if (bMenuArray[n3].shortcut != '\u0000') continue;
                object = TextUtil.split((String)bMenuArray[n3].getText().toLowerCase(), (char)' ');
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    if (object[n2].length() <= 0 || ((String)object[n2]).charAt(0) < 'a' || ((String)object[n2]).charAt(0) > 'z' || blArray[n = ((String)object[n2]).charAt(0) - 97]) continue;
                    bMenuArray[n3].shortcut = ((String)object[n2]).charAt(0);
                    blArray[n] = true;
                    continue block1;
                }
            }
            block3: for (n3 = 0; n3 < bMenuArray.length; ++n3) {
                if (bMenuArray[n3].shortcut != '\u0000') continue;
                object = bMenuArray[n3].getText().toLowerCase();
                for (n2 = 0; n2 < ((String)object).length(); ++n2) {
                    if (((String)object).charAt(n2) < 'a' || ((String)object).charAt(n2) > 'z' || blArray[n = ((String)object).charAt(n2) - 97]) continue;
                    bMenuArray[n3].shortcut = ((String)object).charAt(n2);
                    blArray[n] = true;
                    continue block3;
                }
            }
        } else {
            BMenuItem[] bMenuItemArray = (BMenuItem[])this.getChildren(class$javax$baja$ui$BMenuItem == null ? (class$javax$baja$ui$BMenuItem = BMenuBar.class$("javax.baja.ui.BMenuItem")) : class$javax$baja$ui$BMenuItem);
            for (int i = 0; i < bMenuItemArray.length; ++i) {
                bMenuItemArray[i].shortcut = '\u0000';
            }
        }
    }

    void openLeft() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length - 1; ++i) {
            if (bWidgetArray[i + 1] != this.open) continue;
            this.open((BMenu)bWidgetArray[i]);
            return;
        }
        if (bWidgetArray.length > 0) {
            this.open((BMenu)bWidgetArray[bWidgetArray.length - 1]);
        }
    }

    void openRight() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 1; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i - 1] != this.open) continue;
            this.open((BMenu)bWidgetArray[i]);
            return;
        }
        if (bWidgetArray.length > 0) {
            this.open((BMenu)bWidgetArray[0]);
        }
    }

    private void open(BMenu bMenu) {
        if (this.open != null) {
            this.open.close();
        }
        RectGeom rectGeom = bMenu.menuBarRect;
        bMenu.open(this, rectGeom.x, rectGeom.y + rectGeom.height);
        bMenu.requestFocus();
        this.over = this.open = bMenu;
    }

    public void focus(BMenu bMenu) {
        this.requestFocus();
        this.over = bMenu;
    }

    void moveSelectionLeft() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length - 1; ++i) {
            if (bWidgetArray[i + 1] != this.over) continue;
            this.over = (BMenu)bWidgetArray[i];
            return;
        }
        if (bWidgetArray.length > 0) {
            this.over = (BMenu)bWidgetArray[bWidgetArray.length - 1];
        }
    }

    void moveSelectionRight() {
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 1; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i - 1] != this.over) continue;
            this.over = (BMenu)bWidgetArray[i];
            return;
        }
        if (bWidgetArray.length > 0) {
            this.over = (BMenu)bWidgetArray[0];
        }
    }

    public void focusGained(BFocusEvent bFocusEvent) {
        this.repaint();
        super.focusGained(bFocusEvent);
    }

    public void focusLost(BFocusEvent bFocusEvent) {
        this.repaint();
        super.focusLost(bFocusEvent);
    }

    public void menuClosed(BMenu bMenu) {
        this.open = null;
        this.repaint();
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        this.mouseOver = true;
        this.over = this.itemAt(bMouseEvent);
        this.repaint();
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        this.mouseOver = false;
        this.repaint();
    }

    public void mouseMoved(BMouseEvent bMouseEvent) {
        BMenu bMenu = this.over;
        this.over = this.itemAt(bMouseEvent);
        if (this.over != null && this.open != null && this.open != this.over) {
            this.open(this.over);
        }
        if (bMenu != this.over) {
            this.repaint();
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.over != null) {
            this.open(this.over);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.open != null && this.open.isOpen()) {
            this.open.requestFocus();
        }
    }

    private BMenu itemAt(BMouseEvent bMouseEvent) {
        double d = bMouseEvent.getX();
        double d2 = bMouseEvent.getY();
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BMenu bMenu = (BMenu)bWidgetArray[i];
            if (!bMenu.menuBarRect.contains(d, d2)) continue;
            return bMenu;
        }
        return null;
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        block0 : switch (bKeyEvent.getKeyCode()) {
            case 40: {
                this.open(this.over);
                bKeyEvent.consume();
                break;
            }
            case 37: {
                this.moveSelectionLeft();
                bKeyEvent.consume();
                this.repaint();
                break;
            }
            case 39: {
                this.moveSelectionRight();
                bKeyEvent.consume();
                this.repaint();
                break;
            }
            default: {
                if (bKeyEvent.getKeyChar() < 'a' || bKeyEvent.getKeyChar() > 'z') break;
                BMenu[] bMenuArray = (BMenu[])this.getChildren(class$javax$baja$ui$BMenu == null ? (class$javax$baja$ui$BMenu = BMenuBar.class$("javax.baja.ui.BMenu")) : class$javax$baja$ui$BMenu);
                for (int i = 0; i < bMenuArray.length; ++i) {
                    if (bMenuArray[i].shortcut != bKeyEvent.getKeyChar()) continue;
                    this.open(bMenuArray[i]);
                    bKeyEvent.consume();
                    break block0;
                }
            }
        }
    }

    public Object fw(int n, Object object, Object object2, Object object3, Object object4) {
        switch (n) {
            case 305: {
                return this;
            }
        }
        return super.fw(n, object, object2, object3, object4);
    }

    void initShell(ShellManager shellManager) {
        super.initShell(shellManager);
        BWidgetShell bWidgetShell = (BWidgetShell)shellManager.getShell();
        bWidgetShell.menuBar = this;
    }

    void cleanupShell() {
        super.cleanupShell();
        BWidgetShell bWidgetShell = (BWidgetShell)this.shellManager.getShell();
        bWidgetShell.menuBar = null;
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

