/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.ui.UiEnv;
import com.tridium.ui.theme.Theme;
import java.util.Vector;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.RectGeom;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractBar;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BCheckBoxMenuItem;
import javax.baja.ui.BMenuBar;
import javax.baja.ui.BMenuItem;
import javax.baja.ui.BRadioButtonMenuItem;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BSubMenuItem;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;

public class BMenu
extends BAbstractBar {
    public static final Property visible = BMenu.newProperty((int)0, (boolean)false);
    public static final Property text = BMenu.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$ui$BMenu == null ? (class$javax$baja$ui$BMenu = BMenu.class$("javax.baja.ui.BMenu")) : class$javax$baja$ui$BMenu));
    private static final BIcon icon = BIcon.std((String)"widgets/menu.png");
    static double acceleratorGap = 6.0;
    RectGeom menuBarRect = new RectGeom(0.0, 0.0, 0.0, 0.0);
    char shortcut = '\u0000';
    private BWidget owner;
    private double acceleratorX;
    private BMenuItem selected;
    static /* synthetic */ Class class$javax$baja$ui$BMenu;
    static /* synthetic */ Class class$javax$baja$ui$BMenuItem;

    public String getText() {
        return this.getString(text);
    }

    public void setText(String string) {
        this.setString(text, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMenu(String string) {
        this.setText(string);
    }

    public BMenu() {
    }

    public BMenuItem add(String string, Command command) {
        ToggleCommand toggleCommand;
        BActionMenuItem bActionMenuItem = command instanceof ToggleCommand ? ((toggleCommand = (ToggleCommand)command).getGroup() != null ? new BRadioButtonMenuItem(toggleCommand) : new BCheckBoxMenuItem(toggleCommand)) : new BActionMenuItem(command);
        this.add(string, (BValue)bActionMenuItem, null);
        return bActionMenuItem;
    }

    public void computePreferredSize() {
        Object object;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        BWidget[] bWidgetArray = this.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            if (bWidgetArray[i] instanceof BSeparator) {
                object = (BSeparator)bWidgetArray[i];
                ((BSeparator)object).computePreferredSize();
                d3 += ((BWidget)object).getPreferredHeight();
                continue;
            }
            object = (BMenuItem)bWidgetArray[i];
            ((BMenuItem)object).computePreferredSize();
            d = Math.max(d, ((BMenuItem)object).textWidth);
            d2 = Math.max(d2, ((BMenuItem)object).acceleratorWidth);
            d3 += ((BWidget)object).getPreferredHeight();
        }
        BInsets bInsets = Theme.menu().getInsets();
        object = Theme.menuItem().getInsets();
        double d4 = d + d2 + acceleratorGap + bInsets.left + bInsets.right + ((BInsets)object).left + ((BInsets)object).right;
        this.setPreferredSize(d4, d3 += bInsets.top + bInsets.bottom);
        this.acceleratorX = ((BInsets)object).left + d + acceleratorGap;
    }

    public void doLayout(BWidget[] bWidgetArray) {
        BInsets bInsets = Theme.menu().getInsets();
        double d = bInsets.left;
        double d2 = bInsets.top;
        double d3 = this.getWidth() - bInsets.left - bInsets.right;
        for (int i = 0; i < bWidgetArray.length; ++i) {
            BWidget bWidget = bWidgetArray[i];
            bWidget.setBounds(d, d2, d3, bWidget.getPreferredHeight());
            d2 += bWidget.getHeight();
            if (bWidget instanceof BMenuItem) {
                ((BMenuItem)bWidget).acceleratorX = this.acceleratorX;
                continue;
            }
            ((BSeparator)bWidget).setOrientation(BOrientation.horizontal);
        }
    }

    public void paint(Graphics graphics) {
        this.computeShortcutKeys();
        Theme.menu().paintBackground(graphics, this);
        this.paintChildren(graphics);
    }

    public String getStyleSelector() {
        return "menu";
    }

    private void computeShortcutKeys() {
        if (this.hasFocus()) {
            int n;
            int n2;
            int n3;
            BMenuItem[] bMenuItemArray = (BMenuItem[])this.getChildren(class$javax$baja$ui$BMenuItem == null ? (class$javax$baja$ui$BMenuItem = BMenu.class$("javax.baja.ui.BMenuItem")) : class$javax$baja$ui$BMenuItem);
            boolean[] blArray = new boolean[26];
            for (n3 = 0; n3 < bMenuItemArray.length; ++n3) {
                if (bMenuItemArray[n3].shortcut <= '\u0000') continue;
                blArray[bMenuItemArray[n3].shortcut - 97] = true;
            }
            for (n3 = 0; n3 < bMenuItemArray.length; ++n3) {
                if (bMenuItemArray[n3].getAccelerator().isNull()) continue;
                int n4 = bMenuItemArray[n3].getAccelerator().getKeyCode();
                switch (n4) {
                    case 65: {
                        n2 = 97;
                        break;
                    }
                    case 66: {
                        n2 = 98;
                        break;
                    }
                    case 67: {
                        n2 = 99;
                        break;
                    }
                    case 68: {
                        n2 = 100;
                        break;
                    }
                    case 69: {
                        n2 = 101;
                        break;
                    }
                    case 70: {
                        n2 = 102;
                        break;
                    }
                    case 71: {
                        n2 = 103;
                        break;
                    }
                    case 72: {
                        n2 = 104;
                        break;
                    }
                    case 73: {
                        n2 = 105;
                        break;
                    }
                    case 74: {
                        n2 = 106;
                        break;
                    }
                    case 75: {
                        n2 = 107;
                        break;
                    }
                    case 76: {
                        n2 = 108;
                        break;
                    }
                    case 77: {
                        n2 = 109;
                        break;
                    }
                    case 78: {
                        n2 = 110;
                        break;
                    }
                    case 79: {
                        n2 = 111;
                        break;
                    }
                    case 80: {
                        n2 = 112;
                        break;
                    }
                    case 81: {
                        n2 = 113;
                        break;
                    }
                    case 82: {
                        n2 = 114;
                        break;
                    }
                    case 83: {
                        n2 = 115;
                        break;
                    }
                    case 84: {
                        n2 = 116;
                        break;
                    }
                    case 85: {
                        n2 = 117;
                        break;
                    }
                    case 86: {
                        n2 = 118;
                        break;
                    }
                    case 87: {
                        n2 = 119;
                        break;
                    }
                    case 88: {
                        n2 = 120;
                        break;
                    }
                    case 89: {
                        n2 = 121;
                        break;
                    }
                    case 90: {
                        n2 = 122;
                        break;
                    }
                    default: {
                        n2 = 0;
                    }
                }
                if (n2 == 0 || blArray[n = n2 - 97] || bMenuItemArray[n3].getText().toLowerCase().indexOf(n2) <= -1) continue;
                bMenuItemArray[n3].shortcut = (char)n2;
                blArray[n] = true;
            }
            block30: for (n3 = 0; n3 < bMenuItemArray.length; ++n3) {
                if (bMenuItemArray[n3].shortcut != '\u0000') continue;
                String[] stringArray = TextUtil.split((String)bMenuItemArray[n3].getText().toLowerCase(), (char)' ');
                for (n2 = 0; n2 < stringArray.length; ++n2) {
                    if (stringArray[n2].length() <= 0 || stringArray[n2].charAt(0) < 'a' || stringArray[n2].charAt(0) > 'z' || blArray[n = stringArray[n2].charAt(0) - 97]) continue;
                    bMenuItemArray[n3].shortcut = stringArray[n2].charAt(0);
                    blArray[n] = true;
                    continue block30;
                }
            }
            block32: for (n3 = 0; n3 < bMenuItemArray.length; ++n3) {
                if (bMenuItemArray[n3].shortcut != '\u0000') continue;
                String string = bMenuItemArray[n3].getText().toLowerCase();
                for (n2 = 0; n2 < string.length(); ++n2) {
                    if (string.charAt(n2) < 'a' || string.charAt(n2) > 'z' || blArray[n = string.charAt(n2) - 97]) continue;
                    bMenuItemArray[n3].shortcut = string.charAt(n2);
                    blArray[n] = true;
                    continue block32;
                }
            }
        } else {
            BMenuItem[] bMenuItemArray = (BMenuItem[])this.getChildren(class$javax$baja$ui$BMenuItem == null ? (class$javax$baja$ui$BMenuItem = BMenu.class$("javax.baja.ui.BMenuItem")) : class$javax$baja$ui$BMenuItem);
            for (int i = 0; i < bMenuItemArray.length; ++i) {
                bMenuItemArray[i].shortcut = '\u0000';
            }
        }
    }

    public BMenuItem[] getMenuItems() {
        Object[] objectArray;
        Vector<Object[]> vector = new Vector<Object[]>();
        SlotCursor slotCursor = this.getProperties();
        while (slotCursor.nextComponent()) {
            objectArray = slotCursor.get();
            if (!(objectArray instanceof BMenuItem)) continue;
            vector.addElement(objectArray);
        }
        objectArray = new BMenuItem[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public BMenu getSubMenu(String string) {
        return ((BSubMenuItem)this.get(string)).getMenu();
    }

    public BMenu removeSubMenu(String string) {
        BSubMenuItem bSubMenuItem = (BSubMenuItem)this.get(string);
        BMenu bMenu = bSubMenuItem.getMenu();
        this.remove((BComplex)bSubMenuItem);
        bSubMenuItem.setMenu(new BMenu());
        return bMenu;
    }

    public BMenuItem removeMenuItem(String string) {
        BMenuItem bMenuItem = (BMenuItem)this.get(string);
        if (bMenuItem != null) {
            this.remove((BComplex)bMenuItem);
        }
        return bMenuItem;
    }

    public boolean isOpen() {
        return UiEnv.get().isPopupOpen(this);
    }

    public void open(BWidget bWidget, double d, double d2) {
        int n;
        boolean bl = false;
        for (BWidget bWidget2 = bWidget; bWidget2 != null; bWidget2 = bWidget2.getParent()) {
            if (bWidget2.fw(305) == null) continue;
            bl = true;
            break;
        }
        UiEnv.get().openPopup(this, bWidget, d, d2);
        UiEnv.get().setPopupOpacity(this, Theme.menu().getFrameOpacity());
        this.selected = null;
        BMenuItem[] bMenuItemArray = this.getMenuItems();
        for (n = 0; n < bMenuItemArray.length; ++n) {
            bMenuItemArray[n].opening(this, bl);
        }
        for (n = 0; n < bMenuItemArray.length; ++n) {
            if (!bMenuItemArray[n].isEnabled()) continue;
            this.select(bMenuItemArray[n]);
            break;
        }
        this.owner = bWidget;
    }

    public void open(BMouseEvent bMouseEvent) {
        this.open(bMouseEvent.getWidget(), bMouseEvent.getX(), bMouseEvent.getY());
    }

    void close() {
        UiEnv.get().closePopup(this);
        if (this.owner instanceof BMenuBar) {
            this.owner.requestFocus();
        }
    }

    void select(BMenuItem bMenuItem) {
        if (this.selected != null) {
            this.selected.unselect();
        }
        bMenuItem.select();
        this.selected = bMenuItem;
        this.insureSubItemPathSelected();
    }

    void unselect(BMenuItem bMenuItem) {
        bMenuItem.unselect();
        this.selected = null;
    }

    void insureSubItemPathSelected() {
        BComplex bComplex = this.getParent();
        if (bComplex instanceof BSubMenuItem) {
            BSubMenuItem bSubMenuItem = (BSubMenuItem)bComplex;
            BMenu bMenu = (BMenu)bSubMenuItem.getParent();
            bMenu.select(bSubMenuItem);
        }
    }

    void moveSelectionUp() {
        BMenuItem[] bMenuItemArray = this.getMenuItems();
        int n = this.itemIndexOf(bMenuItemArray, this.selected);
        for (int i = n - 1; i >= 0; --i) {
            if (!bMenuItemArray[i].isEnabled()) continue;
            this.select(bMenuItemArray[i]);
            return;
        }
        this.close();
    }

    void moveSelectionDown() {
        BMenuItem[] bMenuItemArray = this.getMenuItems();
        int n = this.itemIndexOf(bMenuItemArray, this.selected);
        for (int i = n + 1; i < bMenuItemArray.length; ++i) {
            if (!bMenuItemArray[i].isEnabled()) continue;
            this.select(bMenuItemArray[i]);
            break;
        }
    }

    int itemIndexOf(BMenuItem[] bMenuItemArray, BMenuItem bMenuItem) {
        for (int i = 0; i < bMenuItemArray.length; ++i) {
            if (bMenuItemArray[i] != bMenuItem) continue;
            return i;
        }
        return -1;
    }

    void moveSelectionLeft() {
        BWidget bWidget = this.getParentWidget();
        if (bWidget instanceof BSubMenuItem) {
            ((BSubMenuItem)bWidget).closeMenu();
        } else if (bWidget instanceof BMenuBar) {
            ((BMenuBar)bWidget).openLeft();
        }
    }

    void moveSelectionRight() {
        BWidget bWidget = this.getParentWidget();
        if (this.selected instanceof BSubMenuItem) {
            ((BSubMenuItem)this.selected).openMenu();
        } else if (bWidget instanceof BMenuBar) {
            ((BMenuBar)bWidget).openRight();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void keyReleased(BKeyEvent bKeyEvent) {
        if (bKeyEvent.getModifiers() != 0) {
            return;
        }
        block0 : switch (bKeyEvent.getKeyCode()) {
            case 27: {
                this.close();
                bKeyEvent.consume();
                break;
            }
            case 38: {
                this.moveSelectionUp();
                bKeyEvent.consume();
                break;
            }
            case 40: {
                this.moveSelectionDown();
                bKeyEvent.consume();
                break;
            }
            case 37: {
                this.moveSelectionLeft();
                bKeyEvent.consume();
                break;
            }
            case 39: {
                this.moveSelectionRight();
                bKeyEvent.consume();
                break;
            }
            case 10: {
                if (this.selected != null) {
                    this.selected.doClick(bKeyEvent);
                }
                bKeyEvent.consume();
                break;
            }
            default: {
                if (bKeyEvent.getKeyChar() < 'a' || bKeyEvent.getKeyChar() > 'z') break;
                BMenuItem[] bMenuItemArray = (BMenuItem[])this.getChildren(class$javax$baja$ui$BMenuItem == null ? (class$javax$baja$ui$BMenuItem = BMenu.class$("javax.baja.ui.BMenuItem")) : class$javax$baja$ui$BMenuItem);
                for (int i = 0; i < bMenuItemArray.length; ++i) {
                    if (bMenuItemArray[i].shortcut != bKeyEvent.getKeyChar()) continue;
                    this.select(bMenuItemArray[i]);
                    bMenuItemArray[i].doClick(bKeyEvent);
                    bKeyEvent.consume();
                    break block0;
                }
            }
        }
    }

    public String getDebugString() {
        return "\"" + this.getText() + "\"; ";
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static interface MenuCloseListener {
        public void menuClosed(BMenu var1);
    }
}

