/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui;

import com.tridium.gx.parser.Parser;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.sys.BDouble;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public final class BLayout
extends BSimple {
    public static final int ABS = 0;
    public static final int PERCENT = 1;
    public static final int PREF = 2;
    public static final BLayout FILL;
    public static final BLayout DEFAULT;
    public static final Type TYPE;
    double x;
    double y;
    double w;
    double h;
    int xUnit;
    int yUnit;
    int wUnit;
    int hUnit;
    String string;
    static /* synthetic */ Class class$javax$baja$ui$BLayout;

    public static BLayout make(double d, int n, double d2, int n2, double d3, int n3, double d4, int n4) {
        if (!(BLayout.isXY(n) && BLayout.isXY(n2) && BLayout.isWH(n3) && BLayout.isWH(n4))) {
            throw new IllegalArgumentException();
        }
        BLayout bLayout = new BLayout();
        bLayout.x = d;
        bLayout.y = d2;
        bLayout.w = d3;
        bLayout.h = d4;
        bLayout.xUnit = n;
        bLayout.yUnit = n2;
        bLayout.wUnit = n3;
        bLayout.hUnit = n4;
        return bLayout;
    }

    public static BLayout makeAbs(double d, double d2, double d3, double d4) {
        return BLayout.make(d, 0, d2, 0, d3, 0, d4, 0);
    }

    static boolean isXY(int n) {
        return n == 0 || n == 1;
    }

    static boolean isWH(int n) {
        return n == 0 || n == 1 || n == 2;
    }

    public static BLayout make(String string) {
        try {
            Parser parser = new Parser(string);
            BLayout bLayout = new BLayout();
            if (parser.cur.id("fill")) {
                return FILL;
            }
            bLayout.x = parser.cur.num;
            if (parser.cur.num()) {
                bLayout.xUnit = 0;
            } else if (parser.cur.dimen("%")) {
                bLayout.xUnit = 1;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            bLayout.y = parser.cur.num;
            if (parser.cur.num()) {
                bLayout.yUnit = 0;
            } else if (parser.cur.dimen("%")) {
                bLayout.yUnit = 1;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            bLayout.w = parser.cur.num;
            if (parser.cur.num()) {
                bLayout.wUnit = 0;
            } else if (parser.cur.dimen("%")) {
                bLayout.wUnit = 1;
            } else if (parser.cur.id("pref")) {
                bLayout.wUnit = 2;
            } else {
                throw new Exception();
            }
            parser.consume();
            parser.match(2);
            bLayout.h = parser.cur.num;
            if (parser.cur.num()) {
                bLayout.hUnit = 0;
            } else if (parser.cur.dimen("%")) {
                bLayout.hUnit = 1;
            } else if (parser.cur.id("pref")) {
                bLayout.hUnit = 2;
            } else {
                throw new Exception();
            }
            return bLayout;
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(string);
        }
    }

    private BLayout() {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.w;
    }

    public double getHeight() {
        return this.h;
    }

    public int getXUnit() {
        return this.xUnit;
    }

    public int getYUnit() {
        return this.yUnit;
    }

    public int getWidthUnit() {
        return this.wUnit;
    }

    public int getHeightUnit() {
        return this.hUnit;
    }

    public int hashCode() {
        long l = 23L + Double.doubleToRawLongBits(this.x);
        l = l * 37L + Double.doubleToRawLongBits(this.y);
        l = l * 37L + Double.doubleToRawLongBits(this.w);
        l = l * 37L + Double.doubleToRawLongBits(this.h);
        l = l * 37L + (long)this.xUnit;
        l = l * 37L + (long)this.yUnit;
        l = l * 37L + (long)this.wUnit;
        l = l * 37L + (long)this.hUnit;
        return (int)(l >>> 32) ^ (int)l;
    }

    public boolean equals(Object object) {
        if (object instanceof BLayout) {
            BLayout bLayout = (BLayout)((Object)object);
            return this.x == bLayout.x && this.y == bLayout.y && this.w == bLayout.w && this.h == bLayout.h && this.xUnit == bLayout.xUnit && this.yUnit == bLayout.yUnit && this.wUnit == bLayout.wUnit && this.hUnit == bLayout.hUnit;
        }
        return false;
    }

    public void encode(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.encodeToString());
    }

    public BObject decode(DataInput dataInput) throws IOException {
        return BLayout.make(dataInput.readUTF());
    }

    public String encodeToString() {
        if (this.string == null) {
            if (this == FILL) {
                return "fill";
            }
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(BDouble.encode((double)this.x));
            if (this.xUnit == 1) {
                stringBuffer.append('%');
            }
            stringBuffer.append(',');
            stringBuffer.append(BDouble.encode((double)this.y));
            if (this.yUnit == 1) {
                stringBuffer.append('%');
            }
            stringBuffer.append(',');
            if (this.wUnit == 2) {
                stringBuffer.append("pref");
            } else {
                stringBuffer.append(BDouble.encode((double)this.w));
                if (this.wUnit == 1) {
                    stringBuffer.append('%');
                }
            }
            stringBuffer.append(',');
            if (this.hUnit == 2) {
                stringBuffer.append("pref");
            } else {
                stringBuffer.append(BDouble.encode((double)this.h));
                if (this.hUnit == 1) {
                    stringBuffer.append('%');
                }
            }
            this.string = stringBuffer.toString();
        }
        return this.string;
    }

    public BObject decodeFromString(String string) throws IOException {
        return BLayout.make(string);
    }

    public Type getType() {
        return TYPE;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        DEFAULT = FILL = BLayout.make(0.0, 0, 0.0, 0, 100.0, 1, 100.0, 1);
        TYPE = Sys.loadType((Class)(class$javax$baja$ui$BLayout == null ? (class$javax$baja$ui$BLayout = BLayout.class$("javax.baja.ui.BLayout")) : class$javax$baja$ui$BLayout));
    }
}

